/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import visualizer.corpus.Corpus;
import visualizer.datamining.clustering.Kmeans;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.Euclidean;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.transformation.MatrixTransformation;
import visualizer.textprocessing.transformation.MatrixTransformationFactory;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.ItemSetsWriter;
import visualizer.tools.apriori.RuleSet;
import visualizer.topic.RuleTopic;
import visualizer.topic.StringBox;
import visualizer.topic.TopicData;
import visualizer.topic.TopicFactory;
import visualizer.view.ProjectionExplorerView;
import visualizer.view.Viewer;
import visualizer.view.tools.RuleCoverOptions;

public class RulesTopicGrid {
    private PrintWriter out;
    private boolean ducOut = true;
    private ArrayList<Vertex> RemainderOverRuns;
    private Viewer panel;
    private ProjectionExplorerView parent;

    public RulesTopicGrid(Viewer panel, ProjectionExplorerView parent) {
        this.panel = panel;
        this.parent = parent;
    }

    public void execute() {
        if (this.panel.getGraph().getCorpus() != null) {
            int slices;
            RuleCoverOptions rulCovOpt = RuleCoverOptions.getInstance(this.parent).display();
            try {
                this.out = new PrintWriter(new FileWriter("dumpRuleMetaData.txt"));
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            TopicData tdata = this.panel.getGraph().getTopicData();
            JFileChooser file = new JFileChooser();
            file.resetChoosableFileFilters();
            file.setAcceptAllFileFilterUsed(false);
            file.setMultiSelectionEnabled(false);
            file.setSelectedFile(new File(tdata.getCsvFileName()));
            int result = file.showSaveDialog(this.parent);
            if (result == 0) {
                tdata.setCsvFileName(file.getSelectedFile().getAbsolutePath());
            }
            Corpus corpora = this.panel.getGraph().getCorpus();
            if (tdata.getMatrix() == null) {
                Preprocessor pp = new Preprocessor(corpora);
                try {
                    Matrix matrix = pp.getMatrix(tdata.getLunhLowerCut(), tdata.getLunhUpperCut(), tdata.getNumberGrams(), tdata.getStemmer(), tdata.isUseStopword());
                    MatrixTransformation transf = MatrixTransformationFactory.getInstance(tdata.getMatrixTransformationType());
                    matrix = transf.tranform(matrix, null);
                    tdata.setMatrix(matrix);
                    tdata.setCorporaNgrams(pp.getNgrams());
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                float[][] points = tdata.getMatrix().toMatrix();
                PrintWriter outPoints = new PrintWriter(new FileWriter("pointsDump.txt"));
                for (int i = 0; i < points.length; ++i) {
                    for (int j = 0; j < points[0].length; ++j) {
                        outPoints.print(points[i][j] + "\t");
                    }
                    outPoints.println();
                }
                outPoints.close();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            tdata.getTermSetRun().clear();
            tdata.getTermSetRunW().clear();
            String allDump = "";
            HashSet<ItemSet> ruleSet = new HashSet<ItemSet>();
            HashSet<ItemSet> selectedRuleSet = new HashSet<ItemSet>();
            boolean useInc = true;
            if (rulCovOpt.getStrategy() == RuleCoverOptions.StrategyType.TOPIC_ST) {
                this.RemainderOverRuns = this.panel.getGraph().getVertex();
                this.runOverTopic(allDump, ruleSet, selectedRuleSet, 0);
            }
            if (rulCovOpt.getStrategy() == RuleCoverOptions.StrategyType.CLUSTER_ST) {
                this.RemainderOverRuns = this.panel.getGraph().getVertex();
                System.out.println("Max Clusters:" + Math.sqrt(this.RemainderOverRuns.size()));
                int maxClusters = rulCovOpt.getMax();
                int nclusters = rulCovOpt.getMin();
                int incClusters = rulCovOpt.getInc();
                int currentRun = 0;
                if (incClusters > 0) {
                    for (nclusters = rulCovOpt.getMin(); nclusters <= maxClusters; nclusters += incClusters) {
                        System.out.println("%%%%%%%%%%%N. Clusters:" + nclusters);
                        this.runOverClusters(nclusters, allDump, ruleSet, selectedRuleSet, 0, 0, currentRun++);
                    }
                } else if (incClusters < 0) {
                    for (nclusters = rulCovOpt.getMin(); nclusters >= maxClusters; nclusters += incClusters) {
                        System.out.println("%%%%%%%%%%%N. Clusters:" + nclusters);
                        this.runOverClusters(nclusters, allDump, ruleSet, selectedRuleSet, 0, 0, currentRun++);
                    }
                } else {
                    nclusters = rulCovOpt.getMin();
                    for (int count = 0; count < maxClusters; ++count) {
                        System.out.println("%%%%%%%%%%%N. Clusters:" + nclusters + "Run:" + count);
                        this.runOverClusters(nclusters, allDump, ruleSet, selectedRuleSet, 0, 0, currentRun++);
                    }
                }
            }
            if (rulCovOpt.getStrategy() == RuleCoverOptions.StrategyType.RESIZE_ST) {
                this.RemainderOverRuns = this.panel.getGraph().getVertex();
                for (slices = rulCovOpt.getMin(); slices <= rulCovOpt.getMax(); ++slices) {
                    if (useInc) {
                        this.runOverGridIncCover(slices, allDump, ruleSet, selectedRuleSet, 0, 0);
                        continue;
                    }
                    this.runOverGrid(slices, allDump, ruleSet, selectedRuleSet, 0, 0);
                }
            }
            if (rulCovOpt.getStrategy() == RuleCoverOptions.StrategyType.MOVE_ST) {
                slices = rulCovOpt.getSlices();
                int subSlices = rulCovOpt.getSubSlices();
                int xSubSlice = (int)(this.panel.getSize().getWidth() / (double)slices / (1.0 * (double)subSlices));
                int ySubSlice = (int)(this.panel.getSize().getHeight() / (double)slices / (1.0 * (double)subSlices));
                this.RemainderOverRuns = this.panel.getGraph().getVertex();
                for (int i = 0; i < subSlices; ++i) {
                    int xDelta = -i * xSubSlice;
                    int yDelta = -i * ySubSlice;
                    if (useInc) {
                        this.runOverGridIncCover(slices, allDump, ruleSet, selectedRuleSet, xDelta, yDelta);
                        continue;
                    }
                    this.runOverGrid(slices, allDump, ruleSet, selectedRuleSet, xDelta, yDelta);
                }
            }
            this.out.close();
            System.out.println("All Rules:" + ruleSet.size());
            System.out.println("Selected Rules:" + selectedRuleSet.size());
            ArrayList<ItemSet> selectedRuleSetList = new ArrayList<ItemSet>();
            selectedRuleSetList.addAll(selectedRuleSet);
            ItemSetsWriter.outRulesDocs("SelectedRules", this.panel.getGraph().getTopicData().getMatrix().toMatrix(), selectedRuleSetList, this.panel.getGraph().getCorpus());
            ItemSetsWriter.outRulesNames("SelectedRules", selectedRuleSetList);
        }
    }

    private ArrayList<ArrayList<Integer>> createClusters(int nclusters) {
        ArrayList<ArrayList<Integer>> clusters;
        float[][] points = new float[this.panel.getGraph().getVertex().size()][];
        DenseMatrix matrix = new DenseMatrix();
        for (int i = 0; i < points.length; ++i) {
            float[] point = new float[]{this.panel.getGraph().getVertex().get(i).getX(), this.panel.getGraph().getVertex().get(i).getY()};
            ((Matrix)matrix).addRow(new DenseVector(point));
        }
        try {
            Kmeans km = new Kmeans(nclusters);
            clusters = km.execute(new Euclidean(), matrix);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        Scalar s = this.panel.getGraph().addScalar("kmeans-" + clusters.size());
        for (int c = 0; c < clusters.size(); ++c) {
            for (int v = 0; v < clusters.get(c).size(); ++v) {
                this.panel.getGraph().getVertex().get(clusters.get(c).get(v)).setScalar(s, c);
            }
        }
        this.panel.updateScalars(null);
        return clusters;
    }

    private void runOverClusters(int nclusters, String allDump, Set<ItemSet> ruleSet, Set<ItemSet> selectedRuleSet, int xDelta, int yDelta, int currentRun) {
        ArrayList<ArrayList<Integer>> clusters = this.createClusters(nclusters);
        HashMap<String, Integer> pointLine = new HashMap<String, Integer>();
        ArrayList<Vertex> vertex = this.panel.getGraph().getVertex();
        ArrayList<Vertex> RemainderVertex = vertex;
        Corpus corpora = this.panel.getGraph().getCorpus();
        for (int i = 0; i < corpora.getIds().size(); ++i) {
            pointLine.put(corpora.getIds().get(i), new Integer(i));
        }
        for (int c = 0; c < clusters.size(); ++c) {
            this.out.print(c + "," + c + "," + 0 + ",");
            ArrayList<Vertex> selectedVertices = new ArrayList<Vertex>();
            for (int v = 0; v < clusters.get(c).size(); ++v) {
                selectedVertices.add(this.panel.getGraph().getVertex().get(clusters.get(c).get(v)));
            }
            this.out.print(selectedVertices.size() + ",");
            if (selectedVertices.size() == 0) {
                this.out.println();
                continue;
            }
            TopicData ldata = this.panel.getGraph().getTopicData();
            ldata.setCurrentRun(currentRun);
            ldata.setCurrentSelection(c);
            RuleTopic ruleTopic = new RuleTopic(selectedVertices, this.panel.getGraph().getCorpus(), ldata);
            this.panel.addTopic(ruleTopic);
            ruleSet.addAll(ruleTopic.getItemSets());
            int sizeBefore = selectedRuleSet.size();
            selectedRuleSet.addAll(ruleTopic.getSelectedItemSets());
            this.out.print(ruleTopic.getSelectedItemSets().size() + ",");
            this.out.print(sizeBefore - selectedRuleSet.size() + ",");
            this.out.print(selectedVertices.size() - ruleTopic.getVertexRemainder().size() + ",");
            allDump = allDump + "==========\n" + ruleTopic.ruleDump;
            if (ruleTopic.getSelectedItemSets().size() == 0) {
                this.out.println();
                continue;
            }
            float[][] points = ldata.getMatrix().toMatrix();
            ArrayList<Vertex> PreviousVertex = RemainderVertex;
            RemainderVertex = new ArrayList();
            int lineIndex = -1;
            for (int m = 0; m < PreviousVertex.size(); ++m) {
                Vertex v = PreviousVertex.get(m);
                if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                    lineIndex = (int)v.getId();
                } else {
                    for (int k = 0; k < corpora.getIds().size(); ++k) {
                        if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                        lineIndex = k;
                        break;
                    }
                }
                boolean covered = false;
                for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                    boolean found = true;
                    for (Integer I : iS.getItems()) {
                        found = found && points[lineIndex][I] > 0.0f;
                    }
                    if (!found) continue;
                    covered = true;
                    break;
                }
                if (covered) continue;
                RemainderVertex.add(v);
            }
            System.out.println("==========\nVertex Size:" + vertex.size());
            System.out.println("Selected Size:" + selectedVertices.size());
            System.out.println("Previous Size:" + PreviousVertex.size());
            System.out.println("Remainder Size:" + RemainderVertex.size() + "\n==========");
            this.out.print(vertex.size() - RemainderVertex.size() + ",");
            boolean coveredCount = false;
            lineIndex = -1;
            ArrayList<Vertex> PreviousOverRuns = this.RemainderOverRuns;
            this.RemainderOverRuns = new ArrayList();
            for (int m = 0; m < PreviousOverRuns.size(); ++m) {
                Vertex v = PreviousOverRuns.get(m);
                if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                    lineIndex = (int)v.getId();
                } else {
                    for (int k = 0; k < corpora.getIds().size(); ++k) {
                        if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                        lineIndex = k;
                        break;
                    }
                }
                boolean covered = false;
                for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                    boolean found = true;
                    for (Integer I : iS.getItems()) {
                        found = found && points[lineIndex][I] > 0.0f;
                    }
                    if (!found) continue;
                    covered = true;
                    break;
                }
                if (covered) continue;
                this.RemainderOverRuns.add(v);
            }
            this.out.println(this.RemainderOverRuns.size());
            PreviousVertex = null;
        }
    }

    private void runOverGrid(int slices, String allDump, Set<ItemSet> ruleSet, Set<ItemSet> selectedRuleSet, int xDelta, int yDelta) {
        int xSize = (int)this.panel.getSize().getWidth() / slices;
        int ySize = (int)this.panel.getSize().getHeight() / slices;
        Point source = null;
        Point target = null;
        for (int i = 0; i < slices; ++i) {
            for (int j = 0; j < slices; ++j) {
                source = new Point(i * xSize + xDelta, j * ySize + yDelta);
                target = new Point((i + 1) * xSize - 1 + xDelta, (j + 1) * ySize - 1 + yDelta);
                System.out.println(i + "," + j + ": Source" + source + "\tTarget:" + target);
                Rectangle subPos = new Rectangle();
                ArrayList<Vertex> selectedVertices = this.panel.getSelectedVertex(source, target);
                System.out.println("Vertices:" + selectedVertices.size());
                if (selectedVertices.size() == 0) continue;
                TopicData ldata = this.panel.getGraph().getTopicData();
                RuleTopic ruleTopic = new RuleTopic(selectedVertices, this.panel.getGraph().getCorpus(), ldata);
                this.panel.addTopic(ruleTopic);
                ruleSet.addAll(ruleTopic.getItemSets());
                selectedRuleSet.addAll(ruleTopic.getSelectedItemSets());
                allDump = allDump + "==========\n" + ruleTopic.ruleDump;
            }
        }
    }

    private void runOverTopic(String allDump, Set<ItemSet> ruleSet, Set<ItemSet> selectedRuleSet, int currentRun) {
        HashMap pointLine = new HashMap();
        ArrayList<Vertex> vertex = this.panel.getGraph().getVertex();
        ArrayList<Vertex> RemainderVertex = vertex;
        Corpus corpora = this.panel.getGraph().getCorpus();
        Scalar s = this.panel.getGraph().getScalarByName("TOPIC");
        HashSet<Float> scalarValueSet = new HashSet<Float>();
        for (int v = 0; v < this.panel.getGraph().getVertex().size(); ++v) {
            Float f = Float.valueOf(this.panel.getGraph().getVertex().get(v).getScalar(s));
            scalarValueSet.add(f);
        }
        int c = 0;
        for (Float scalarValue : scalarValueSet) {
            ++c;
            this.out.print("::" + scalarValue + "::");
            ArrayList<Vertex> selectedVertices = new ArrayList<Vertex>();
            for (int v = 0; v < this.panel.getGraph().getVertex().size(); ++v) {
                if (this.panel.getGraph().getVertex().get(v).getScalar(s) != scalarValue.floatValue()) continue;
                selectedVertices.add(this.panel.getGraph().getVertex().get(v));
            }
            if (!this.ducOut) {
                this.out.print(selectedVertices.size() + ",");
            }
            if (selectedVertices.size() == 0) {
                this.out.println();
                continue;
            }
            TopicData ldata = this.panel.getGraph().getTopicData();
            ldata.setCurrentRun(currentRun);
            ldata.setCurrentSelection(c);
            RuleTopic ruleTopic = (RuleTopic)TopicFactory.getInstance(this.panel.getGraph(), ldata, this.panel.getGraph().getCorpus(), selectedVertices);
            ruleSet.addAll(ruleTopic.getItemSets());
            int sizeBefore = selectedRuleSet.size();
            selectedRuleSet.addAll(ruleTopic.getSelectedItemSets());
            if (!this.ducOut) {
                this.out.print(ruleTopic.getSelectedItemSets().size() + ",");
                this.out.print(sizeBefore - selectedRuleSet.size() + ",");
                this.out.print(selectedVertices.size() - ruleTopic.getVertexRemainder().size() + ",");
            }
            allDump = allDump + "==========\n" + ruleTopic.ruleDump;
            if (ruleTopic.getSelectedItemSets().size() == 0) {
                this.out.println();
                continue;
            }
            if (this.ducOut) {
                File dirROUGE = new File("C:/Users/robertopinho/Documents/edu_what/research_what/corpora_what/DUC_where/temp");
                String rougeFileName = "D" + scalarValue.intValue() + ".M.100.T.202";
                TopicData shortTopic = new TopicData(null);
                shortTopic.setRuleTopic(false);
                shortTopic.setShortPhrase(true);
                try {
                    PrintWriter outROUGE = new PrintWriter(new File(dirROUGE, rougeFileName));
                    for (StringBox box : ruleTopic.boxes) {
                        this.out.println(box.getMsg());
                        outROUGE.println(box.getMsg());
                        RuleSet rs = (RuleSet)box.getUserObject();
                        for (ItemSet is : rs.rules) {
                            outROUGE.println(is.getTopic(shortTopic));
                        }
                    }
                    outROUGE.close();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.panel.addTopic(ruleTopic);
            float[][] points = ldata.getMatrix().toMatrix();
            ArrayList<Vertex> PreviousVertex = RemainderVertex;
            RemainderVertex = new ArrayList();
            int lineIndex = -1;
            for (int m = 0; m < PreviousVertex.size(); ++m) {
                Vertex v = PreviousVertex.get(m);
                if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                    lineIndex = (int)v.getId();
                } else {
                    for (int k = 0; k < corpora.getIds().size(); ++k) {
                        if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                        lineIndex = k;
                        break;
                    }
                }
                boolean covered = false;
                for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                    boolean found = true;
                    for (Integer I : iS.getItems()) {
                        found = found && points[lineIndex][I] > 0.0f;
                    }
                    if (!found) continue;
                    covered = true;
                    break;
                }
                if (covered) continue;
                RemainderVertex.add(v);
            }
            System.out.println("==========\nVertex Size:" + vertex.size());
            System.out.println("Selected Size:" + selectedVertices.size());
            System.out.println("Previous Size:" + PreviousVertex.size());
            System.out.println("Remainder Size:" + RemainderVertex.size() + "\n==========");
            if (!this.ducOut) {
                this.out.print(vertex.size() - RemainderVertex.size() + ",");
            }
            boolean coveredCount = false;
            lineIndex = -1;
            ArrayList<Vertex> PreviousOverRuns = this.RemainderOverRuns;
            this.RemainderOverRuns = new ArrayList();
            for (int m = 0; m < PreviousOverRuns.size(); ++m) {
                Vertex v = PreviousOverRuns.get(m);
                if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                    lineIndex = (int)v.getId();
                } else {
                    for (int k = 0; k < corpora.getIds().size(); ++k) {
                        if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                        lineIndex = k;
                        break;
                    }
                }
                boolean covered = false;
                for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                    boolean found = true;
                    for (Integer I : iS.getItems()) {
                        found = found && points[lineIndex][I] > 0.0f;
                    }
                    if (!found) continue;
                    covered = true;
                    break;
                }
                if (covered) continue;
                this.RemainderOverRuns.add(v);
            }
            if (!this.ducOut) {
                this.out.println(this.RemainderOverRuns.size());
            }
            PreviousVertex = null;
        }
    }

    private void runOverGridIncCover(int slices, String allDump, Set<ItemSet> ruleSet, Set<ItemSet> selectedRuleSet, int xDelta, int yDelta) {
        int i;
        int xSize = (int)this.panel.getSize().getWidth() / slices;
        int ySize = (int)this.panel.getSize().getHeight() / slices;
        Point source = null;
        Point target = null;
        ArrayList<Vertex> vertex = this.panel.getGraph().getVertex();
        ArrayList<Vertex> RemainderVertex = vertex;
        HashMap<String, Integer> pointLine = new HashMap<String, Integer>();
        Corpus corpora = this.panel.getGraph().getCorpus();
        for (i = 0; i < corpora.getIds().size(); ++i) {
            pointLine.put(corpora.getIds().get(i), new Integer(i));
        }
        for (i = 0; i < slices; ++i) {
            for (int j = 0; j < slices; ++j) {
                this.out.print(i * slices + j + "," + i + "," + j + ",");
                source = new Point(i * xSize + xDelta, j * ySize + yDelta);
                target = new Point((i + 1) * xSize - 1 + xDelta, (j + 1) * ySize - 1 + yDelta);
                System.out.println(i + "," + j + ": Source" + source + "\tTarget:" + target);
                Rectangle subPos = new Rectangle();
                ArrayList<Vertex> selectedVertices = this.getSelectedVertex(RemainderVertex, source, target);
                this.out.print(selectedVertices.size() + ",");
                System.out.println("Vertices:" + selectedVertices.size());
                if (selectedVertices.size() == 0) {
                    this.out.println();
                    continue;
                }
                TopicData ldata = this.panel.getGraph().getTopicData();
                RuleTopic ruleTopic = new RuleTopic(selectedVertices, this.panel.getGraph().getCorpus(), ldata);
                this.panel.addTopic(ruleTopic);
                ruleSet.addAll(ruleTopic.getItemSets());
                int sizeBefore = selectedRuleSet.size();
                selectedRuleSet.addAll(ruleTopic.getSelectedItemSets());
                this.out.print(ruleTopic.getSelectedItemSets().size() + ",");
                this.out.print(sizeBefore - selectedRuleSet.size() + ",");
                this.out.print(selectedVertices.size() - ruleTopic.getVertexRemainder().size() + ",");
                allDump = allDump + "==========\n" + ruleTopic.ruleDump;
                if (ruleTopic.getSelectedItemSets().size() == 0) {
                    this.out.println();
                    continue;
                }
                float[][] points = ldata.getMatrix().toMatrix();
                ArrayList<Vertex> PreviousVertex = RemainderVertex;
                RemainderVertex = new ArrayList();
                int lineIndex = -1;
                for (int m = 0; m < PreviousVertex.size(); ++m) {
                    Vertex v = PreviousVertex.get(m);
                    if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                        lineIndex = (int)v.getId();
                    } else {
                        for (int k = 0; k < corpora.getIds().size(); ++k) {
                            if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                            lineIndex = k;
                            break;
                        }
                    }
                    boolean covered = false;
                    for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                        boolean found = true;
                        for (Integer I : iS.getItems()) {
                            found = found && points[lineIndex][I] > 0.0f;
                        }
                        if (!found) continue;
                        covered = true;
                        break;
                    }
                    if (covered) continue;
                    RemainderVertex.add(v);
                }
                System.out.println("==========\nVertex Size:" + vertex.size());
                System.out.println("Selected Size:" + selectedVertices.size());
                System.out.println("Previous Size:" + PreviousVertex.size());
                System.out.println("Remainder Size:" + RemainderVertex.size() + "\n==========");
                this.out.print(vertex.size() - RemainderVertex.size() + ",");
                boolean coveredCount = false;
                lineIndex = -1;
                ArrayList<Vertex> PreviousOverRuns = this.RemainderOverRuns;
                this.RemainderOverRuns = new ArrayList();
                for (int m = 0; m < PreviousOverRuns.size(); ++m) {
                    Vertex v = PreviousOverRuns.get(m);
                    if (corpora.getIds().get((int)v.getId()).equals(v.getUrl())) {
                        lineIndex = (int)v.getId();
                    } else {
                        for (int k = 0; k < corpora.getIds().size(); ++k) {
                            if (!corpora.getIds().get(k).equals(v.getUrl())) continue;
                            lineIndex = k;
                            break;
                        }
                    }
                    boolean covered = false;
                    for (ItemSet iS : ruleTopic.getSelectedItemSets()) {
                        boolean found = true;
                        for (Integer I : iS.getItems()) {
                            found = found && points[lineIndex][I] > 0.0f;
                        }
                        if (!found) continue;
                        covered = true;
                        break;
                    }
                    if (covered) continue;
                    this.RemainderOverRuns.add(v);
                }
                this.out.println(this.RemainderOverRuns.size());
                PreviousVertex = null;
            }
        }
    }

    private ArrayList<Vertex> getSelectedVertex(ArrayList<Vertex> vertex, Point localSource, Point localTarget) {
        ArrayList<Vertex> selectedVertex = new ArrayList<Vertex>();
        int x = localSource.x;
        int width = localTarget.x - localSource.x;
        int y = localSource.y;
        int height = localTarget.y - localSource.y;
        if (localSource.x > localTarget.x) {
            x = localTarget.x;
            width = localSource.x - localTarget.x;
        }
        if (localSource.y > localTarget.y) {
            y = localTarget.y;
            height = localSource.y - localTarget.y;
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        for (Vertex v : vertex) {
            if (!v.isInside(rect)) continue;
            selectedVertex.add(v);
        }
        return selectedVertex;
    }
}

