/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import visualizer.corpus.Corpus;
import visualizer.graph.Graph;
import visualizer.matrix.Matrix;
import visualizer.textprocessing.Ngram;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformationType;

public class TopicData {
    private float percentageTopics = 0.75f;
    private float percentageTerms = 0.5f;
    private int lowerCut = 2;
    private int upperCut = 150;
    private int numberGrams = 1;
    private MatrixTransformationType matrixType = MatrixTransformationType.TF_IDF;
    private Matrix matrix;
    private ArrayList<Ngram> corporaNgrams = null;
    private Float weightBeta = Float.valueOf(1.0f);
    private StemmerType stemmer = StemmerType.NONE;
    private boolean useStopword = true;
    private boolean groupTopics = false;
    private float minSup = 40.0f;
    private int minSupAbs = 5;
    private SupportType supportType = SupportType.RELATIVE;
    private int currentRun = 0;
    private int currentSelection = 0;
    private WeightType weightType = WeightType.LOCAL;
    private TopicType topicType = TopicType.COVARIANCE;
    private ClusteringType clusteringType = ClusteringType.KMEANS;
    private Set<String> termSetAccum = new HashSet<String>();
    private Set<String> termSetRun = new HashSet<String>();
    private Set<String> termSetAccumW = new HashSet<String>();
    private Set<String> termSetRunW = new HashSet<String>();
    private Corpus corpus = null;
    private boolean ruleTopic = true;
    private boolean phrase = false;
    private boolean shortPhrase = false;
    private String csvFileName = null;
    private Graph graph;

    public TopicData(Graph graph) {
        this.graph = graph;
    }

    public float getPercentageTopics() {
        return this.percentageTopics;
    }

    public void setPercentageTopics(float percentageTopics) {
        this.percentageTopics = percentageTopics;
    }

    public float getPercentageTerms() {
        return this.percentageTerms;
    }

    public void setPercentageTerms(float percentageTerms) {
        this.percentageTerms = percentageTerms;
    }

    public void setMinSup(float minSup) {
        this.minSup = minSup;
    }

    public int getMinSupAbs() {
        return this.minSupAbs;
    }

    public void setMinSupAbs(int minSupAbs) {
        this.minSupAbs = minSupAbs;
    }

    public SupportType getSupportType() {
        return this.supportType;
    }

    public void setSupportType(SupportType supportType) {
        this.supportType = supportType;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public int getLunhLowerCut() {
        return this.lowerCut;
    }

    public void setLunhLowerCut(int lowerCut) {
        if (this.lowerCut != lowerCut) {
            this.setMatrix(null);
        }
        this.lowerCut = lowerCut;
    }

    public int getLunhUpperCut() {
        return this.upperCut;
    }

    public void setLunhUpperCut(int upperCut) {
        if (this.upperCut != upperCut) {
            this.setMatrix(null);
        }
        this.upperCut = upperCut;
    }

    public int getNumberGrams() {
        return this.numberGrams;
    }

    public void setNumberGrams(int numberGrams) {
        if (this.numberGrams != numberGrams) {
            this.setMatrix(null);
        }
        this.numberGrams = numberGrams;
    }

    public MatrixTransformationType getMatrixTransformationType() {
        return this.matrixType;
    }

    public void setMatrixTransformationType(MatrixTransformationType matrixType) {
        if (this.matrixType != matrixType) {
            this.setMatrix(null);
        }
        this.matrixType = matrixType;
    }

    public ArrayList<Ngram> getCorporaNgrams() {
        return this.corporaNgrams;
    }

    public void setCorporaNgrams(ArrayList<Ngram> corporaNgrams) {
        this.corporaNgrams = corporaNgrams;
    }

    public WeightType getWeightType() {
        return this.weightType;
    }

    public void setWeightType(WeightType weightType) {
        this.weightType = weightType;
    }

    public Float getWeightBeta() {
        return this.weightBeta;
    }

    public void setWeightBeta(Float weightBeta) {
        this.weightBeta = weightBeta;
    }

    public TopicType getTopicType() {
        return this.topicType;
    }

    public void setTopicType(TopicType topicType) {
        this.topicType = topicType;
    }

    public StemmerType getStemmer() {
        return this.stemmer;
    }

    public void setStemmer(StemmerType stemmer) {
        if (this.stemmer != stemmer) {
            this.setMatrix(null);
        }
        this.stemmer = stemmer;
    }

    public void setTermSetAccum(Set<String> termSet) {
        this.termSetAccum = termSet;
    }

    public Set<String> getTermSetAccum() {
        return this.termSetAccum;
    }

    public boolean isUseStopword() {
        return this.useStopword;
    }

    public void setUseStopword(boolean useStopword) {
        if (this.useStopword != useStopword) {
            this.setMatrix(null);
        }
        this.useStopword = useStopword;
    }

    public boolean isGroupTopics() {
        return this.groupTopics;
    }

    public void setGroupTopics(boolean groupTopics) {
        this.groupTopics = groupTopics;
    }

    public float getMinSup() {
        return this.minSup;
    }

    public ClusteringType getClusteringType() {
        return this.clusteringType;
    }

    public void setClusteringType(ClusteringType clusteringType) {
        this.clusteringType = clusteringType;
    }

    public int getCurrentRun() {
        return this.currentRun;
    }

    public void setCurrentRun(int currentRun) {
        this.currentRun = currentRun;
    }

    public int getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(int currentSelection) {
        this.currentSelection = currentSelection;
    }

    public String getCsvFileName() {
        if (this.csvFileName == null) {
            return "ruleDump.csv";
        }
        return this.csvFileName;
    }

    public void setCsvFileName(String csvFileName) {
        this.csvFileName = csvFileName;
    }

    public Set<String> getTermSetRun() {
        return this.termSetRun;
    }

    public void setTermSetRun(Set<String> termSetRun) {
        this.termSetRun = termSetRun;
    }

    public Set<String> getTermSetAccumW() {
        return this.termSetAccumW;
    }

    public void setTermSetAccumW(Set<String> termSetAccumW) {
        this.termSetAccumW = termSetAccumW;
    }

    public Set<String> getTermSetRunW() {
        return this.termSetRunW;
    }

    public void setTermSetRunW(Set<String> termSetRunW) {
        this.termSetRunW = termSetRunW;
    }

    void setCorpus(Corpus corpus) {
        this.corpus = corpus;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public boolean isRuleTopic() {
        return this.ruleTopic;
    }

    public boolean isPhrase() {
        return this.phrase;
    }

    public void setRuleTopic(boolean ruleTopic) {
        this.ruleTopic = ruleTopic;
    }

    public void setPhrase(boolean phrase) {
        this.phrase = phrase;
    }

    void setShortPhrase(boolean shortPhrase) {
        this.shortPhrase = shortPhrase;
    }

    public boolean isShortPhrase() {
        return this.shortPhrase;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Object clone() throws CloneNotSupportedException {
        TopicData clone = new TopicData(this.graph);
        clone.lowerCut = this.lowerCut;
        clone.upperCut = this.upperCut;
        clone.numberGrams = this.numberGrams;
        clone.matrixType = this.matrixType;
        clone.setMatrix(this.getMatrix());
        clone.corporaNgrams = this.corporaNgrams;
        clone.weightBeta = this.weightBeta;
        clone.stemmer = this.stemmer;
        clone.useStopword = this.useStopword;
        clone.groupTopics = this.groupTopics;
        clone.weightType = this.weightType;
        clone.topicType = this.topicType;
        clone.clusteringType = this.clusteringType;
        clone.percentageTerms = this.percentageTerms;
        clone.percentageTopics = this.percentageTopics;
        return clone;
    }

    public static enum ClusteringType {
        KMEANS,
        DBSCAN;

    }

    public static enum WeightType {
        LOCAL,
        F_MEASURE;

    }

    public static enum TopicType {
        COVARIANCE,
        RULE;

    }

    public static enum SupportType {
        RELATIVE,
        ABSOLUTE;

    }
}

