/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.util.ArrayList;
import visualizer.corpus.Corpus;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.topic.CovarianceTopic;
import visualizer.topic.RuleTopic;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;

public class TopicFactory {
    public static Topic getInstance(Graph graph, TopicData tdata, Corpus corpus, ArrayList<Vertex> selectedVertices) {
        if (tdata.getTopicType() == TopicData.TopicType.COVARIANCE) {
            return new CovarianceTopic(graph, selectedVertices, corpus, tdata);
        }
        if (tdata.getTopicType() == TopicData.TopicType.RULE) {
            return new RuleTopic(selectedVertices, corpus, tdata);
        }
        return null;
    }
}

