/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.graph.Graph;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformationType;
import visualizer.topic.TopicData;
import visualizer.util.OpenDialog;
import visualizer.view.tools.LuhnCutAnalizer;

public class TopicRuleTFSettings
extends JDialog {
    private static TopicRuleTFSettings instance;
    private Graph graph;
    private JCheckBox absSupportCheckBox;
    private JTextField absSupportText;
    private JButton analyzeButton;
    private JTextField betaTextField;
    private JPanel buttonPanel;
    private JButton cancekButton;
    private JButton closeButton;
    private ButtonGroup clusteringButtonGroup;
    private JPanel clusteringPanel;
    private JPanel dataPanel;
    private JRadioButton dbscanRadioButton;
    private ButtonGroup distanceButtonGroup;
    private JRadioButton fMeasureRadioButton;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;
    private JCheckBox groupLabelCheckBox;
    private JLabel jLabel1;
    private JRadioButton kmeansRadioButton;
    private ButtonGroup kolmoButtonGroup;
    private JPanel labelStylePanel;
    private JRadioButton localRadioButton;
    private JLabel luhnLowerLabel;
    private JTextField luhnLowerTextField;
    private JLabel luhnUpperLabel;
    private JTextField luhnUpperTextField;
    private ButtonGroup matrixButtonGroup;
    private JPanel matrixTypePanel;
    private JComboBox matrixtransfComboBox;
    private JPanel parametersPanel;
    private JCheckBox phraseLabelCheckBox;
    private JPanel preprocessingPanel;
    private JCheckBox ruleLabelCheckBox;
    private JCheckBox shortPhraseLabelCheckBox;
    private JRadioButton startRadioButton;
    private JComboBox stemmerComboBox;
    private JRadioButton stopRadioButton;
    private JPanel supportPanel;
    private JPanel weightPanel;
    private ButtonGroup wordListButtonGroup;
    private JPanel wordListTypePanel;

    private TopicRuleTFSettings(JDialog parent) {
        super(parent);
        this.initComponents();
        for (StemmerType st : StemmerType.getTypes()) {
            this.stemmerComboBox.addItem(st);
        }
        for (MatrixTransformationType mtt : MatrixTransformationType.getTypes()) {
            this.matrixtransfComboBox.addItem(mtt);
        }
    }

    private void initComponents() {
        this.distanceButtonGroup = new ButtonGroup();
        this.matrixButtonGroup = new ButtonGroup();
        this.kolmoButtonGroup = new ButtonGroup();
        this.wordListButtonGroup = new ButtonGroup();
        this.clusteringButtonGroup = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.preprocessingPanel = new JPanel();
        this.parametersPanel = new JPanel();
        this.luhnLowerLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.gramsLabel = new JLabel();
        this.luhnLowerTextField = new JTextField();
        this.analyzeButton = new JButton();
        this.luhnUpperLabel = new JLabel();
        this.luhnUpperTextField = new JTextField();
        this.stemmerComboBox = new JComboBox();
        this.matrixTypePanel = new JPanel();
        this.matrixtransfComboBox = new JComboBox();
        this.wordListTypePanel = new JPanel();
        this.stopRadioButton = new JRadioButton();
        this.startRadioButton = new JRadioButton();
        this.weightPanel = new JPanel();
        this.fMeasureRadioButton = new JRadioButton();
        this.localRadioButton = new JRadioButton();
        this.betaTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.clusteringPanel = new JPanel();
        this.kmeansRadioButton = new JRadioButton();
        this.dbscanRadioButton = new JRadioButton();
        this.labelStylePanel = new JPanel();
        this.groupLabelCheckBox = new JCheckBox();
        this.ruleLabelCheckBox = new JCheckBox();
        this.phraseLabelCheckBox = new JCheckBox();
        this.shortPhraseLabelCheckBox = new JCheckBox();
        this.supportPanel = new JPanel();
        this.absSupportCheckBox = new JCheckBox();
        this.absSupportText = new JTextField();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.cancekButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Parameters to Create Label");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.preprocessingPanel.setBorder(BorderFactory.createTitledBorder("Preprocessing"));
        this.preprocessingPanel.setLayout(new GridBagLayout());
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.luhnLowerLabel.setText("Luhn's lower cut");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.luhnLowerLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.gramsComboBox, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.gramsLabel, gridBagConstraints);
        this.luhnLowerTextField.setColumns(5);
        this.luhnLowerTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.luhnLowerTextField, gridBagConstraints);
        this.analyzeButton.setText("Analyze");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.analyzeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.analyzeButton, gridBagConstraints);
        this.luhnUpperLabel.setText("Luhn's upper cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.luhnUpperLabel, gridBagConstraints);
        this.luhnUpperTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.luhnUpperTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.parametersPanel.add((Component)this.stemmerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.preprocessingPanel.add((Component)this.parametersPanel, gridBagConstraints);
        this.matrixTypePanel.setBorder(BorderFactory.createTitledBorder("Matrix Transformation"));
        this.matrixTypePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.matrixTypePanel.add((Component)this.matrixtransfComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.preprocessingPanel.add((Component)this.matrixTypePanel, gridBagConstraints);
        this.wordListTypePanel.setBorder(BorderFactory.createTitledBorder("Word List Type"));
        this.wordListTypePanel.setLayout(new GridBagLayout());
        this.wordListButtonGroup.add(this.stopRadioButton);
        this.stopRadioButton.setText("Stop Words");
        this.stopRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stopRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.wordListTypePanel.add((Component)this.stopRadioButton, gridBagConstraints);
        this.wordListButtonGroup.add(this.startRadioButton);
        this.startRadioButton.setText("Start Words");
        this.startRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.startRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.wordListTypePanel.add((Component)this.startRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.preprocessingPanel.add((Component)this.wordListTypePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        this.dataPanel.add((Component)this.preprocessingPanel, gridBagConstraints);
        this.weightPanel.setBorder(BorderFactory.createTitledBorder("Weight"));
        this.weightPanel.setLayout(new GridBagLayout());
        this.distanceButtonGroup.add(this.fMeasureRadioButton);
        this.fMeasureRadioButton.setText("F-measure");
        this.fMeasureRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fMeasureRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightPanel.add((Component)this.fMeasureRadioButton, gridBagConstraints);
        this.distanceButtonGroup.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText("Local");
        this.localRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightPanel.add((Component)this.localRadioButton, gridBagConstraints);
        this.betaTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightPanel.add((Component)this.betaTextField, gridBagConstraints);
        this.jLabel1.setText("Beta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.dataPanel.add((Component)this.weightPanel, gridBagConstraints);
        this.clusteringPanel.setBorder(BorderFactory.createTitledBorder("Clustering Technique"));
        this.clusteringPanel.setLayout(new GridBagLayout());
        this.clusteringButtonGroup.add(this.kmeansRadioButton);
        this.kmeansRadioButton.setSelected(true);
        this.kmeansRadioButton.setText("K-means");
        this.kmeansRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.kmeansRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.kmeansRadioButton, gridBagConstraints);
        this.clusteringButtonGroup.add(this.dbscanRadioButton);
        this.dbscanRadioButton.setText("DBSCAN");
        this.dbscanRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dbscanRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.dbscanRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.dataPanel.add((Component)this.clusteringPanel, gridBagConstraints);
        this.labelStylePanel.setBorder(BorderFactory.createTitledBorder("Label Style"));
        this.labelStylePanel.setLayout(new GridLayout(2, 0));
        this.groupLabelCheckBox.setText("Group Labels");
        this.groupLabelCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.groupLabelCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.groupLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.groupLabelCheckBoxActionPerformed(evt);
            }
        });
        this.labelStylePanel.add(this.groupLabelCheckBox);
        this.ruleLabelCheckBox.setSelected(true);
        this.ruleLabelCheckBox.setText("Association Rule");
        this.ruleLabelCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ruleLabelCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.ruleLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.ruleLabelCheckBoxActionPerformed(evt);
            }
        });
        this.labelStylePanel.add(this.ruleLabelCheckBox);
        this.phraseLabelCheckBox.setText("Phrase");
        this.phraseLabelCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.phraseLabelCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.phraseLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.phraseLabelCheckBoxActionPerformed(evt);
            }
        });
        this.labelStylePanel.add(this.phraseLabelCheckBox);
        this.shortPhraseLabelCheckBox.setText("Short Phrase");
        this.shortPhraseLabelCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.shortPhraseLabelCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.labelStylePanel.add(this.shortPhraseLabelCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.dataPanel.add((Component)this.labelStylePanel, gridBagConstraints);
        this.supportPanel.setBorder(BorderFactory.createTitledBorder("Initial Minimun Support"));
        this.absSupportCheckBox.setText("Absolute Support:");
        this.supportPanel.add(this.absSupportCheckBox);
        this.absSupportText.setColumns(5);
        this.absSupportText.setText("5");
        this.supportPanel.add(this.absSupportText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.dataPanel.add((Component)this.supportPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.closeButton.setText("OK");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.cancekButton.setText("Cancel");
        this.cancekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicRuleTFSettings.this.cancekButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancekButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void phraseLabelCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void ruleLabelCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void groupLabelCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void cancekButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.refreshData();
        OpenDialog.checkCorpus(this.graph, this);
        this.setVisible(false);
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        this.refreshData();
        OpenDialog.checkCorpus(this.graph, this);
        this.graph.getTopicData().setLunhLowerCut(Integer.parseInt(this.luhnLowerTextField.getText()));
        this.graph.getTopicData().setLunhUpperCut(-1);
        try {
            this.graph.getTopicData().setLunhUpperCut(Integer.parseInt(this.luhnUpperTextField.getText()));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        LuhnCutAnalizer.getInstance(this).display(this.graph.getProjectionData(), this.graph.getTopicData());
        this.luhnLowerTextField.setText(Integer.toString(this.graph.getTopicData().getLunhLowerCut()));
        this.luhnUpperTextField.setText(Integer.toString(this.graph.getTopicData().getLunhUpperCut()));
    }

    public static TopicRuleTFSettings getInstance(JDialog parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new TopicRuleTFSettings(parent);
        }
        return instance;
    }

    public void display(Graph graph) {
        this.graph = graph;
        TopicData tdata = graph.getTopicData();
        this.stemmerComboBox.setSelectedItem(tdata.getStemmer());
        this.groupLabelCheckBox.setSelected(tdata.isGroupTopics());
        this.ruleLabelCheckBox.setSelected(tdata.isRuleTopic());
        this.phraseLabelCheckBox.setSelected(tdata.isPhrase());
        this.shortPhraseLabelCheckBox.setSelected(tdata.isShortPhrase());
        this.absSupportCheckBox.setSelected(tdata.getSupportType() == TopicData.SupportType.ABSOLUTE);
        this.absSupportText.setText(Integer.toString(tdata.getMinSupAbs()));
        this.stopRadioButton.setSelected(tdata.isUseStopword());
        this.startRadioButton.setSelected(!tdata.isUseStopword());
        this.luhnLowerTextField.setText(Integer.toString(tdata.getLunhLowerCut()));
        if (tdata.getLunhUpperCut() == -1) {
            this.luhnUpperTextField.setText("");
        } else {
            this.luhnUpperTextField.setText(Integer.toString(tdata.getLunhUpperCut()));
        }
        this.gramsComboBox.setSelectedIndex(tdata.getNumberGrams() - 1);
        this.matrixtransfComboBox.setSelectedItem(tdata.getMatrixTransformationType());
        this.fMeasureRadioButton.setSelected(false);
        this.localRadioButton.setSelected(false);
        if (this.graph.getTopicData().getWeightType() == TopicData.WeightType.F_MEASURE) {
            this.fMeasureRadioButton.setSelected(true);
        } else {
            this.localRadioButton.setSelected(true);
        }
        this.betaTextField.setText(this.graph.getTopicData().getWeightBeta().toString());
        this.kmeansRadioButton.setSelected(false);
        this.dbscanRadioButton.setSelected(false);
        if (this.graph.getTopicData().getClusteringType() == TopicData.ClusteringType.KMEANS) {
            this.kmeansRadioButton.setSelected(true);
        } else {
            this.dbscanRadioButton.setSelected(true);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void refreshData() {
        TopicData tdata = this.graph.getTopicData();
        tdata.setLunhLowerCut(Integer.parseInt(this.luhnLowerTextField.getText()));
        tdata.setStemmer((StemmerType)this.stemmerComboBox.getSelectedItem());
        tdata.setUseStopword(this.stopRadioButton.isSelected());
        tdata.setGroupTopics(this.groupLabelCheckBox.isSelected());
        tdata.setRuleTopic(this.ruleLabelCheckBox.isSelected());
        tdata.setPhrase(this.phraseLabelCheckBox.isSelected());
        tdata.setShortPhrase(this.shortPhraseLabelCheckBox.isSelected());
        if (this.absSupportCheckBox.isSelected()) {
            tdata.setSupportType(TopicData.SupportType.ABSOLUTE);
            tdata.setMinSupAbs(new Integer(this.absSupportText.getText()));
        } else {
            tdata.setSupportType(TopicData.SupportType.RELATIVE);
        }
        if (this.luhnUpperTextField.getText().trim().length() > 0) {
            tdata.setLunhUpperCut(Integer.parseInt(this.luhnUpperTextField.getText()));
        } else {
            tdata.setLunhUpperCut(-1);
        }
        tdata.setNumberGrams(this.gramsComboBox.getSelectedIndex() + 1);
        tdata.setMatrixTransformationType((MatrixTransformationType)this.matrixtransfComboBox.getSelectedItem());
        if (this.kmeansRadioButton.isSelected()) {
            tdata.setClusteringType(TopicData.ClusteringType.KMEANS);
        } else {
            tdata.setClusteringType(TopicData.ClusteringType.DBSCAN);
        }
        tdata.setWeightBeta(new Float(this.betaTextField.getText()));
        if (this.localRadioButton.isSelected()) {
            tdata.setWeightType(TopicData.WeightType.LOCAL);
        } else {
            tdata.setWeightType(TopicData.WeightType.F_MEASURE);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TopicRuleTFSettings(new JDialog()).setVisible(true);
            }
        });
    }
}

