/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static void convertDirToGray(String directory) {
        File dir = new File(directory);
        String[] files = dir.list();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = new File(directory + "\\" + files[i]);
                try {
                    BufferedImage img = ImageIO.read(f);
                    if (img.getType() == 10) continue;
                    img = ImageUtil.RGBToGray(img);
                    String type = files[i].substring(files[i].lastIndexOf(46) + 1, files[i].length());
                    ImageIO.write((RenderedImage)img, type, new File(directory + "\\" + files[i]));
                    continue;
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public static BufferedImage RGBToGray(BufferedImage input) {
        ColorSpace graySpace = ColorSpace.getInstance(1003);
        ColorConvertOp grayConvert = new ColorConvertOp(graySpace, null);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 10);
        return grayConvert.filter(input, output);
    }

    public static BufferedImage myRGBToGray(BufferedImage input) {
        ColorSpace graySpace = ColorSpace.getInstance(1003);
        ColorConvertOp grayConvert = new ColorConvertOp(graySpace, null);
        BufferedImage output = new BufferedImage(input.getWidth(), input.getHeight(), 5);
        return grayConvert.filter(input, output);
    }

    public static BufferedImage readImage(String filename) {
        try {
            return ImageIO.read(new File(filename));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static int[][] getGrayValues(BufferedImage image) {
        int[][] gray = new int[image.getHeight()][image.getWidth()];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color c = new Color(image.getRGB(x, y));
                gray[y][x] = c.getRed();
            }
        }
        return gray;
    }

    public static int numberOfPixels(String filename) {
        BufferedImage im = ImageUtil.readImage(filename);
        return im.getWidth() * im.getHeight();
    }

    public static float getSobelAt(int[][] m, int x, int y) {
        float gx = m[y][x - 1] * -2 + m[y - 1][x - 1] * -1 + m[y + 1][x - 1] * -1 + m[y][x + 1] * 2 + m[y - 1][x + 1] * 1 + m[y + 1][x + 1] * 1;
        float gy = m[y + 1][x] * -2 + m[y + 1][x - 1] * -1 + m[y + 1][x + 1] * -1 + m[y - 1][x] * 2 + m[y - 1][x - 1] * 1 + m[y - 1][x + 1] * 1;
        return (float)Math.sqrt(gx * gx + gy * gy);
    }

    public static void writeImage(BufferedImage image, String type, String filename) {
        try {
            ImageIO.write((RenderedImage)image, type, new File(filename));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

