/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.Pair;

public class ScalarNeighbors {
    private ArrayList<Vertex> vertices;
    private Scalar currentScalar;
    private int numberNeighbors;

    public ScalarNeighbors(ArrayList<Vertex> vertices, Scalar currentScalar, int numberNeighbors) {
        this.numberNeighbors = numberNeighbors;
        this.vertices = vertices;
        this.currentScalar = currentScalar;
    }

    public Pair[][] execute() throws IOException {
        Pair[][] neighbors = null;
        HashMap sc = new HashMap();
        ArrayList neigh_aux = new ArrayList();
        int validVertices = 0;
        for (Vertex vertex : this.vertices) {
            if (!vertex.isValid()) continue;
            ++validVertices;
            neigh_aux.add(new ArrayList());
            Float key = Float.valueOf(vertex.getScalar(this.currentScalar));
            if (!sc.containsKey(key)) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                values.add((int)vertex.getId());
                sc.put(key, values);
                continue;
            }
            ((ArrayList)sc.get(key)).add((int)vertex.getId());
        }
        for (ArrayList values : sc.values()) {
            for (int i = 0; i < values.size(); ++i) {
                Integer from = (Integer)values.get(i);
                for (int j = i + 1; j < i + 6; ++j) {
                    Integer to = (Integer)values.get((int)(Math.random() * (double)values.size()) % values.size());
                    ((ArrayList)neigh_aux.get(from)).add(new Pair(to, 1.0f));
                    ((ArrayList)neigh_aux.get(to)).add(new Pair(from, 1.0f));
                    to = (Integer)values.get(j % values.size());
                    ((ArrayList)neigh_aux.get(from)).add(new Pair(to, 1.0f));
                    ((ArrayList)neigh_aux.get(to)).add(new Pair(from, 1.0f));
                }
            }
        }
        neighbors = new Pair[validVertices][];
        for (int i = 0; i < neigh_aux.size(); ++i) {
            neighbors[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
            for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                neighbors[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
            }
        }
        return neighbors;
    }

    public Pair[][] execute(DistanceMatrix dmat) throws IOException {
        Pair[][] neighbors = null;
        HashMap sc = new HashMap();
        ArrayList neigh_aux = new ArrayList();
        int validVertices = 0;
        for (Vertex vertex : this.vertices) {
            if (!vertex.isValid()) continue;
            ++validVertices;
            neigh_aux.add(new ArrayList());
            Float key = Float.valueOf(vertex.getScalar(this.currentScalar));
            if (!sc.containsKey(key)) {
                ArrayList<Integer> values = new ArrayList<Integer>();
                values.add((int)vertex.getId());
                sc.put(key, values);
                continue;
            }
            ((ArrayList)sc.get(key)).add((int)vertex.getId());
        }
        for (ArrayList values : sc.values()) {
            for (int i = 0; i < values.size(); ++i) {
                Integer from = (Integer)values.get(i);
                for (int j = 0; j < values.size(); ++j) {
                    int pos;
                    if (i == j) continue;
                    Integer to = (Integer)values.get(j % values.size());
                    float dist = dmat.getDistance(from, to);
                    for (pos = ((ArrayList)neigh_aux.get(from)).size(); pos > 0 && dist < ((Pair)((ArrayList)neigh_aux.get((int)from.intValue())).get((int)(pos - 1))).value; --pos) {
                    }
                    ((ArrayList)neigh_aux.get(from)).add(pos, new Pair(to, dist));
                    if (((ArrayList)neigh_aux.get(from)).size() <= this.numberNeighbors) continue;
                    ((ArrayList)neigh_aux.get(from)).remove(((ArrayList)neigh_aux.get(from)).size() - 1);
                }
            }
        }
        neighbors = new Pair[validVertices][];
        for (int i = 0; i < neigh_aux.size(); ++i) {
            neighbors[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
            for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                neighbors[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
            }
        }
        return neighbors;
    }
}

