/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.color;

import java.awt.Color;

public abstract class ColorScale {
    private float min = 0.0f;
    private float max = 1.0f;
    private boolean reverse = false;
    protected Color[] colors;

    public abstract String getName();

    public Color getColor(float value) {
        int index;
        float maxlength = (float)((this.colors.length - 1) / 2) + this.max * (float)((this.colors.length - 1) / 2);
        float minlength = this.min * (float)((this.colors.length - 1) / 2);
        if (this.reverse) {
            value = 1.0f - value;
            maxlength = (float)((this.colors.length - 1) / 2) + (1.0f - this.min) * (float)((this.colors.length - 1) / 2);
            minlength = (1.0f - this.max) * (float)((this.colors.length - 1) / 2);
        }
        return this.colors.length >= (index = (int)(value * (maxlength - minlength) + minlength)) ? this.colors[index] : this.colors[this.colors.length - 1];
    }

    public int getNumberColors() {
        return this.colors.length;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

