/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.legend;

import java.awt.Color;
import java.util.ArrayList;
import visualizer.view.color.ColorTable;

public class Legend {
    private float max;
    private float min;
    private ColorTable table;
    private String title;
    private ArrayList<Item> items = new ArrayList();

    public Legend(ColorTable table, String title) {
        this.table = table;
        this.title = title;
        this.max = Float.NEGATIVE_INFINITY;
        this.min = Float.POSITIVE_INFINITY;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addItem(String text, float value) {
        this.items.add(new Item(text, value));
    }

    public Item getItem(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public String getTitle() {
        return this.title;
    }

    public class Item {
        private String name;
        private float value;

        public Item(String text, float value) {
            this.name = text;
            this.value = value;
            if (Legend.this.max < value) {
                Legend.this.max = value;
            }
            if (Legend.this.min > value) {
                Legend.this.min = value;
            }
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            if (Legend.this.max > Legend.this.min) {
                return Legend.this.table.getColor((this.value - Legend.this.min) / (Legend.this.max - Legend.this.min));
            }
            return Legend.this.table.getColor(0.0f);
        }
    }
}

