/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import visualizer.graph.Graph;
import visualizer.util.OpenDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.PROJFilter;
import visualizer.util.filefilter.TITLEFilter;

public class ImportProjection
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_OPTION = 0;
    public static final int IMPORT_OPTION = 1;
    private static ImportProjection instance;
    private int exit = 0;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel dataPanel;
    private JLabel descriptionLabel1;
    private JLabel descriptionLabel2;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JButton importButton;
    private JButton projButton;
    private JTextField projTextField;
    private JLabel projectionLabel;
    private JButton titlesButton;
    private JLabel titlesLabel;
    private JTextField titlesTextField;

    private ImportProjection(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.projectionLabel = new JLabel();
        this.projTextField = new JTextField();
        this.projButton = new JButton();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.descriptionLabel2 = new JLabel();
        this.descriptionLabel1 = new JLabel();
        this.titlesLabel = new JLabel();
        this.titlesTextField = new JTextField();
        this.titlesButton = new JButton();
        this.buttonPanel = new JPanel();
        this.importButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Projection ");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Files to import"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.projectionLabel.setText("Projection file");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.projectionLabel, gridBagConstraints);
        this.projTextField.setColumns(45);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.projTextField, gridBagConstraints);
        this.projButton.setText("Search...");
        this.projButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportProjection.this.projButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.projButton, gridBagConstraints);
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        this.descriptionLabel2.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.descriptionLabel2, gridBagConstraints);
        this.descriptionLabel1.setText("Projection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.descriptionLabel1, gridBagConstraints);
        this.titlesLabel.setText("Titles file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.titlesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.titlesTextField, gridBagConstraints);
        this.titlesButton.setText("Search...");
        this.titlesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportProjection.this.titlesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.dataPanel.add((Component)this.titlesButton, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.importButton.setText("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportProjection.this.importButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.importButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportProjection.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void titlesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new TITLEFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.titlesTextField.setText(filename);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.exit = 0;
        this.setVisible(false);
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.projTextField.getText().trim().length() > 0) {
                this.importFile(this.projTextField.getText(), this.titlesTextField.getText());
                this.exit = 1;
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this, "The PROJECTION filename must be provided!", "Error", 0);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void projButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new PROJFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.projTextField.setText(filename);
            this.autoFill(OpenDialog.getJFileChooser());
        }
    }

    public static ImportProjection getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new ImportProjection(parent);
        }
        return instance;
    }

    public Graph display() {
        this.exit = 0;
        this.descriptionTextArea.setText("");
        this.projTextField.setText("");
        this.titlesTextField.setText("");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        if (this.exit == 0) {
            return null;
        }
        return this.graph;
    }

    private void importFile(String projFile, String titlesFile) throws IOException {
        this.graph = Util.importProjection(projFile);
        if (titlesFile.trim().length() > 0) {
            Util.importTitles(this.graph, titlesFile);
        }
    }

    private void autoFill(JFileChooser file) {
        File[] files;
        String filename = file.getSelectedFile().getName();
        String titlefile = filename.substring(0, filename.lastIndexOf(46)) + ".titles";
        for (File f : files = file.getCurrentDirectory().listFiles()) {
            if (!titlefile.equals(f.getName())) continue;
            this.titlesTextField.setText(f.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImportProjection(null).setVisible(true);
            }
        });
    }
}

