/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import visualizer.textprocessing.Ngram;

public class ZipfCurve
extends JPanel {
    private int upperLine;
    private int lowerLine;
    private BufferedImage imageBuffer;
    private List<Ngram> ngrams;

    public ZipfCurve() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                ZipfCurve.this.drawImage();
                ZipfCurve.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.imageBuffer, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    public void setNgrams(List<Ngram> ngrams) {
        this.ngrams = ngrams;
        this.drawImage();
        this.repaint();
    }

    public int[] setCutLines(int lowerLine, int upperLine) {
        this.upperLine = upperLine;
        this.lowerLine = lowerLine;
        this.drawImage();
        this.repaint();
        int[] freqs = new int[]{this.ngrams.get((int)lowerLine).frequency, this.ngrams.get((int)upperLine).frequency};
        return freqs;
    }

    private void drawImage() {
        this.imageBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D gBuffer = this.imageBuffer.createGraphics();
        Dimension size = this.getSize();
        gBuffer.setColor(Color.WHITE);
        gBuffer.fillRect(0, 0, size.width, size.height);
        int grid = 40;
        for (int i = 0; i < grid; ++i) {
            gBuffer.setColor(Color.LIGHT_GRAY);
            int col = (int)((float)size.width / (float)grid * (float)(i + 1));
            gBuffer.drawLine(col, 0, col, size.height);
            int lin = (int)((float)size.height / (float)grid * (float)(i + 1));
            gBuffer.drawLine(0, lin, size.width, lin);
        }
        gBuffer.setColor(Color.BLACK);
        gBuffer.drawRect(0, 0, size.width - 1, size.height - 1);
        if (this.ngrams != null) {
            int i;
            int nelements = this.ngrams.size();
            float maxf = this.ngrams.get((int)0).frequency;
            float minf = this.ngrams.get((int)0).frequency;
            for (i = 1; i < nelements; ++i) {
                if ((float)this.ngrams.get((int)i).frequency > maxf) {
                    maxf = this.ngrams.get((int)i).frequency;
                    continue;
                }
                if (!((float)this.ngrams.get((int)i).frequency < minf)) continue;
                minf = this.ngrams.get((int)i).frequency;
            }
            maxf = (float)Math.log(maxf);
            minf = (float)Math.log(minf);
            for (i = 0; i < nelements - 1; ++i) {
                int posx1 = (int)((float)i / (float)nelements * (float)(size.width - 40)) + 20;
                int posy1 = (int)((Math.log(this.ngrams.get((int)i).frequency) - (double)minf) / (double)(maxf - minf) * (double)(size.height - 40)) + 20;
                int posx2 = (int)((float)(i + 1) / (float)nelements * (float)(size.width - 40)) + 20;
                int posy2 = (int)((Math.log(this.ngrams.get((int)(i + 1)).frequency) - (double)minf) / (double)(maxf - minf) * (double)(size.height - 40)) + 20;
                gBuffer.setColor(Color.RED);
                gBuffer.drawLine(posx1, size.height - posy1, posx2, size.height - posy2);
            }
            int posL2 = (int)((float)this.lowerLine / (float)nelements * (float)(size.width - 40)) + 20;
            int posL1 = (int)((float)this.upperLine / (float)nelements * (float)(size.width - 40)) + 20;
            if (posL2 - posL1 >= 0) {
                gBuffer.setColor(Color.BLUE);
                Graphics2D g2 = gBuffer;
                gBuffer.drawRect(posL1, 20, Math.abs(posL2 - posL1), size.height - 30);
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2.fill(new Rectangle(posL1, 20, Math.abs(posL2 - posL1), size.height - 30));
            } else {
                ((Graphics)gBuffer).drawString("ERROR", size.width / 2, size.height / 2);
            }
        }
    }
}

