/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import visualizer.graph.Graph;
import visualizer.projection.GraphBuilder;
import visualizer.projection.ProjectionData;
import visualizer.projection.ProjectionFactory;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.wizard.DataSourceChoice;
import visualizer.wizard.DimensionReduction;
import visualizer.wizard.GeneralParameters;
import visualizer.wizard.Preprocessing;
import visualizer.wizard.ProjectionDistanceChoice;
import visualizer.wizard.ProjectionView;
import visualizer.wizard.WizardPanel;

public class ProjectionWizardCore {
    public static final int NEXT_STATE = 0;
    public static final int PREVIOUS_STATE = 1;
    private static final int INITIAL_STATE = 0;
    private static final int SOURCE_STATE = 1;
    private static final int PROJ_DIST_STATE = 2;
    private static final int PRE_PROC_STATE = 3;
    private static final int DIMEN_RED_STATE = 4;
    private static final int GEN_PARAM_STATE = 5;
    private static final int PROJECT_STATE = 6;
    private ProjectionDistanceChoice projDistView;
    private DataSourceChoice sourceView;
    private ProjectionView projView;
    private Preprocessing preprocessView;
    private GeneralParameters generalParametersView;
    private DimensionReduction dimensionReductionView;
    private int currentState = 0;
    private Graph graph;
    private GraphBuilder builder;

    public ProjectionWizardCore(Graph graph) {
        this.graph = graph;
        this.preprocessView = new Preprocessing(this.graph.getProjectionData());
        this.projDistView = new ProjectionDistanceChoice(this.graph.getProjectionData());
        this.sourceView = new DataSourceChoice(this.graph.getProjectionData());
        this.generalParametersView = new GeneralParameters(this.graph.getProjectionData());
        this.dimensionReductionView = new DimensionReduction(this.graph.getProjectionData());
    }

    public WizardPanel getNextPanel(int direction) {
        ProjectionData pdata = this.graph.getProjectionData();
        switch (this.currentState) {
            case 0: {
                this.currentState = 1;
                return this.sourceView.reset();
            }
            case 1: {
                if (direction != 0) break;
                this.currentState = 2;
                return this.projDistView.reset();
            }
            case 2: {
                if (direction == 1) {
                    this.currentState = 1;
                    return this.sourceView.reset();
                }
                if (pdata.getSourceType() == SourceType.CORPUS && pdata.getDissimilarityType() != DissimilarityType.KOLMOGOROV) {
                    this.currentState = 3;
                    return this.preprocessView;
                }
                if (pdata.getSourceType() == SourceType.POINTS) {
                    this.currentState = 4;
                    return this.dimensionReductionView.reset();
                }
                if (pdata.getSourceType() == SourceType.IMAGES) {
                    this.currentState = 4;
                    return this.dimensionReductionView.reset();
                }
                this.currentState = 5;
                return this.generalParametersView.reset();
            }
            case 3: {
                if (direction == 1) {
                    this.currentState = 2;
                    return this.projDistView.reset();
                }
                this.currentState = 4;
                return this.dimensionReductionView.reset();
            }
            case 4: {
                if (direction == 1) {
                    if (pdata.getSourceType() == SourceType.CORPUS && pdata.getDissimilarityType() != DissimilarityType.KOLMOGOROV) {
                        this.currentState = 3;
                        return this.preprocessView;
                    }
                    this.currentState = 2;
                    return this.projDistView.reset();
                }
                this.currentState = 5;
                return this.generalParametersView.reset();
            }
            case 5: {
                if (direction == 1) {
                    if (pdata.getSourceType() == SourceType.CORPUS && pdata.getDissimilarityType() != DissimilarityType.KOLMOGOROV || pdata.getSourceType() == SourceType.POINTS) {
                        this.currentState = 4;
                        return this.dimensionReductionView.reset();
                    }
                    if (pdata.getSourceType() == SourceType.IMAGES) {
                        this.currentState = 4;
                        return this.dimensionReductionView.reset();
                    }
                    this.currentState = 2;
                    return this.projDistView.reset();
                }
                this.projView = ProjectionFactory.getInstance(pdata.getProjectionType()).getProjectionView(pdata);
                this.projView.reset();
                this.currentState = 6;
                return this.projView;
            }
            case 6: {
                if (direction == 1) {
                    this.currentState = 5;
                    return this.generalParametersView.reset();
                }
                if (this.projView == null) break;
                this.builder = new GraphBuilder(this.projView, this.graph);
                this.builder.start();
            }
        }
        return null;
    }

    public void stopProcess() {
        if (this.builder != null) {
            this.builder.stop();
        }
    }
}

