/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexModifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.h2.api.Trigger;
import org.h2.store.fs.FileSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.StringUtils;

public class FullTextLucene
implements Trigger {
    private static HashMap indexers = new HashMap();
    private static final String FIELD_DATA = "DATA";
    private static final String FIELD_QUERY = "QUERY";
    private static final String FIELD_COLUMN_PREFIX = "_";
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private String schemaName;
    private String tableName;
    private int[] keys;
    private int[] indexColumns;
    private String[] columnNames;
    private int[] dataTypes;
    private IndexModifier indexer;

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullTextLucene.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullTextLucene.createTrigger(conn, schema, table);
        FullTextLucene.indexExistingRows(conn, schema, table);
    }

    public static void reindex(Connection conn) throws SQLException {
        FullTextLucene.init(conn);
        FullTextLucene.removeAllTriggers(conn);
        FullTextLucene.removeIndexFiles(conn);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM FTL.INDEXES");
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            FullTextLucene.createTrigger(conn, schema, table);
            FullTextLucene.indexExistingRows(conn, schema, table);
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FTL");
        FullTextLucene.removeAllTriggers(conn);
        FullTextLucene.removeIndexFiles(conn);
    }

    public static void init(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS FTL");
        stat.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, TABLE))");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR \"" + FullTextLucene.class.getName() + ".createIndex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR \"" + FullTextLucene.class.getName() + ".search\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR \"" + FullTextLucene.class.getName() + ".reindex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR \"" + FullTextLucene.class.getName() + ".dropAll\"");
    }

    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        String columns;
        FullTextLucene.init(conn);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.indexer = FullTextLucene.getIndexModifier(conn);
        ArrayList<String> keyList = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getColumns(null, schemaName, tableName, null);
        ArrayList<String> columnList = new ArrayList<String>();
        while (rs.next()) {
            columnList.add(rs.getString("COLUMN_NAME"));
        }
        this.dataTypes = new int[columnList.size()];
        this.columnNames = new String[columnList.size()];
        columnList.toArray(this.columnNames);
        rs = meta.getColumns(null, schemaName, tableName, null);
        int i = 0;
        while (rs.next()) {
            this.dataTypes[i] = rs.getInt("DATA_TYPE");
            ++i;
        }
        if (keyList.size() == 0) {
            rs = meta.getPrimaryKeys(null, schemaName, tableName);
            while (rs.next()) {
                keyList.add(rs.getString("COLUMN_NAME"));
            }
        }
        if (keyList.size() == 0) {
            throw new SQLException("No primary key for table " + tableName);
        }
        ArrayList<String> indexList = new ArrayList<String>();
        PreparedStatement prep = conn.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
        prep.setString(1, schemaName);
        prep.setString(2, tableName);
        rs = prep.executeQuery();
        if (rs.next() && (columns = rs.getString(1)) != null) {
            String[] list = StringUtils.arraySplit(columns, ',', true);
            for (int i2 = 0; i2 < list.length; ++i2) {
                indexList.add(list[i2]);
            }
        }
        if (indexList.size() == 0) {
            indexList.addAll(columnList);
        }
        this.keys = new int[keyList.size()];
        this.setColumns(this.keys, keyList, columnList);
        this.indexColumns = new int[indexList.size()];
        this.setColumns(this.indexColumns, indexList, columnList);
    }

    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        if (oldRow != null) {
            this.delete(oldRow);
        }
        if (newRow != null) {
            this.insert(newRow);
        }
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn(FIELD_QUERY, 12, 0, 0);
        if (text == null) {
            return rs;
        }
        String path = FullTextLucene.getIndexPath(conn);
        try {
            IndexModifier indexer = FullTextLucene.getIndexModifier(conn);
            indexer.flush();
            IndexReader reader = IndexReader.open((String)path);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexSearcher searcher = new IndexSearcher(reader);
            QueryParser parser = new QueryParser(FIELD_DATA, (Analyzer)analyzer);
            Query query = parser.parse(text);
            Hits hits = searcher.search(query);
            int max = hits.length();
            if (limit == 0) {
                limit = max;
            }
            for (int i = 0; i < limit && i + offset < max; ++i) {
                Document doc = hits.doc(i + offset);
                String q = doc.get(FIELD_QUERY);
                rs.addRow(new Object[]{q});
            }
            reader.close();
        }
        catch (Exception e) {
            throw FullTextLucene.convertException(e);
        }
        return rs;
    }

    private static void removeAllTriggers(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement stat2 = conn.createStatement();
        while (rs.next()) {
            String schema = rs.getString("TRIGGER_SCHEMA");
            String name = rs.getString("TRIGGER_NAME");
            if (!name.startsWith(TRIGGER_PREFIX)) continue;
            name = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(name);
            stat2.execute("DROP TRIGGER " + name);
        }
    }

    private static void removeIndexFiles(Connection conn) throws SQLException {
        String path = FullTextLucene.getIndexPath(conn);
        IndexModifier index = (IndexModifier)indexers.get(path);
        if (index != null) {
            indexers.remove(path);
            try {
                index.flush();
                index.close();
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }
        FileSystem.getInstance(path).deleteRecursive(path);
    }

    private String getQuery(Object[] row) throws SQLException {
        StringBuffer buff = new StringBuffer();
        if (this.schemaName != null) {
            buff.append(StringUtils.quoteIdentifier(this.schemaName));
            buff.append(".");
        }
        buff.append(StringUtils.quoteIdentifier(this.tableName));
        buff.append(" WHERE ");
        for (int i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            int columnIndex = this.keys[i];
            buff.append(StringUtils.quoteIdentifier(this.columnNames[columnIndex]));
            Object o = row[columnIndex];
            if (o == null) {
                buff.append(" IS NULL");
                continue;
            }
            buff.append("=");
            buff.append(this.quoteSQL(o, this.dataTypes[columnIndex]));
        }
        String key = buff.toString();
        return key;
    }

    private String quoteString(String data) {
        if (data.indexOf(39) < 0) {
            return "'" + data + "'";
        }
        StringBuffer buff = new StringBuffer(data.length() + 2);
        buff.append('\'');
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '\'') {
                buff.append(ch);
            }
            buff.append(ch);
        }
        buff.append('\'');
        return buff.toString();
    }

    private String quoteBinary(byte[] data) {
        return "'" + ByteUtils.convertBytesToString(data) + "'";
    }

    private String asString(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return data.toString();
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported column data type: " + type);
            }
        }
        return "";
    }

    private String quoteSQL(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return data.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return this.quoteString(data.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                return this.quoteBinary((byte[])data);
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw new SQLException("FULLTEXT", "Unsupported key data type: " + type);
            }
        }
        return "";
    }

    private void insert(Object[] row) throws SQLException {
        String query = this.getQuery(row);
        Document doc = new Document();
        doc.add((Fieldable)new Field(FIELD_QUERY, query, Field.Store.YES, Field.Index.UN_TOKENIZED));
        long time = System.currentTimeMillis();
        doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)time, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
        StringBuffer allData = new StringBuffer();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            int index = this.indexColumns[i];
            String columnName = this.columnNames[index];
            String data = this.asString(row[index], this.dataTypes[index]);
            doc.add((Fieldable)new Field(FIELD_COLUMN_PREFIX + columnName, data, Field.Store.NO, Field.Index.TOKENIZED));
            if (i > 0) {
                allData.append(" ");
            }
            allData.append(data);
        }
        doc.add((Fieldable)new Field(FIELD_DATA, allData.toString(), Field.Store.NO, Field.Index.TOKENIZED));
        try {
            this.indexer.addDocument(doc);
        }
        catch (IOException e) {
            throw FullTextLucene.convertException(e);
        }
    }

    private void delete(Object[] row) throws SQLException {
        String query = this.getQuery(row);
        try {
            Term term = new Term(FIELD_QUERY, query);
            this.indexer.deleteDocuments(term);
        }
        catch (IOException e) {
            throw FullTextLucene.convertException(e);
        }
    }

    private static SQLException convertException(Exception e) {
        SQLException e2 = new SQLException("FULLTEXT", "Error while indexing document");
        e2.initCause(e);
        return e2;
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        Statement stat = conn.createStatement();
        String trigger = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + table);
        stat.execute("DROP TRIGGER IF EXISTS " + trigger);
        StringBuffer buff = new StringBuffer("CREATE TRIGGER IF NOT EXISTS ");
        buff.append(trigger);
        buff.append(" AFTER INSERT, UPDATE, DELETE ON ");
        buff.append(StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table));
        buff.append(" FOR EACH ROW CALL \"");
        buff.append(FullTextLucene.class.getName());
        buff.append("\"");
        stat.execute(buff.toString());
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullTextLucene existing = new FullTextLucene();
        existing.init(conn, schema, null, table, false, 1);
        StringBuffer buff = new StringBuffer("SELECT * FROM ");
        buff.append(StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table));
        ResultSet rs = conn.createStatement().executeQuery(buff.toString());
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            existing.fire(conn, null, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexModifier getIndexModifier(Connection conn) throws SQLException {
        try {
            IndexModifier indexer;
            String path = FullTextLucene.getIndexPath(conn);
            HashMap hashMap = indexers;
            synchronized (hashMap) {
                indexer = (IndexModifier)indexers.get(path);
                if (indexer == null) {
                    indexer = new IndexModifier(path, (Analyzer)new StandardAnalyzer(), true);
                    indexers.put(path, indexer);
                }
            }
            return indexer;
        }
        catch (IOException e) {
            throw FullTextLucene.convertException(e);
        }
    }

    private static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL DATABASE_PATH()");
        rs.next();
        String path = rs.getString(1);
        if (path == null) {
            throw new SQLException("FULLTEXT", "Fulltext search for in-memory databases is not supported.");
        }
        rs.close();
        return path;
    }

    private void setColumns(int[] index, ArrayList keys, ArrayList columns) throws SQLException {
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            int found = -1;
            for (int j = 0; found == -1 && j < columns.size(); ++j) {
                String column = (String)columns.get(j);
                if (!column.equals(key)) continue;
                found = j;
            }
            if (found < 0) {
                throw new SQLException("FULLTEXT", "Column not found: " + key);
            }
            index[i] = found;
        }
    }
}

