/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.list.DoubleArrayList;
import cern.jet.random.engine.DRand;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import hep.aida.IAxis;
import hep.aida.bin.AbstractBin1D;
import hep.aida.bin.MightyStaticBin1D;
import hep.aida.ref.Converter;
import java.util.Date;

public class QuantileBin1D
extends MightyStaticBin1D {
    protected DoubleQuantileFinder finder = null;

    protected QuantileBin1D() {
        super(false, false, 2);
    }

    public QuantileBin1D(double d) {
        this(false, Long.MAX_VALUE, d, 0.001, 10000, new DRand(new Date()));
    }

    public QuantileBin1D(boolean bl, long l, double d, double d2, int n, RandomElement randomElement) {
        this(bl, l, d, d2, n, randomElement, false, false, 2);
    }

    public QuantileBin1D(boolean bl, long l, double d, double d2, int n, RandomElement randomElement, boolean bl2, boolean bl3, int n2) {
        super(bl2, bl3, n2);
        this.finder = QuantileFinderFactory.newDoubleQuantileFinder(bl, l, d, d2, n, randomElement);
        this.clear();
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        super.addAllOfFromTo(doubleArrayList, n, n2);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(doubleArrayList, n, n2);
        }
    }

    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    public synchronized Object clone() {
        QuantileBin1D quantileBin1D = (QuantileBin1D)super.clone();
        if (this.finder != null) {
            quantileBin1D.finder = (DoubleQuantileFinder)quantileBin1D.finder.clone();
        }
        return quantileBin1D;
    }

    public String compareWith(AbstractBin1D abstractBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractBin1D));
        if (abstractBin1D instanceof QuantileBin1D) {
            QuantileBin1D quantileBin1D = (QuantileBin1D)abstractBin1D;
            stringBuffer.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25), quantileBin1D.quantile(0.25)) + ", " + this.relError(this.quantile(0.5), quantileBin1D.quantile(0.5)) + ", " + this.relError(this.quantile(0.75), quantileBin1D.quantile(0.75)));
            stringBuffer.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), quantileBin1D.quantileInverse(quantileBin1D.mean())) + " %");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public double median() {
        return this.quantile(0.5);
    }

    public synchronized double quantile(double d) {
        return this.quantiles(new DoubleArrayList(new double[]{d})).get(0);
    }

    public synchronized double quantileInverse(double d) {
        return this.finder.phi(d);
    }

    public synchronized DoubleArrayList quantiles(DoubleArrayList doubleArrayList) {
        return this.finder.quantileElements(doubleArrayList);
    }

    public int sizeOfRange(double d, double d2) {
        return (int)Math.round((double)this.size() * (this.quantileInverse(d2) - this.quantileInverse(d)));
    }

    public synchronized MightyStaticBin1D[] splitApproximately(DoubleArrayList doubleArrayList, int n) {
        int n2;
        int n3 = doubleArrayList.size();
        if (n < 1 || n3 < 2) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        int n4 = n3 - 1;
        double[] dArray2 = new double[1 + n * (n3 - 1)];
        dArray2[0] = dArray[0];
        int n5 = 1;
        int n6 = 0;
        while (n6 < n4) {
            double d = (dArray[n6 + 1] - dArray[n6]) / (double)n;
            n2 = 1;
            while (n2 <= n) {
                dArray2[n5++] = dArray[n6] + (double)n2 * d;
                ++n2;
            }
            ++n6;
        }
        double[] dArray3 = this.quantiles(new DoubleArrayList(dArray2)).elements();
        MightyStaticBin1D[] mightyStaticBin1DArray = new MightyStaticBin1D[n4];
        n2 = this.getMaxOrderForSumOfPowers();
        n2 = Math.min(10, n2);
        int n7 = this.size();
        n5 = 0;
        int n8 = 0;
        while (n8 < n4) {
            double d;
            double d2 = (dArray[n8 + 1] - dArray[n8]) / (double)n;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double[] dArray4 = null;
            if (n2 > 2) {
                dArray4 = new double[n2 - 2];
            }
            double d7 = d = dArray3[n5++];
            double d8 = (double)n7 * d2;
            int n9 = 1;
            while (n9 <= n) {
                double d9 = dArray3[n5++];
                double d10 = (d + d9) / 2.0;
                d3 += d10 * d8;
                d4 += d10 * d10 * d8;
                if (this.hasSumOfLogarithms) {
                    d5 += Math.log(d10) * d8;
                }
                if (this.hasSumOfInversions) {
                    d6 += 1.0 / d10 * d8;
                }
                if (n2 >= 3) {
                    dArray4[0] = dArray4[0] + d10 * d10 * d10 * d8;
                }
                if (n2 >= 4) {
                    dArray4[1] = dArray4[1] + d10 * d10 * d10 * d10 * d8;
                }
                int n10 = 5;
                while (n10 <= n2) {
                    int n11 = n10 - 3;
                    dArray4[n11] = dArray4[n11] + Math.pow(d10, n10) * d8;
                    ++n10;
                }
                d = d9;
                ++n9;
            }
            --n5;
            int n12 = (int)Math.round((dArray[n8 + 1] - dArray[n8]) * (double)n7);
            double d11 = d;
            d = d7;
            mightyStaticBin1DArray[n8] = new MightyStaticBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, n2);
            if (n12 > 0) {
                mightyStaticBin1DArray[n8].size = n12;
                mightyStaticBin1DArray[n8].min = d;
                mightyStaticBin1DArray[n8].max = d11;
                mightyStaticBin1DArray[n8].sum = d3;
                mightyStaticBin1DArray[n8].sum_xx = d4;
                mightyStaticBin1DArray[n8].sumOfLogarithms = d5;
                mightyStaticBin1DArray[n8].sumOfInversions = d6;
                mightyStaticBin1DArray[n8].sumOfPowers = dArray4;
            }
            ++n8;
        }
        return mightyStaticBin1DArray;
    }

    public synchronized MightyStaticBin1D[] splitApproximately(IAxis iAxis, int n) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(new Converter().edges(iAxis));
        doubleArrayList.beforeInsert(0, Double.NEGATIVE_INFINITY);
        doubleArrayList.add(Double.POSITIVE_INFINITY);
        int n2 = doubleArrayList.size();
        while (--n2 >= 0) {
            doubleArrayList.set(n2, this.quantileInverse(doubleArrayList.get(n2)));
        }
        return this.splitApproximately(doubleArrayList, n);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25) + ", " + this.quantile(0.5) + ", " + this.quantile(0.75));
        stringBuffer.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

