/*
 * Decompiled with CFR 0.152.
 */
package jal.FLOAT;

import jal.FLOAT.BinaryOperator;

public final class Numeric {
    public static float accumulate(float[] fArray, int n, int n2, float f) {
        float f2 = f;
        while (n < n2) {
            f2 += fArray[n++];
        }
        return f2;
    }

    public static float accumulate(float[] fArray, int n, int n2, float f, BinaryOperator binaryOperator) {
        float f2 = f;
        while (n < n2) {
            f2 = binaryOperator.apply(f2, fArray[n++]);
        }
        return f2;
    }

    public static float inner_product(float[] fArray, float[] fArray2, int n, int n2, int n3, float f) {
        float f2 = f;
        while (n < n2) {
            f2 += fArray[n++] * fArray2[n3++];
        }
        return f2;
    }

    public static float inner_product(float[] fArray, float[] fArray2, int n, int n2, int n3, float f, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        float f2 = f;
        while (n < n2) {
            f2 = binaryOperator.apply(f2, binaryOperator2.apply(fArray[n++], fArray2[n3++]));
        }
        return f2;
    }

    public static int partial_sum(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (n < n2) {
            fArray2[n3] = fArray[n];
            float f = fArray2[n3];
            while (++n < n2) {
                fArray2[++n3] = f += fArray[n];
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(float[] fArray, float[] fArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            fArray2[n3] = fArray[n];
            float f = fArray2[n3];
            while (++n < n2) {
                f = binaryOperator.apply(f, fArray[n]);
                fArray2[++n3] = f;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (n < n2) {
            fArray2[n3] = fArray[n];
            float f = fArray[n];
            while (++n < n2) {
                float f2 = fArray[n];
                fArray2[++n3] = f2 - f;
                f = f2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(float[] fArray, float[] fArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            fArray2[n3] = fArray[n];
            float f = fArray[n];
            while (++n < n2) {
                float f2 = fArray[n];
                fArray2[++n3] = binaryOperator.apply(f2, f);
                f = f2;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

