/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AllElementTest;
import com.hp.hpl.sparta.xpath.AttrTest;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.ExprFactory;
import com.hp.hpl.sparta.xpath.NodeTest;
import com.hp.hpl.sparta.xpath.ParentNodeTest;
import com.hp.hpl.sparta.xpath.TextTest;
import com.hp.hpl.sparta.xpath.ThisNodeTest;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.StreamTokenizer;

public class Step {
    public static Step DOT = new Step(ThisNodeTest.INSTANCE, TrueExpr.INSTANCE);
    private final NodeTest nodeTest_;
    private final BooleanExpr predicate_;
    private final boolean multiLevel_;

    Step(NodeTest nodeTest, BooleanExpr booleanExpr) {
        this.nodeTest_ = nodeTest;
        this.predicate_ = booleanExpr;
        this.multiLevel_ = false;
    }

    Step(XPath xPath, boolean bl, StreamTokenizer streamTokenizer) throws XPathException, IOException {
        this.multiLevel_ = bl;
        switch (streamTokenizer.ttype) {
            case 46: {
                if (streamTokenizer.nextToken() == 46) {
                    this.nodeTest_ = ParentNodeTest.INSTANCE;
                    break;
                }
                streamTokenizer.pushBack();
                this.nodeTest_ = ThisNodeTest.INSTANCE;
                break;
            }
            case 42: {
                this.nodeTest_ = AllElementTest.INSTANCE;
                break;
            }
            case 64: {
                if (streamTokenizer.nextToken() != -3) {
                    throw new XPathException(xPath, "after @ in node test", streamTokenizer, "name");
                }
                this.nodeTest_ = new AttrTest(streamTokenizer.sval);
                break;
            }
            case -3: {
                if (streamTokenizer.sval.equals("text")) {
                    if (streamTokenizer.nextToken() != 40 || streamTokenizer.nextToken() != 41) {
                        throw new XPathException(xPath, "after text", streamTokenizer, "()");
                    }
                    this.nodeTest_ = TextTest.INSTANCE;
                    break;
                }
                this.nodeTest_ = new ElementTest(streamTokenizer.sval);
                break;
            }
            default: {
                throw new XPathException(xPath, "at begininning of step", streamTokenizer, "'.' or '*' or name");
            }
        }
        if (streamTokenizer.nextToken() == 91) {
            streamTokenizer.nextToken();
            this.predicate_ = ExprFactory.createExpr(xPath, streamTokenizer);
            if (streamTokenizer.ttype != 93) {
                throw new XPathException(xPath, "after predicate expression", streamTokenizer, "]");
            }
            streamTokenizer.nextToken();
        } else {
            this.predicate_ = TrueExpr.INSTANCE;
        }
    }

    public String toString() {
        return this.nodeTest_.toString() + this.predicate_.toString();
    }

    public boolean isMultiLevel() {
        return this.multiLevel_;
    }

    public boolean isStringValue() {
        return this.nodeTest_.isStringValue();
    }

    public NodeTest getNodeTest() {
        return this.nodeTest_;
    }

    public BooleanExpr getPredicate() {
        return this.predicate_;
    }
}

