/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search;

import com.yahoo.java.ExtendedError;
import com.yahoo.rest.RestClient;
import com.yahoo.rest.RestException;
import com.yahoo.search.ContentAnalysisRequest;
import com.yahoo.search.ContentAnalysisResults;
import com.yahoo.search.ContextSearchRequest;
import com.yahoo.search.ImageSearchRequest;
import com.yahoo.search.ImageSearchResults;
import com.yahoo.search.LocalSearchRequest;
import com.yahoo.search.LocalSearchResults;
import com.yahoo.search.NewsSearchRequest;
import com.yahoo.search.NewsSearchResults;
import com.yahoo.search.RelatedSuggestionRequest;
import com.yahoo.search.RelatedSuggestionResults;
import com.yahoo.search.SearchException;
import com.yahoo.search.SpellingSuggestionRequest;
import com.yahoo.search.SpellingSuggestionResults;
import com.yahoo.search.VideoSearchRequest;
import com.yahoo.search.VideoSearchResults;
import com.yahoo.search.WebSearchRequest;
import com.yahoo.search.WebSearchResults;
import com.yahoo.search.xmlparser.XmlParserContentAnalysisResults;
import com.yahoo.search.xmlparser.XmlParserImageSearchResults;
import com.yahoo.search.xmlparser.XmlParserLocalSearchResults;
import com.yahoo.search.xmlparser.XmlParserNewsSearchResults;
import com.yahoo.search.xmlparser.XmlParserRelatedSuggestionResults;
import com.yahoo.search.xmlparser.XmlParserSpellingSuggestionResults;
import com.yahoo.search.xmlparser.XmlParserVideoSearchResults;
import com.yahoo.search.xmlparser.XmlParserWebSearchResults;
import com.yahoo.xml.XmlParser;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SearchClient {
    private static final String APPID_KEY = "appid";
    private String appId;

    public SearchClient(String string) {
        this.appId = string;
    }

    public ImageSearchResults imageSearch(ImageSearchRequest imageSearchRequest) throws IOException, SearchException {
        imageSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(imageSearchRequest.getRequestUrl(), imageSearchRequest.getParameters());
        return new XmlParserImageSearchResults(map);
    }

    public LocalSearchResults localSearch(LocalSearchRequest localSearchRequest) throws IOException, SearchException {
        localSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(localSearchRequest.getRequestUrl(), localSearchRequest.getParameters());
        return new XmlParserLocalSearchResults(map);
    }

    public NewsSearchResults newsSearch(NewsSearchRequest newsSearchRequest) throws IOException, SearchException {
        newsSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(newsSearchRequest.getRequestUrl(), newsSearchRequest.getParameters());
        return new XmlParserNewsSearchResults(map);
    }

    public VideoSearchResults videoSearch(VideoSearchRequest videoSearchRequest) throws IOException, SearchException {
        videoSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(videoSearchRequest.getRequestUrl(), videoSearchRequest.getParameters());
        return new XmlParserVideoSearchResults(map);
    }

    public WebSearchResults webSearch(WebSearchRequest webSearchRequest) throws IOException, SearchException {
        webSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(webSearchRequest.getRequestUrl(), webSearchRequest.getParameters());
        return new XmlParserWebSearchResults(map);
    }

    public SpellingSuggestionResults spellingSuggestion(SpellingSuggestionRequest spellingSuggestionRequest) throws IOException, SearchException {
        spellingSuggestionRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(spellingSuggestionRequest.getRequestUrl(), spellingSuggestionRequest.getParameters());
        return new XmlParserSpellingSuggestionResults(map);
    }

    public RelatedSuggestionResults relatedSuggestion(RelatedSuggestionRequest relatedSuggestionRequest) throws IOException, SearchException {
        relatedSuggestionRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(relatedSuggestionRequest.getRequestUrl(), relatedSuggestionRequest.getParameters());
        return new XmlParserRelatedSuggestionResults(map);
    }

    public WebSearchResults contextWebSearch(ContextSearchRequest contextSearchRequest) throws IOException, SearchException {
        contextSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(contextSearchRequest.getRequestUrl(), contextSearchRequest.getParameters());
        return new XmlParserWebSearchResults(map);
    }

    public ContentAnalysisResults termExtractionSearch(ContentAnalysisRequest contentAnalysisRequest) throws IOException, SearchException {
        contentAnalysisRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(contentAnalysisRequest.getRequestUrl(), contentAnalysisRequest.getParameters());
        return new XmlParserContentAnalysisResults(map);
    }

    private Map executeAndParse(String string, Map map) throws IOException, SearchException {
        XmlParser xmlParser = null;
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            xmlParser = new XmlParser();
            sAXParser.parse(RestClient.call(string, map), (DefaultHandler)xmlParser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExtendedError("XML parser not properly configured", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new SearchException("Error parsing XML response", sAXException);
        }
        catch (RestException restException) {
            throw new SearchException("Error calling service\n" + new String(restException.getErrorMessage(), "UTF-8"), restException);
        }
        return xmlParser.getRoot();
    }
}

