/*
 * Decompiled with CFR 0.152.
 */
package org.horrabin.horrorss;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import org.horrabin.horrorss.RssChannelBean;
import org.horrabin.horrorss.RssDublinCoreModuleBean;
import org.horrabin.horrorss.RssImageBean;
import org.horrabin.horrorss.RssItemBean;
import org.horrabin.horrorss.RssSlashModuleBean;
import org.horrabin.horrorss.RssSyndicationModuleBean;

public class RssParser {
    private Document doc;
    private String filename;
    private String xPath;
    private String channelXPath;
    private int TYPE_RDF = 0;
    private int TYPE_RSS = 1;
    private int rssType;

    public RssParser() {
        this.filename = "";
    }

    public RssParser(String file) {
        this.filename = file;
    }

    public void parse() {
        if (this.filename.startsWith("http://")) {
            this.parseFromURL();
        } else {
            this.parseFromFile();
        }
    }

    public void parse(String file) {
        if (file.startsWith("http://")) {
            this.parseFromURL();
        } else {
            this.parseFromFile();
        }
    }

    public RssChannelBean getChannel() {
        RssChannelBean res = new RssChannelBean(this.rssType);
        RssDublinCoreModuleBean dcBean = new RssDublinCoreModuleBean();
        RssSyndicationModuleBean syBean = new RssSyndicationModuleBean();
        try {
            Enumeration list = this.doc.xpathSelectElements(this.channelXPath);
            while (list.hasMoreElements()) {
                Element e = (Element)list.nextElement();
                if (e.getTagName().equals("title")) {
                    res.setTitle(e.toString());
                    continue;
                }
                if (e.getTagName().equals("link")) {
                    res.setLink(e.toString());
                    continue;
                }
                if (e.getTagName().equals("description")) {
                    res.setDescription(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("dc:") >= 0) {
                    dcBean = this.setDublinCoreElement(e, dcBean);
                    continue;
                }
                if (e.getTagName().indexOf("syn:") >= 0) {
                    syBean = this.setSyndicationElement(e, syBean);
                    continue;
                }
                if (e.getTagName().indexOf("language") >= 0) {
                    res.setLanguage(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("copyright") >= 0) {
                    res.setCopyright(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("managingEditor") >= 0) {
                    res.setPublisher(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("webMaster") >= 0) {
                    res.setCreator(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("pubDate") >= 0) {
                    res.setPubDate(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("lastBuildDate") >= 0) {
                    res.setLastBuildDate(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("category") >= 0) {
                    res.setCategory(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("generator") >= 0) {
                    res.setGenerator(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("docs") >= 0) {
                    res.setDocs(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("cloud") >= 0) {
                    res.setCloud(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("ttl") >= 0) {
                    res.setTtl(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("rating") < 0) continue;
                res.setRating(e.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Error obteniendo elemento canal de " + this.filename);
            System.out.println("RssParser:getChannel() ERROR: " + e.getMessage());
        }
        res.setDublinCoreModule(dcBean);
        res.setSyndicationModule(syBean);
        return res;
    }

    public RssImageBean getImage() {
        RssImageBean res = new RssImageBean();
        try {
            Enumeration list = this.doc.xpathSelectElements(this.xPath + "/image/*");
            if (!list.hasMoreElements()) {
                list = this.doc.xpathSelectElements(this.xPath + "/channel/image/*");
            }
            while (list.hasMoreElements()) {
                Element e = (Element)list.nextElement();
                if (e.getTagName().equals("title")) {
                    res.setTitle(e.toString());
                    continue;
                }
                if (e.getTagName().equals("url")) {
                    res.setUrl(e.toString());
                    continue;
                }
                if (!e.getTagName().equals("link")) continue;
                res.setLink(e.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Error obteniendo elemento imagen de " + this.filename);
            System.out.println("RssParser:getImage() ERROR: " + e.getMessage());
        }
        return res;
    }

    public Vector getItems() {
        Vector<RssItemBean> res = new Vector<RssItemBean>();
        try {
            Enumeration list = this.doc.xpathSelectElements(this.xPath + "/item");
            int i = 1;
            while (list.hasMoreElements()) {
                Element e = (Element)list.nextElement();
                res.add(this.getItem(i));
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error el Vector de elementos item de " + this.filename);
            System.out.println("RssParser:getItems() ERROR: " + e.getMessage());
        }
        return res;
    }

    private RssItemBean getItem(int index) {
        RssItemBean res = new RssItemBean(this.rssType);
        RssDublinCoreModuleBean dcBean = new RssDublinCoreModuleBean();
        RssSlashModuleBean slashBean = new RssSlashModuleBean();
        try {
            Enumeration list = this.doc.xpathSelectElements(this.xPath + "/item[" + index + "]/*");
            while (list.hasMoreElements()) {
                Element e = (Element)list.nextElement();
                if (e.getTagName().equals("title")) {
                    res.setTitle(e.toString());
                    continue;
                }
                if (e.getTagName().equals("link")) {
                    res.setLink(e.toString());
                    continue;
                }
                if (e.getTagName().equals("description")) {
                    res.setDescription(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("dc:") >= 0) {
                    dcBean = this.setDublinCoreElement(e, dcBean);
                    continue;
                }
                if (e.getTagName().indexOf("slash:") >= 0) {
                    slashBean = this.setSlashElement(e, slashBean);
                    continue;
                }
                if (e.getTagName().indexOf("author") >= 0) {
                    res.setAuthor(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("pubDate") >= 0) {
                    res.setPubDate(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("category") >= 0) {
                    res.setCategory(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("comments") >= 0) {
                    res.setComments(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("enclosure") >= 0) {
                    res.setEnclosure(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("guid") >= 0) {
                    res.setGuid(e.toString());
                    continue;
                }
                if (e.getTagName().indexOf("source") < 0) continue;
                res.setSource(e.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Error obteniendo elemento item de la posicion " + index + " de " + this.filename);
            System.out.println("RssParser:getItem(int index) ERROR: " + e.getMessage());
        }
        res.setDublinCoreModule(dcBean);
        res.setSlashModule(slashBean);
        return res;
    }

    private RssDublinCoreModuleBean setDublinCoreElement(Element e, RssDublinCoreModuleBean dcBean) {
        if (e.getTagName().equals("dc:title")) {
            dcBean.setTitle(e.toString());
        } else if (e.getTagName().equals("dc:creator")) {
            dcBean.setCreator(e.toString());
        } else if (e.getTagName().equals("dc:subject")) {
            dcBean.setSubject(e.toString());
        } else if (e.getTagName().equals("dc:description")) {
            dcBean.setDescription(e.toString());
        } else if (e.getTagName().equals("dc:publisher")) {
            dcBean.setPublisher(e.toString());
        } else if (e.getTagName().equals("dc:contributor")) {
            dcBean.setContributor(e.toString());
        } else if (e.getTagName().equals("dc:date")) {
            dcBean.setDate(e.toString());
        } else if (e.getTagName().equals("dc:type")) {
            dcBean.setType(e.toString());
        } else if (e.getTagName().equals("dc:format")) {
            dcBean.setFormat(e.toString());
        } else if (e.getTagName().equals("dc:indentifier")) {
            dcBean.setIdentifier(e.toString());
        } else if (e.getTagName().equals("dc:source")) {
            dcBean.setSource(e.toString());
        } else if (e.getTagName().equals("dc:language")) {
            dcBean.setLanguage(e.toString());
        } else if (e.getTagName().equals("dc:relation")) {
            dcBean.setRelation(e.toString());
        } else if (e.getTagName().equals("dc:coverage")) {
            dcBean.setCoverage(e.toString());
        } else if (e.getTagName().equals("dc:rights")) {
            dcBean.setRights(e.toString());
        }
        return dcBean;
    }

    private RssSlashModuleBean setSlashElement(Element e, RssSlashModuleBean slashBean) {
        if (e.getTagName().equals("slash:section")) {
            slashBean.setSection(e.toString());
        } else if (e.getTagName().equals("slash:department")) {
            slashBean.setDepartment(e.toString());
        } else if (e.getTagName().equals("slash:comments")) {
            slashBean.setComments(new Integer(e.toString()));
        } else if (e.getTagName().equals("slash:hit_parade")) {
            slashBean.setHitParade(e.toString());
        }
        return slashBean;
    }

    private RssSyndicationModuleBean setSyndicationElement(Element e, RssSyndicationModuleBean syBean) {
        if (e.getTagName().equals("syn:updatePeriod")) {
            syBean.setPeriod(e.toString());
        } else if (e.getTagName().equals("syn:updateFrequency")) {
            syBean.setFrequency(new Integer(e.toString()));
        } else if (e.getTagName().equals("syn:updateBase")) {
            syBean.setBase(e.toString());
        }
        return syBean;
    }

    private void parseFromFile() {
        try {
            File xmlFile = new File(this.filename);
            this.doc = Parser.parse(xmlFile);
        }
        catch (Exception e) {
            System.out.println("Error leyendo el fichero " + this.filename);
            System.out.println("RssParser:parseFromFile() ERROR: " + e.getMessage());
            this.doc = new Document();
        }
        this.setChannelXPath();
    }

    private void parseFromURL() {
        BufferedReader buffer = this.getReader(this.filename);
        String xml = "";
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                xml = xml + line;
            }
            this.doc = Parser.parse(xml);
        }
        catch (Exception e) {
            System.out.println("Error leyendo el fichero " + this.filename);
            System.out.println("RssParser:parseFromURL() ERROR: " + e.getMessage());
            this.doc = new Document();
        }
        this.setChannelXPath();
    }

    private BufferedReader getReader(String url) {
        BufferedReader buffer = null;
        try {
            URL urlConn = new URL(url);
            URLConnection conn = urlConn.openConnection();
            InputStreamReader input = new InputStreamReader(conn.getInputStream());
            buffer = new BufferedReader(input);
            return buffer;
        }
        catch (IOException e) {
            System.out.println("Error obteniendo lector de " + url);
            System.out.println("RssParser:getReader(String url) ERROR: " + e.getMessage());
            return null;
        }
    }

    private String getRootXPath() {
        String xPath = null;
        try {
            Enumeration list = this.doc.xpathSelectElements("rdf:RDF");
            xPath = list.hasMoreElements() ? "rdf:RDF" : "rss/channel";
        }
        catch (Exception e) {
            System.out.println("Error obteniendo XPath raiz del fichero " + this.filename);
            System.out.println("RssParser:getRootXPath ERROR: " + e.getMessage());
        }
        return xPath;
    }

    private void setChannelXPath() {
        this.xPath = this.getRootXPath();
        if (this.xPath.equals("rdf:RDF")) {
            this.channelXPath = this.xPath + "/channel/*";
            this.rssType = this.TYPE_RDF;
        } else {
            this.channelXPath = this.xPath + "/*";
            this.rssType = this.TYPE_RSS;
        }
    }
}

