/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import visualizer.graph.Vertex;

public class Edge
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean selected = false;
    private Color color = Color.WHITE;
    private Vertex source = null;
    private Vertex target = null;

    public Edge(Vertex source, Vertex target) {
        this.source = source;
        this.target = target;
    }

    public void draw(Graphics2D g2) {
        this.color = new Color((this.source.getColor().getRed() + this.target.getColor().getRed()) / 2, (this.source.getColor().getGreen() + this.target.getColor().getGreen()) / 2, (this.source.getColor().getBlue() + this.target.getColor().getBlue()) / 2);
        g2.setColor(this.color);
        if (this.selected) {
            g2.setStroke(new BasicStroke(4.0f));
            g2.drawLine((int)this.source.getX(), (int)this.source.getY(), (int)this.target.getX(), (int)this.target.getY());
            g2.setStroke(new BasicStroke(1.0f));
        } else {
            g2.drawLine((int)this.source.getX(), (int)this.source.getY(), (int)this.target.getX(), (int)this.target.getY());
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge e = (Edge)obj;
            return this.source.getId() == e.source.getId() && this.target.getId() == e.target.getId() || this.source.getId() == e.target.getId() && this.target.getId() == e.source.getId();
        }
        return false;
    }

    public int compareTo(Object o) {
        long source = 0L;
        long target = 0L;
        if (this.source.getId() < this.target.getId()) {
            source = this.source.getId();
            target = this.target.getId();
        } else {
            source = this.target.getId();
            target = this.source.getId();
        }
        long sourceComp = 0L;
        long targetComp = 0L;
        if (((Edge)o).source.getId() < ((Edge)o).target.getId()) {
            sourceComp = ((Edge)o).source.getId();
            targetComp = ((Edge)o).target.getId();
        } else {
            sourceComp = ((Edge)o).target.getId();
            targetComp = ((Edge)o).source.getId();
        }
        if (source - sourceComp < 0L) {
            return -1;
        }
        if (source - sourceComp > 0L) {
            return 1;
        }
        if (target - targetComp < 0L) {
            return -1;
        }
        if (target - targetComp > 0L) {
            return 1;
        }
        return 0;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

