/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import visualizer.graph.Edge;
import visualizer.graph.QuerySolver;
import visualizer.graph.Vertex;
import visualizer.triangulation.Triangulation;
import visualizer.util.HierarchicalClustering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EPSILON = 1.0E-5f;
    private boolean isEdgeVisible = true;
    private Vector<String> scalarsNames = new Vector();
    private Vector<Vertex> vertex = new Vector();
    private Vector<Triangulation> triangulations = new Vector();

    public Dimension getSize() {
        if (this.vertex.size() > 0) {
            float maxX = this.vertex.elementAt(0).getX();
            float minX = this.vertex.elementAt(0).getX();
            float maxY = this.vertex.elementAt(0).getY();
            float minY = this.vertex.elementAt(0).getY();
            for (Vertex v : this.vertex) {
                if (maxX < v.getX()) {
                    maxX = v.getX();
                } else if (minX > v.getX()) {
                    minX = v.getX();
                }
                if (maxY < v.getY()) {
                    maxY = v.getY();
                    continue;
                }
                if (!(minY > v.getY())) continue;
                minY = v.getY();
            }
            int w = (int)(maxX + (float)(Vertex.getRayBase() * 5));
            int h = (int)(maxY + (float)(Vertex.getRayBase() * 5));
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    public Vertex getVerticeByPosition(int x, int y) {
        for (Vertex vertex : this.vertex) {
            if (!vertex.isInside(x, y)) continue;
            return vertex;
        }
        return null;
    }

    public void draw(String triangulation, Graphics2D g2) {
        Triangulation tri;
        if (triangulation != null && (tri = this.getTriangulation(triangulation)) != null) {
            Vector<Edge> edges = tri.getEdges();
            if (this.isEdgeVisible) {
                for (Edge edge : edges) {
                    edge.draw(g2);
                }
            }
        }
        for (Vertex vertex : this.vertex) {
            vertex.draw(g2);
        }
    }

    public Vector<Vertex> getVertex() {
        return this.vertex;
    }

    public void setVertex(Vector<Vertex> vertex) {
        this.vertex = vertex;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.normalizeVertex(Vertex.getRayBase() * 5 + 10, (float)d.getHeight() / 1.45f);
    }

    public void getNeighbors(Vector<Vertex> neighborsVertex, Vector<Edge> neighborsEdges, String triangulation, Vertex vertex, int depth) {
        Triangulation tri = this.getTriangulation(triangulation);
        if (tri != null) {
            Vector<Edge> edges = tri.getEdges();
            Vector<Vertex> visitedVertex = new Vector<Vertex>();
            Vector<Vertex> vertexToVisit = new Vector<Vertex>();
            vertexToVisit.add(vertex);
            for (int i = 0; i < depth; ++i) {
                for (int j = 0; j < vertexToVisit.size(); ++j) {
                    Vertex v = (Vertex)vertexToVisit.get(j);
                    for (Edge e : edges) {
                        if (e.getSource().getId() == v.getId() && !neighborsVertex.contains(e.getTarget())) {
                            neighborsVertex.add(e.getTarget());
                            visitedVertex.add(e.getTarget());
                            if (neighborsEdges != null && !neighborsEdges.contains(e)) {
                                neighborsEdges.add(e);
                            }
                        }
                        if (e.getTarget().getId() != v.getId() || neighborsVertex.contains(e.getSource())) continue;
                        neighborsVertex.add(e.getSource());
                        visitedVertex.add(e.getSource());
                        if (neighborsEdges == null || neighborsEdges.contains(e)) continue;
                        neighborsEdges.add(e);
                    }
                }
                vertexToVisit = visitedVertex;
                visitedVertex = new Vector();
            }
            neighborsVertex.remove(vertex);
        }
    }

    public void createCdata(String word) throws IOException {
        String scalarName = "'" + word + "'";
        int index = this.addScalarName(scalarName);
        QuerySolver qS = new QuerySolver(this.vertex);
        qS.createCdata(word, index);
    }

    public void addTriangulation(Triangulation triangulation) {
        this.triangulations.add(triangulation);
    }

    public void removeTriangulation(String name) {
        for (Triangulation t : this.triangulations) {
            if (!name.equals(t.getName())) continue;
            this.triangulations.remove(t);
            break;
        }
    }

    public Vector<String> getTriangulationsNames() {
        Vector<String> names = new Vector<String>();
        for (Triangulation t : this.triangulations) {
            names.add(t.getName());
        }
        return names;
    }

    public void normalizeVertex(float begin, float end) {
        float maxX = this.vertex.elementAt(0).getX();
        float minX = this.vertex.elementAt(0).getX();
        float maxY = this.vertex.elementAt(0).getY();
        float minY = this.vertex.elementAt(0).getY();
        for (Vertex v : this.vertex) {
            if (maxX < v.getX()) {
                maxX = v.getX();
            } else if (minX > v.getX()) {
                minX = v.getX();
            }
            if (maxY < v.getY()) {
                maxY = v.getY();
                continue;
            }
            if (!(minY > v.getY())) continue;
            minY = v.getY();
        }
        float endX = (maxX - minX) * end;
        if (maxY != minY) {
            endX = (maxX - minX) * end / (maxY - minY);
        }
        for (Vertex v : this.vertex) {
            if (maxX != minX) {
                v.setX((v.getX() - minX) / (maxX - minX) * (endX - begin) + begin);
            } else {
                v.setX((end + begin) / 2.0f);
            }
            if (maxY != minY) {
                v.setY((v.getY() - minY) / (maxY - minY) * (end - begin) + begin);
                continue;
            }
            v.setY((end + begin) / 2.0f);
        }
    }

    public void normalizeScalars(float begin, float end) {
        for (String n : this.scalarsNames) {
            float max = this.vertex.elementAt(0).getScalar(this.getScalarIndex(n));
            float min = this.vertex.elementAt(0).getScalar(this.getScalarIndex(n));
            for (Vertex v : this.vertex) {
                if (max < v.getScalar(this.getScalarIndex(n))) {
                    max = v.getScalar(this.getScalarIndex(n));
                    continue;
                }
                if (!(min > v.getScalar(this.getScalarIndex(n)))) continue;
                min = v.getScalar(this.getScalarIndex(n));
            }
            for (Vertex v : this.vertex) {
                if (max != min) {
                    v.setScalar(this.getScalarIndex(n), (v.getScalar(this.getScalarIndex(n)) - min) / (max - min) * (end - begin) + begin);
                    continue;
                }
                v.setScalar(this.getScalarIndex(n), begin);
            }
        }
    }

    public int addScalarName(String name) {
        if (!this.scalarsNames.contains(name)) {
            this.scalarsNames.add(name);
        }
        return this.scalarsNames.indexOf(name);
    }

    public Vector<String> getScalarNames() {
        return this.scalarsNames;
    }

    public int removeScalarName(String name) {
        int index = this.scalarsNames.indexOf(name);
        this.scalarsNames.remove(name);
        return index;
    }

    public int getScalarIndex(String name) {
        if (this.scalarsNames.contains(name)) {
            return this.scalarsNames.indexOf(name);
        }
        return -1;
    }

    public String createHC(int type) throws IOException {
        int i;
        float[][] projection = new float[this.getVertex().size()][];
        for (int i2 = 0; i2 < this.getVertex().size(); ++i2) {
            projection[i2] = new float[2];
            projection[i2][0] = this.getVertex().elementAt(i2).getX();
            projection[i2][1] = this.getVertex().elementAt(i2).getY();
        }
        HierarchicalClustering hc = new HierarchicalClustering(projection, type){

            public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
                float sum = 0.0f;
                float sub = 0.0f;
                for (int i = 0; i < pointA.length; ++i) {
                    sub = pointA[i] - pointB[i];
                    sum += sub * sub;
                }
                return (float)Math.sqrt(sum);
            }
        };
        float[] hcScalars = hc.getPointsHeight();
        float max = hcScalars[0];
        float min = hcScalars[0];
        for (i = 1; i < hcScalars.length; ++i) {
            if (hcScalars[i] > max) {
                max = hcScalars[i];
                continue;
            }
            if (!(hcScalars[i] < min)) continue;
            min = hcScalars[i];
        }
        for (i = 0; i < hcScalars.length; ++i) {
            hcScalars[i] = max - min > 0.0f ? (hcScalars[i] - min) / (max - min) : 0.0f;
        }
        String scalarname = "hc-slink";
        if (type == 2) {
            scalarname = "hc-alink";
        } else if (type == 1) {
            scalarname = "hc-clink";
        }
        int index = this.addScalarName(scalarname);
        for (int i3 = 0; i3 < this.getVertex().size(); ++i3) {
            this.getVertex().elementAt(i3).setScalar(index, hcScalars[i3]);
        }
        return scalarname;
    }

    public void removeVertex(Vector<Vertex> vertex) {
        int i;
        for (i = 0; i < vertex.size(); ++i) {
            Vertex v = vertex.get(i);
            this.vertex.remove(v);
            for (String name : this.getTriangulationsNames()) {
                Vector<Edge> edges;
                Triangulation tri = this.getTriangulation(name);
                if (tri == null || (edges = tri.getEdges()) == null) continue;
                for (int j = 0; j < edges.size(); ++j) {
                    if (edges.get(j).getSource() != v && edges.get(j).getTarget() != v) continue;
                    tri.getEdges().remove(j);
                    --j;
                }
            }
        }
        for (i = 0; i < this.vertex.size(); ++i) {
            this.vertex.get(i).setId(i);
        }
    }

    public Graph cutGraph(Vector<Vertex> vertex) {
        Hashtable<Vertex, Vertex> vertexMap = new Hashtable<Vertex, Vertex>();
        Vector<Vertex> newVertex = new Vector<Vertex>();
        for (int i = 0; i < vertex.size(); ++i) {
            Vertex v = vertex.elementAt(i);
            Vertex newV = new Vertex(v.getWebElement(), i);
            newV.setColor(new Color(v.getColor().getRGB()));
            newV.setX(v.getX());
            newV.setY(v.getY());
            newV.setRayFactor(v.getRayFactor());
            for (String name : this.getScalarNames()) {
                newV.setScalar(this.getScalarIndex(name), v.getScalar(this.getScalarIndex(name)));
            }
            newVertex.add(newV);
            vertexMap.put(v, newV);
        }
        Graph graph = new Graph();
        graph.setVertex(newVertex);
        for (String name : this.getScalarNames()) {
            graph.addScalarName(name);
        }
        for (String name : this.getTriangulationsNames()) {
            Triangulation oldTriang = this.getTriangulation(name);
            Vector<Edge> oldEdges = oldTriang.getEdges();
            Triangulation newTriang = new Triangulation(name);
            Vector<Edge> edges = new Vector<Edge>();
            for (int i = 0; i < vertex.size(); ++i) {
                Vertex v = vertex.elementAt(i);
                if (oldEdges == null) continue;
                for (Edge e : oldEdges) {
                    if (e.getSource() == v && vertex.contains(e.getTarget())) {
                        edges.add(new Edge((Vertex)vertexMap.get(e.getSource()), (Vertex)vertexMap.get(e.getTarget())));
                    }
                    if (e.getTarget() != v || !vertex.contains(e.getSource())) continue;
                    edges.add(new Edge((Vertex)vertexMap.get(e.getSource()), (Vertex)vertexMap.get(e.getTarget())));
                }
            }
            newTriang.setEdges(edges);
            graph.addTriangulation(newTriang);
        }
        return graph;
    }

    public boolean isEdgeVisible() {
        return this.isEdgeVisible;
    }

    public void setEdgeVisible(boolean isEdgeVisible) {
        this.isEdgeVisible = isEdgeVisible;
    }

    public Triangulation getTriangulation(String name) {
        for (Triangulation t : this.triangulations) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public Vector<Triangulation> getTriangulations() {
        return this.triangulations;
    }

    public void perturb() {
        ArrayList<Vertex> vertex_aux = new ArrayList<Vertex>();
        for (Vertex v : this.vertex) {
            vertex_aux.add(v);
        }
        Collections.sort(vertex_aux);
        for (int i = 0; i < vertex_aux.size() - 1; ++i) {
            if (!(Math.abs(((Vertex)vertex_aux.get(i)).getX() - ((Vertex)vertex_aux.get(i + 1)).getX()) < 1.0E-5f) || !(Math.abs(((Vertex)vertex_aux.get(i)).getY() - ((Vertex)vertex_aux.get(i + 1)).getY()) < 1.0E-5f)) continue;
            ((Vertex)vertex_aux.get(i)).setX((float)((double)((Vertex)vertex_aux.get(i)).getX() + (double)(((Vertex)vertex_aux.get(i)).getX() / 100.0f) * Math.random()));
            ((Vertex)vertex_aux.get(i)).setY((float)((double)((Vertex)vertex_aux.get(i)).getY() + (double)(((Vertex)vertex_aux.get(i)).getY() / 100.0f) * Math.random()));
        }
    }
}

