/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import visualizer.projection.FastmapProjection;
import visualizer.projection.ForceScheme;
import visualizer.projection.Projector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.projection.distance.FastmapSimilarity;
import visualizer.util.Kmeans;
import visualizer.util.PointsReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvexHullProjection {
    private float clusterFactor = 4.0f;
    private DistanceMeasure measure = new FastmapSimilarity();
    private int numberNeighbors = 3;
    private int numberPivots = 10;
    private float fractionDelta = 8.0f;
    private int numberIterations = 50;
    private Class projectionType = FastmapProjection.class;

    public float[][] project(float[][] points) throws IOException {
        this.numberPivots = (int)Math.sqrt(points.length);
        long start = System.currentTimeMillis();
        Kmeans kmeans = new Kmeans(this.numberPivots){

            public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
                return ConvexHullProjection.this.measure.calculateDistance(pointA, pointB);
            }
        };
        Vector<Vector<Integer>> clusters = kmeans.doClustering(points);
        int[] pivots = kmeans.getMedoids(points);
        long finish = System.currentTimeMillis();
        System.out.println("Defining the pivots time: " + (float)(finish - start) / 1000.0f + "s");
        start = System.currentTimeMillis();
        float[][] pCoords = new float[pivots.length][];
        for (int i = 0; i < pivots.length; ++i) {
            pCoords[i] = points[pivots[i]];
        }
        float[][] pProjection = this.createPivotsProjection(pCoords);
        finish = System.currentTimeMillis();
        System.out.println("Pivots projection time: " + (float)(finish - start) / 1000.0f + "s");
        float[][] projection = new float[points.length][];
        for (int i = 0; i < projection.length; ++i) {
            projection[i] = new float[2];
        }
        Vector<Integer> pointsProjected = new Vector<Integer>();
        for (int i = 0; i < pivots.length; ++i) {
            pointsProjected.add(pivots[i]);
            projection[pivots[i]][0] = pProjection[i][0];
            projection[pivots[i]][1] = pProjection[i][1];
        }
        start = System.currentTimeMillis();
        Vector<Integer> sequence = this.defineSequence(clusters, pivots, points);
        for (int i = 0; i < sequence.size(); ++i) {
            Vector<Integer> neighbors = this.getNearestNeighbors(pointsProjected, sequence.get(i), points);
            this.positioningNewPoint(sequence.get(i), projection, neighbors, points);
            pointsProjected.add(sequence.get(i));
        }
        finish = System.currentTimeMillis();
        System.out.println("Interpolating time: " + (float)(finish - start) / 1000.0f + "s");
        this.normalize2D(projection, 0.0f, 1.0f);
        return projection;
    }

    public float getClusterFactor() {
        return this.clusterFactor;
    }

    public void setClusterFactor(float clusterFactor) {
        this.clusterFactor = clusterFactor;
    }

    public int getNumberPivots() {
        return this.numberPivots;
    }

    public void setNumberPivots(int numberPivots) {
        this.numberPivots = numberPivots;
    }

    public float getFractionDelta() {
        return this.fractionDelta;
    }

    public void setFractionDelta(float fractionDelta) {
        this.fractionDelta = fractionDelta;
    }

    public int getNumberIterations() {
        return this.numberIterations;
    }

    public void setNumberIterations(int numberIterations) {
        this.numberIterations = numberIterations;
    }

    public int getNumberNeighbors() {
        return this.numberNeighbors;
    }

    public void setNumberNeighbors(int numberNeighbors) {
        this.numberNeighbors = numberNeighbors;
    }

    private Vector<Integer> defineSequence(Vector<Vector<Integer>> clusters, int[] medoids, float[][] points) throws IOException {
        Vector sequences = new Vector();
        for (int c = 0; c < clusters.size(); ++c) {
            ArrayList<Point> clusterSeq = new ArrayList<Point>();
            for (int e = 0; e < clusters.get(c).size(); ++e) {
                if (medoids[c] == clusters.get(c).get(e)) continue;
                float distance = this.measure.calculateDistance(points[medoids[c]], points[clusters.get(c).get(e)]);
                clusterSeq.add(new Point(clusters.get(c).get(e), distance));
            }
            Collections.sort(clusterSeq);
            sequences.add(clusterSeq);
        }
        Vector<Integer> sequence = new Vector<Integer>();
        boolean empty = false;
        while (!empty) {
            empty = true;
            for (int s = 0; s < sequences.size(); ++s) {
                if (((ArrayList)sequences.get(s)).isEmpty()) continue;
                Point p = (Point)((ArrayList)sequences.get(s)).remove(0);
                sequence.add(p.id);
                if (((ArrayList)sequences.get(s)).isEmpty()) continue;
                empty = false;
            }
        }
        return sequence;
    }

    private void positioningNewPoint(int newPoint, float[][] projection, Vector<Integer> neighbors, float[][] points) throws IOException {
        float[] distances = new float[neighbors.size()];
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < neighbors.size(); ++i) {
            distances[i] = this.measure.calculateDistance(points[neighbors.get(i)], points[newPoint]);
            if (distances[i] < 1.0E-7f) {
                distances[i] = 1.0E-7f;
            }
            if (distances[i] > max) {
                max = distances[i];
                continue;
            }
            if (!(distances[i] < min)) continue;
            min = distances[i];
        }
        float sum = 0.0f;
        for (int i = 0; i < neighbors.size(); ++i) {
            distances[i] = max != min ? (distances[i] - min) / (max - min) * 100.1f + 0.1f : 0.1f;
            distances[i] = (float)Math.pow(distances[i], this.clusterFactor);
            sum += 1.0f / distances[i];
        }
        float xCoord = 0.0f;
        for (int i = 0; i < neighbors.size(); ++i) {
            xCoord += projection[neighbors.get(i)][0] * (1.0f / distances[i]);
        }
        xCoord /= sum;
        float yCoord = 0.0f;
        for (int i = 0; i < neighbors.size(); ++i) {
            yCoord += projection[neighbors.get(i)][1] * (1.0f / distances[i]);
        }
        projection[newPoint][0] = xCoord;
        projection[newPoint][1] = yCoord /= sum;
    }

    private Vector<Integer> getNearestNeighbors(Vector<Integer> list, int point, float[][] points) throws IOException {
        if (list.size() > this.numberNeighbors) {
            ArrayList<Point> aux_list = new ArrayList<Point>();
            for (int p : list) {
                float dist = this.measure.calculateDistance(points[point], points[p]);
                aux_list.add(new Point(p, dist));
            }
            Collections.sort(aux_list);
            Vector<Integer> return_list = new Vector<Integer>();
            for (int i = 0; i < this.numberNeighbors; ++i) {
                return_list.add(((Point)aux_list.get((int)i)).id);
            }
            return return_list;
        }
        return list;
    }

    private float[][] createPivotsProjection(float[][] pivots) throws IOException {
        float[][] projection = null;
        try {
            DistanceMatrix dmat = new DistanceMatrix(pivots){

                public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
                    return ConvexHullProjection.this.measure.calculateDistance(pointA, pointB);
                }
            };
            Projector proj = (Projector)this.projectionType.newInstance();
            projection = proj.project(dmat);
            if (projection != null) {
                ForceScheme force = new ForceScheme(this.fractionDelta, projection.length);
                for (int i = 0; i < this.numberIterations; ++i) {
                    force.iteration(dmat, projection);
                }
            }
            this.normalize2D(projection, 0.0f, 1.0f);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        return projection;
    }

    private void normalize2D(float[][] projection, float begin, float end) {
        float maxX = projection[0][0];
        float minX = projection[0][0];
        float maxY = projection[0][1];
        float minY = projection[0][1];
        for (int _ins = 1; _ins < projection.length; ++_ins) {
            if (minX > projection[_ins][0]) {
                minX = projection[_ins][0];
            } else if (maxX < projection[_ins][0]) {
                maxX = projection[_ins][0];
            }
            if (minY > projection[_ins][1]) {
                minY = projection[_ins][1];
                continue;
            }
            if (!(maxY < projection[_ins][1])) continue;
            maxY = projection[_ins][1];
        }
        float endY = (maxY - minY) / (maxX - minX);
        for (int _ins = 0; _ins < projection.length; ++_ins) {
            projection[_ins][0] = (double)(maxX - minX) > 0.0 ? (projection[_ins][0] - minX) / (maxX - minX) : 0.0f;
            projection[_ins][1] = (double)(maxY - minY) > 0.0 ? (projection[_ins][1] - minY) / ((maxY - minY) * endY) : 0.0f;
        }
    }

    private static void perturbNullVectors(float[][] points) {
        for (int i = 0; i < points.length; ++i) {
            boolean nullVector = true;
            for (int j = 0; j < points[i].length; ++j) {
                if ((double)points[i][j] == 0.0) continue;
                nullVector = false;
                break;
            }
            if (nullVector) {
                points[i][points[i].length - 3] = 0.25f;
                points[i][points[i].length - 2] = 0.25f;
                points[i][points[i].length - 1] = 0.25f;
                continue;
            }
            if ((double)points[i][points[i].length - 3] > 0.0) {
                float[] fArray = points[i];
                int n = points[i].length - 3;
                fArray[n] = fArray[n] + 0.25f;
            }
            if ((double)points[i][points[i].length - 2] > 0.0) {
                float[] fArray = points[i];
                int n = points[i].length - 2;
                fArray[n] = fArray[n] + 0.25f;
            }
            if (!((double)points[i][points[i].length - 1] > 0.0)) continue;
            float[] fArray = points[i];
            int n = points[i].length - 1;
            fArray[n] = fArray[n] + 0.25f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            PointsReader reader = new PointsReader("E:\\cbr-ilp-ir.data");
            float[][] points = reader.getPoints();
            float[] cdata = reader.getCdata();
            ConvexHullProjection.perturbNullVectors(points);
            FastmapSimilarity.normalize(points);
            ConvexHullProjection lp = new ConvexHullProjection();
            float[][] projection = lp.project(points);
            BufferedWriter out1 = null;
            try {
                out1 = new BufferedWriter(new FileWriter("E:\\cbr-ilp-ir.prj"));
                out1.write("#Source: ");
                out1.write("\n");
                out1.write("#Number objects: ");
                out1.write(Integer.toString(projection.length));
                out1.write("\n");
                out1.write("#Number dimensions: 2");
                out1.write("\n");
                for (int i = 0; i < projection.length; ++i) {
                    out1.write(Float.toString(projection[i][0]));
                    out1.write(" ");
                    out1.write(Float.toString(projection[i][1]));
                    out1.write(" ");
                    out1.write(Float.toString(cdata[i]));
                    out1.write("\n");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out1 != null) {
                    try {
                        out1.flush();
                        out1.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    class Point
    implements Comparable {
        public int id;
        public float distance;

        public Point(int id, float distance) {
            this.id = id;
            this.distance = distance;
        }

        public int compareTo(Object o) {
            float aux = this.distance - ((Point)o).distance;
            return (double)aux < 0.0 ? -1 : ((double)aux == 0.0 ? 0 : 1);
        }
    }
}

