/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.projection.distance.FastmapSimilarity;
import visualizer.triangulation.Neighborhood;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshGenerator {
    public Vector<Neighborhood> execute(Vector<Neighborhood> neighbors, Vector<Vector<Integer>> clusters, int[] medoids, DistanceMatrix dmat) {
        HashSet<Integer> visitados = new HashSet<Integer>();
        HashSet<Integer> h_visitar = new HashSet<Integer>();
        HashSet<Integer> n_visitados = new HashSet<Integer>();
        h_visitar.add(0);
        for (int i = 1; i < neighbors.size(); ++i) {
            n_visitados.add(i);
        }
        while (n_visitados.size() > 0) {
            int n;
            if (h_visitar.size() > 0) {
                n = (Integer)h_visitar.iterator().next();
                visitados.add(n);
                h_visitar.remove(new Integer(n));
                n_visitados.remove(new Integer(n));
                for (int i = 0; i < neighbors.get(n).getNeighbors().size(); ++i) {
                    if (visitados.contains((int)neighbors.get((int)n).getNeighbors().get((int)i).id)) continue;
                    h_visitar.add((int)neighbors.get((int)n).getNeighbors().get((int)i).id);
                }
                continue;
            }
            n = (Integer)n_visitados.iterator().next();
            n_visitados.remove(new Integer(n));
            h_visitar.add(n);
            Iterator visitados_it = visitados.iterator();
            int nearNode = 0;
            float minDist = Float.MAX_VALUE;
            while (visitados_it.hasNext()) {
                int nearNode_aux = (Integer)visitados_it.next();
                float distance = dmat.getDistance(nearNode_aux, n);
                if (!(minDist > distance)) continue;
                minDist = distance;
                nearNode = nearNode_aux;
            }
            neighbors.get(n).addNeighbor(new Neighborhood.Neighbor(nearNode, minDist));
            neighbors.get(nearNode).addNeighbor(new Neighborhood.Neighbor(n, minDist));
        }
        return neighbors;
    }

    public Vector<Neighborhood> execute(Vector<Neighborhood> neighbors, Vector<Vector<Integer>> clusters, float[][] centroids, float[][] points, DistanceMeasure metric) throws IOException {
        if (metric instanceof FastmapSimilarity) {
            FastmapSimilarity.normalize(centroids);
            FastmapSimilarity.normalize(points);
        }
        HashSet<Integer> visitados = new HashSet<Integer>();
        HashSet<Integer> h_visitar = new HashSet<Integer>();
        HashSet<Integer> n_visitados = new HashSet<Integer>();
        h_visitar.add(0);
        for (int i = 1; i < neighbors.size(); ++i) {
            n_visitados.add(i);
        }
        while (n_visitados.size() > 0) {
            int n;
            if (h_visitar.size() > 0) {
                n = (Integer)h_visitar.iterator().next();
                visitados.add(n);
                h_visitar.remove(new Integer(n));
                n_visitados.remove(new Integer(n));
                for (int i = 0; i < neighbors.get(n).getNeighbors().size(); ++i) {
                    if (visitados.contains((int)neighbors.get((int)n).getNeighbors().get((int)i).id)) continue;
                    h_visitar.add((int)neighbors.get((int)n).getNeighbors().get((int)i).id);
                }
                continue;
            }
            n = (Integer)n_visitados.iterator().next();
            n_visitados.remove(new Integer(n));
            h_visitar.add(n);
            Iterator visitados_it = visitados.iterator();
            int nearNode = 0;
            float minDist = Float.MAX_VALUE;
            while (visitados_it.hasNext()) {
                int nearNode_aux = (Integer)visitados_it.next();
                float distance = metric.calculateDistance(points[nearNode_aux], points[n]);
                if (!(minDist > distance)) continue;
                minDist = distance;
                nearNode = nearNode_aux;
            }
            neighbors.get(n).addNeighbor(new Neighborhood.Neighbor(nearNode, minDist));
            neighbors.get(nearNode).addNeighbor(new Neighborhood.Neighbor(n, minDist));
        }
        return neighbors;
    }
}

