/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.io.IOException;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.projection.distance.Euclidean;

public class FastmapSimilarity
implements DistanceMeasure {
    public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
        if (pointA.length == pointB.length) {
            float similarity = Euclidean.calculateInnerProduct(pointA, pointB);
            return (float)Math.sqrt(Math.abs(2.0 * (1.0 - (double)similarity)));
        }
        throw new IOException("Diferente dimensions during the distance calculation!");
    }

    public static void normalize(float[][] points) {
        int col;
        int lin;
        float[] termSum = new float[points.length];
        for (int i = 0; i < termSum.length; ++i) {
            termSum[i] = 0.0f;
        }
        for (lin = 0; lin < points.length; ++lin) {
            for (col = 0; col < points[lin].length; ++col) {
                int n = lin;
                termSum[n] = termSum[n] + points[lin][col] * points[lin][col];
            }
            termSum[lin] = (float)Math.sqrt(termSum[lin]);
        }
        for (lin = 0; lin < points.length; ++lin) {
            for (col = 0; col < points[lin].length; ++col) {
                points[lin][col] = (double)termSum[lin] != 0.0 ? points[lin][col] / termSum[lin] : 0.0f;
            }
        }
    }
}

