/*
 * Decompiled with CFR 0.152.
 */
package visualizer.triangulation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import visualizer.graph.Edge;
import visualizer.graph.Vertex;
import visualizer.triangulation.Neighborhood;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangulation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Vector<Edge> edges = new Vector();

    public Triangulation(String name) {
        this.setName(name);
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(Vector<Edge> edges) {
        if (edges != null) {
            this.edges = edges;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Triangulation createTriangulation(Vector<Vertex> vertex, Vector<Neighborhood> neighborhood) {
        HashMap<Long, Vertex> index = new HashMap<Long, Vertex>();
        for (Vertex v : vertex) {
            index.put(v.getId(), v);
        }
        for (int i = 0; i < neighborhood.size(); ++i) {
            Neighborhood neigh = neighborhood.get(i);
            for (int j = 0; j < neigh.getNeighbors().size(); ++j) {
                Neighborhood.Neighbor n = neigh.getNeighbors().get(j);
                this.edges.add(new Edge((Vertex)index.get(i), (Vertex)index.get(n.id)));
            }
        }
        this.edges = Triangulation.compress(this.edges);
        this.setEdges(this.edges);
        return this;
    }

    public static Vector<Edge> compress(Vector<Edge> edges) {
        if (edges.size() > 0) {
            Collections.sort(edges);
            Vector<Edge> edges_aux = edges;
            edges = new Vector();
            int n = 0;
            edges.add(edges_aux.elementAt(0));
            for (int i = 1; i < edges_aux.size(); ++i) {
                if (edges_aux.elementAt(n).equals(edges_aux.elementAt(i))) continue;
                edges.add(edges_aux.elementAt(i));
                n = i;
            }
        }
        return edges;
    }
}

