/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchicalClustering {
    public static final int SLINK = 0;
    public static final int CLINK = 1;
    public static final int ALINK = 2;
    private float[][] points;
    private int typeOfClustering = 1;
    private Vector<Vector<Float>> dmat = new Vector();

    public HierarchicalClustering(float[][] points, int type) {
        this.typeOfClustering = type;
        this.points = points;
    }

    public abstract float calculateDistance(float[] var1, float[] var2) throws IOException;

    public Vector<Vector<Integer>> doClustering(int numberClusters) throws IOException {
        this.init();
        Vector<Vector<Integer>> clusters = new Vector<Vector<Integer>>();
        for (int i = 0; i < this.dmat.size(); ++i) {
            clusters.add(new Vector());
            clusters.elementAt(i).add(i);
        }
        while (clusters.size() > numberClusters) {
            int[] cmin = this.joinNearestClusters(clusters);
            this.updateDistanceMatrix(cmin);
        }
        return clusters;
    }

    public float[] getPointsHeight() throws IOException {
        this.init();
        Vector<Vector<Integer>> clusters = new Vector<Vector<Integer>>();
        float[] height = new float[this.dmat.size()];
        for (int i = 0; i < this.dmat.size(); ++i) {
            clusters.add(new Vector());
            clusters.elementAt(i).add(i);
            height[i] = 0.0f;
        }
        while (clusters.size() > 1) {
            int[] cmin = this.joinNearestClusters(clusters);
            for (int i = 0; i < clusters.elementAt(cmin[0]).size(); ++i) {
                int n = clusters.elementAt(cmin[0]).elementAt(i);
                height[n] = height[n] + 1.0f;
            }
            this.updateDistanceMatrix(cmin);
        }
        return height;
    }

    private void init() throws IOException {
        int i;
        for (i = 0; i < this.points.length; ++i) {
            Vector lin = new Vector();
            lin.setSize(this.points.length - 1);
            this.dmat.add(lin);
        }
        for (i = 0; i < this.points.length; ++i) {
            for (int j = 0; j < this.points.length; ++j) {
                if (i == j) {
                    this.dmat.elementAt(i).add(j, Float.valueOf(0.0f));
                    continue;
                }
                float distance = this.calculateDistance(this.points[i], this.points[j]);
                this.dmat.elementAt(i).set(j, Float.valueOf(distance));
                this.dmat.elementAt(j).set(i, Float.valueOf(distance));
            }
        }
    }

    private int[] joinNearestClusters(Vector<Vector<Integer>> clusters) {
        float minDistance = this.dmat.elementAt(0).elementAt(1).floatValue();
        int[] cmin = new int[]{0, 1};
        for (int c1 = 0; c1 < clusters.size(); ++c1) {
            for (int c2 = c1 + 1; c2 < clusters.size(); ++c2) {
                if (!(minDistance > this.dmat.elementAt(c1).elementAt(c2).floatValue())) continue;
                minDistance = this.dmat.elementAt(c1).elementAt(c2).floatValue();
                cmin[0] = c1;
                cmin[1] = c2;
            }
        }
        for (int i = 0; i < clusters.elementAt(cmin[1]).size(); ++i) {
            clusters.elementAt(cmin[0]).add(clusters.elementAt(cmin[1]).elementAt(i));
        }
        clusters.remove(cmin[1]);
        return cmin;
    }

    private void updateDistanceMatrix(int[] cmin) {
        switch (this.typeOfClustering) {
            case 0: {
                int i;
                for (i = 0; i < this.dmat.elementAt(0).size(); ++i) {
                    if (this.dmat.elementAt(cmin[0]).elementAt(i).floatValue() < this.dmat.elementAt(cmin[1]).elementAt(i).floatValue()) {
                        this.dmat.elementAt(cmin[0]).set(i, this.dmat.elementAt(cmin[0]).elementAt(i));
                    } else {
                        this.dmat.elementAt(cmin[0]).set(i, this.dmat.elementAt(cmin[1]).elementAt(i));
                    }
                    if (this.dmat.elementAt(i).elementAt(cmin[0]).floatValue() < this.dmat.elementAt(i).elementAt(cmin[1]).floatValue()) {
                        this.dmat.elementAt(i).set(cmin[0], this.dmat.elementAt(i).elementAt(cmin[0]));
                        continue;
                    }
                    this.dmat.elementAt(i).set(cmin[0], this.dmat.elementAt(i).elementAt(cmin[1]));
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < this.dmat.elementAt(0).size(); ++i) {
                    if (this.dmat.elementAt(cmin[0]).elementAt(i).floatValue() > this.dmat.elementAt(cmin[1]).elementAt(i).floatValue()) {
                        this.dmat.elementAt(cmin[0]).set(i, this.dmat.elementAt(cmin[0]).elementAt(i));
                    } else {
                        this.dmat.elementAt(cmin[0]).set(i, this.dmat.elementAt(cmin[1]).elementAt(i));
                    }
                    if (this.dmat.elementAt(i).elementAt(cmin[0]).floatValue() > this.dmat.elementAt(i).elementAt(cmin[1]).floatValue()) {
                        this.dmat.elementAt(i).set(cmin[0], this.dmat.elementAt(i).elementAt(cmin[0]));
                        continue;
                    }
                    this.dmat.elementAt(i).set(cmin[0], this.dmat.elementAt(i).elementAt(cmin[1]));
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < this.dmat.elementAt(0).size(); ++i) {
                    this.dmat.elementAt(cmin[0]).set(i, Float.valueOf((this.dmat.elementAt(cmin[0]).elementAt(i).floatValue() * 2.0f + this.dmat.elementAt(cmin[1]).elementAt(i).floatValue()) / 2.0f));
                    this.dmat.elementAt(i).set(cmin[0], Float.valueOf((this.dmat.elementAt(i).elementAt(cmin[0]).floatValue() * 2.0f + this.dmat.elementAt(i).elementAt(cmin[1]).floatValue()) / 2.0f));
                }
                break;
            }
        }
        this.dmat.remove(cmin[1]);
        for (int k = 0; k < this.dmat.size(); ++k) {
            this.dmat.elementAt(k).remove(cmin[1]);
        }
    }
}

