/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import visualizer.graph.Graph;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.projection.GraphBuilder;
import visualizer.projection.GraphBuilderListener;
import visualizer.view.ToolConfiguration;

public class GraphBuilderDialog
extends JDialog
implements GraphBuilderListener {
    public static final int GENERATED = 0;
    public static final int CANCELLED = 1;
    private GraphBuilder builder;
    private int result;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel messagePanel;
    private JLabel processingLabel;
    private JProgressBar processingProgressBar;

    public GraphBuilderDialog(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    public GraphBuilderDialog(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.messagePanel = new JPanel();
        this.processingProgressBar = new JProgressBar();
        this.processingLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Creating the Projection");
        this.setModal(true);
        this.setResizable(false);
        this.messagePanel.setLayout(new GridBagLayout());
        this.messagePanel.setBorder(BorderFactory.createTitledBorder("Wait a moment"));
        this.processingProgressBar.setIndeterminate(true);
        this.processingProgressBar.setPreferredSize(new Dimension(250, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.messagePanel.add((Component)this.processingProgressBar, gridBagConstraints);
        this.processingLabel.setText("Projecting...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.messagePanel.add((Component)this.processingLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphBuilderDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.builder != null) {
            this.builder.stop();
            this.result = 1;
            this.setVisible(false);
        }
    }

    public int show(Graph graph, StopwordListManager stpListManager) {
        this.setLocationRelativeTo(this.getParent());
        this.processingLabel.setText("Start projection...");
        this.builder = new GraphBuilder(graph, stpListManager);
        ToolConfiguration tool = ToolConfiguration.getInstance(null);
        this.builder.setFractionDelta(tool.getFracDelta());
        this.builder.setMatrixType(tool.getMatrixType());
        this.builder.setMax(tool.getMax());
        this.builder.setMin(tool.getMin());
        this.builder.setNrConnections(tool.getNrConnections());
        this.builder.setNrIterations(tool.getNrIterations());
        this.builder.setNrNeighbors(tool.getNrNeighbors());
        this.builder.setNumberGrams(tool.getNrGrams());
        this.builder.setStemming(tool.isStemming());
        this.builder.setReducting(tool.isReducing());
        this.builder.setTargetReduction(tool.getDimensions());
        this.builder.start(this);
        this.pack();
        this.setVisible(true);
        return this.result;
    }

    public void projectionFinished(Graph graph, StopwordListManager stpListManager) {
        this.setVisible(false);
        this.result = 0;
    }

    public void setProjectionStatus(String status, int value) {
        this.processingLabel.setText(status);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GraphBuilderDialog(new JDialog()).setVisible(true);
            }
        });
    }
}

