/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.preprocessing.stopwords.StopwordsListFile;
import visualizer.view.fileFilter.DATAFileFilter;

public class StopwordsManager
extends JDialog {
    private StopwordListManager stpListManager;
    private DefaultTableModel currentStopwodsTableModel;
    private DefaultTableModel newStopwodsTableModel;
    private JFileChooser file = new JFileChooser();
    private JButton addButton;
    private JPanel addStopwordsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel currentStopwordsPanel;
    private JButton mergeButton;
    private JPanel mergePanel;
    private JButton newButton;
    private JScrollPane newScrollPane;
    private JTable newTable;
    private JButton removeButton;
    private JButton resetButton;
    private JComboBox stopwordsListComboBox;
    private JPanel stopwordsListsPanel;
    private JPanel stopwordsPanel;
    private JScrollPane stopwordsScrollPane;
    private JTable stopwordsTable;

    public StopwordsManager(Frame parent, StopwordListManager stpListManager) {
        super(parent);
        this.stpListManager = stpListManager;
        this.initComponents();
        this.loadStopwordsList();
    }

    public StopwordsManager(Dialog parent, StopwordListManager stpListManager) {
        super(parent);
        this.stpListManager = stpListManager;
        this.initComponents();
        this.loadStopwordsList();
    }

    private void loadStopwordsList() {
        this.stopwordsListComboBox.removeAllItems();
        StopwordsList used = this.stpListManager.getStopwordListUsed();
        for (StopwordsList stp : this.stpListManager.getStopwordsLists()) {
            this.stopwordsListComboBox.addItem(stp);
        }
        this.stopwordsListComboBox.setSelectedItem(used);
    }

    private void initComponents() {
        this.stopwordsPanel = new JPanel();
        this.addStopwordsPanel = new JPanel();
        this.newButton = new JButton();
        this.newScrollPane = new JScrollPane();
        this.newTable = new JTable();
        this.currentStopwordsPanel = new JPanel();
        this.stopwordsScrollPane = new JScrollPane();
        this.stopwordsTable = new JTable();
        this.removeButton = new JButton();
        this.mergePanel = new JPanel();
        this.mergeButton = new JButton();
        this.stopwordsListsPanel = new JPanel();
        this.stopwordsListComboBox = new JComboBox();
        this.resetButton = new JButton();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Stopwords List Manager");
        this.setModal(true);
        this.stopwordsPanel.setLayout(new BorderLayout(5, 5));
        this.stopwordsPanel.setBorder(BorderFactory.createTitledBorder("Stopwords Manager"));
        this.addStopwordsPanel.setLayout(new BorderLayout());
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.newButtonActionPerformed(evt);
            }
        });
        this.addStopwordsPanel.add((Component)this.newButton, "South");
        this.newScrollPane.setBorder(BorderFactory.createTitledBorder("New Stopwords"));
        this.newScrollPane.setPreferredSize(new Dimension(200, 350));
        this.newScrollPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                StopwordsManager.this.newScrollPaneMouseClicked(evt);
            }
        });
        this.newScrollPane.setViewportView(this.newTable);
        this.addStopwordsPanel.add((Component)this.newScrollPane, "Center");
        this.stopwordsPanel.add((Component)this.addStopwordsPanel, "East");
        this.currentStopwordsPanel.setLayout(new BorderLayout());
        this.stopwordsScrollPane.setBorder(BorderFactory.createTitledBorder("Current Stopwords"));
        this.stopwordsScrollPane.setPreferredSize(new Dimension(200, 350));
        this.stopwordsScrollPane.setViewportView(this.stopwordsTable);
        this.currentStopwordsPanel.add((Component)this.stopwordsScrollPane, "Center");
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.removeButtonActionPerformed(evt);
            }
        });
        this.currentStopwordsPanel.add((Component)this.removeButton, "South");
        this.stopwordsPanel.add((Component)this.currentStopwordsPanel, "West");
        this.mergePanel.setLayout(new GridBagLayout());
        this.mergeButton.setText("<< Merge");
        this.mergeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.mergeButtonActionPerformed(evt);
            }
        });
        this.mergePanel.add((Component)this.mergeButton, new GridBagConstraints());
        this.stopwordsPanel.add((Component)this.mergePanel, "Center");
        this.stopwordsListsPanel.setLayout(new BorderLayout(5, 5));
        this.stopwordsListsPanel.setBorder(BorderFactory.createTitledBorder("Stopwords Lists Available"));
        this.stopwordsListComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.stopwordsListComboBoxActionPerformed(evt);
            }
        });
        this.stopwordsListsPanel.add((Component)this.stopwordsListComboBox, "Center");
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.resetButtonActionPerformed(evt);
            }
        });
        this.stopwordsListsPanel.add((Component)this.resetButton, "East");
        this.stopwordsPanel.add((Component)this.stopwordsListsPanel, "North");
        this.getContentPane().add((Component)this.stopwordsPanel, "Center");
        this.addButton.setText("Add Stopword List");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.addButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.addButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.file.resetChoosableFileFilters();
        this.file.setAcceptAllFileFilterUsed(false);
        this.file.setFileFilter(new DATAFileFilter());
        this.file.setMultiSelectionEnabled(false);
        int result = this.file.showOpenDialog(this);
        if (result == 0) {
            System.out.println(this.file.getSelectedFile().getName());
            System.out.println(this.file.getSelectedFile().getAbsolutePath());
            StopwordsListFile stpfile = new StopwordsListFile(this.file.getSelectedFile().getName(), this.file.getSelectedFile().getAbsolutePath());
            this.stpListManager.addStopwordList(stpfile);
            this.stpListManager.changeStopwordList(stpfile);
            this.loadStopwordsList();
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.stpListManager.reset();
        this.stopwordsListComboBox.removeAllItems();
        this.loadStopwordsList();
    }

    private void stopwordsListComboBoxActionPerformed(ActionEvent evt) {
        this.stpListManager.changeStopwordList((StopwordsList)this.stopwordsListComboBox.getSelectedItem());
        this.initModels();
        this.stopwordsTable.setModel(this.currentStopwodsTableModel);
        this.newTable.setModel(this.newStopwodsTableModel);
        for (String stopword : this.stpListManager.getStopwordListUsed().getStopwords()) {
            Object[] row = new String[]{stopword};
            this.currentStopwodsTableModel.addRow(row);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.stopwordsTable.getSelectedRow();
        if (index != -1) {
            String stopword = (String)this.currentStopwodsTableModel.getValueAt(index, 0);
            this.currentStopwodsTableModel.removeRow(index);
            this.stpListManager.getStopwordListUsed().removeStopword(stopword);
        }
    }

    private void newScrollPaneMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.newButtonActionPerformed(null);
        }
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        ArrayList<String> stopwords = new ArrayList<String>();
        this.newTable.editCellAt(0, 0);
        for (int i = 0; i < this.newStopwodsTableModel.getRowCount(); ++i) {
            String value = (String)this.newStopwodsTableModel.getValueAt(i, 0);
            if (value.trim().length() <= 0) continue;
            stopwords.add(value);
        }
        this.stpListManager.getStopwordListUsed().addStopwords(stopwords);
        this.stopwordsListComboBox.setSelectedItem(this.stpListManager.getStopwordListUsed());
        this.initModels();
        this.stopwordsTable.setModel(this.currentStopwodsTableModel);
        this.newTable.setModel(this.newStopwodsTableModel);
        for (String stopword : this.stpListManager.getStopwordListUsed().getStopwords()) {
            Object[] row = new String[]{stopword};
            this.currentStopwodsTableModel.addRow(row);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.newStopwodsTableModel.addRow(new String[]{""});
        this.newTable.editCellAt(this.newStopwodsTableModel.getRowCount() - 1, 0);
        this.newTable.requestFocusInWindow();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void show(Container parent) {
        this.initModels();
        this.stopwordsTable.setModel(this.currentStopwodsTableModel);
        this.newTable.setModel(this.newStopwodsTableModel);
        this.stopwordsListComboBox.setSelectedItem(this.stpListManager.getStopwordListUsed());
        for (String stopword : this.stpListManager.getStopwordListUsed().getStopwords()) {
            Object[] row = new String[]{stopword};
            this.currentStopwodsTableModel.addRow(row);
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public StopwordListManager getStopwordListManager() {
        return this.stpListManager;
    }

    private void initModels() {
        Object[] titulos = new String[]{"Stopwords"};
        this.currentStopwodsTableModel = new DefaultTableModel((Object[][])null, titulos);
        this.newStopwodsTableModel = new DefaultTableModel((Object[][])null, titulos);
    }
}

