/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.graph.Graph;
import visualizer.graph.GraphWriter;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.util.CreateVertexFromCorpus;
import visualizer.view.GraphBuilderDialog;
import visualizer.view.GraphPanel;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.SelectProjectionsJoin;
import visualizer.view.fileFilter.ZIPFilter;
import visualizer.web.WebElement;

public class ToolConfiguration
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private ProjectionExplorerWeb parent;
    private static ToolConfiguration instance;
    private JFileChooser file = new JFileChooser();
    private JPanel adjustsPanel;
    private JButton backGroundButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton closeButton;
    private ButtonGroup colorScalesbuttonGroup;
    private JLabel deltaLabel;
    private JTextField deltaTextField;
    private JLabel dimenReductionLabel;
    private JPanel dimenReductionPanel;
    private JTextField dimenReductionTextField;
    private JCheckBox dimensReductionCheckBox;
    private JButton exportCorpusButton;
    private JPanel generalParametersPanel;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;
    private JButton importCorpusButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton joinButton;
    private JPanel lspPanel;
    private ButtonGroup matrixTypeButtonGroup;
    private JPanel matrixTypePanel;
    private JLabel maxFrequencyLabel;
    private JTextField maxFrequencyTextField;
    private JLabel minFrequencyLabel;
    private JTextField minFrequencyTextField;
    private JLabel nConnectionsLabel;
    private JTextField nConnectionsTextField;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JLabel nNeighborsLabel;
    private JTextField nNeighborsTextField;
    private JPanel preProcessingPanel;
    private JCheckBox showEdgesCheckBox;
    private JCheckBox showVertexIdCheckBox;
    private JCheckBox showVertexLabel;
    private JCheckBox stemmingCheckBox;
    private JRadioButton tfRadioButton;
    private JRadioButton tfidfRadioButton;
    private JSlider vertexRaySlider;

    private ToolConfiguration(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
    }

    private void initComponents() {
        this.colorScalesbuttonGroup = new ButtonGroup();
        this.matrixTypeButtonGroup = new ButtonGroup();
        this.adjustsPanel = new JPanel();
        this.backGroundButton = new JButton();
        this.vertexRaySlider = new JSlider();
        this.showVertexIdCheckBox = new JCheckBox();
        this.showEdgesCheckBox = new JCheckBox();
        this.showVertexLabel = new JCheckBox();
        this.preProcessingPanel = new JPanel();
        this.maxFrequencyLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.gramsLabel = new JLabel();
        this.maxFrequencyTextField = new JTextField();
        this.minFrequencyLabel = new JLabel();
        this.minFrequencyTextField = new JTextField();
        this.stemmingCheckBox = new JCheckBox();
        this.matrixTypePanel = new JPanel();
        this.tfidfRadioButton = new JRadioButton();
        this.tfRadioButton = new JRadioButton();
        this.lspPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.deltaLabel = new JLabel();
        this.deltaTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.nConnectionsLabel = new JLabel();
        this.nConnectionsTextField = new JTextField();
        this.generalParametersPanel = new JPanel();
        this.nNeighborsLabel = new JLabel();
        this.nNeighborsTextField = new JTextField();
        this.dimenReductionPanel = new JPanel();
        this.dimensReductionCheckBox = new JCheckBox();
        this.dimenReductionTextField = new JTextField();
        this.dimenReductionLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.exportCorpusButton = new JButton();
        this.importCorpusButton = new JButton();
        this.jPanel2 = new JPanel();
        this.joinButton = new JButton();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Tools Properties");
        this.adjustsPanel.setLayout(new GridBagLayout());
        this.adjustsPanel.setBorder(BorderFactory.createTitledBorder("Adjustments "));
        this.backGroundButton.setText("BackGround Color");
        this.backGroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.backGroundButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.adjustsPanel.add((Component)this.backGroundButton, gridBagConstraints);
        this.vertexRaySlider.setMajorTickSpacing(10);
        this.vertexRaySlider.setMaximum(30);
        this.vertexRaySlider.setMinorTickSpacing(1);
        this.vertexRaySlider.setPaintLabels(true);
        this.vertexRaySlider.setPaintTicks(true);
        this.vertexRaySlider.setToolTipText("Vertex ray");
        this.vertexRaySlider.setValue(10);
        this.vertexRaySlider.setBorder(BorderFactory.createTitledBorder("Vertex Ray"));
        this.vertexRaySlider.setPreferredSize(new Dimension(200, 65));
        this.vertexRaySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ToolConfiguration.this.vertexRaySliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.adjustsPanel.add((Component)this.vertexRaySlider, gridBagConstraints);
        this.showVertexIdCheckBox.setText("Show vertex identification");
        this.showVertexIdCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showVertexIdCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.showVertexIdCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showVertexIdCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.adjustsPanel.add((Component)this.showVertexIdCheckBox, gridBagConstraints);
        this.showEdgesCheckBox.setText("Show edges");
        this.showEdgesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showEdgesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.showEdgesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showEdgesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.adjustsPanel.add((Component)this.showEdgesCheckBox, gridBagConstraints);
        this.showVertexLabel.setText("Show vertex label");
        this.showVertexLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showVertexLabel.setMargin(new Insets(0, 0, 0, 0));
        this.showVertexLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.showVertexLabelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 3, 5);
        this.adjustsPanel.add((Component)this.showVertexLabel, gridBagConstraints);
        this.preProcessingPanel.setLayout(new GridBagLayout());
        this.preProcessingPanel.setBorder(BorderFactory.createTitledBorder("Pre-processing"));
        this.maxFrequencyLabel.setText("Max frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.maxFrequencyLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsComboBox, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsLabel, gridBagConstraints);
        this.maxFrequencyTextField.setColumns(5);
        this.maxFrequencyTextField.setText("0.75");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.maxFrequencyTextField, gridBagConstraints);
        this.minFrequencyLabel.setText("Min frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.minFrequencyLabel, gridBagConstraints);
        this.minFrequencyTextField.setColumns(5);
        this.minFrequencyTextField.setText("0.01");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.minFrequencyTextField, gridBagConstraints);
        this.stemmingCheckBox.setSelected(true);
        this.stemmingCheckBox.setText("Apply Porter's stemming");
        this.stemmingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stemmingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.stemmingCheckBox, gridBagConstraints);
        this.matrixTypePanel.setLayout(new GridBagLayout());
        this.matrixTypePanel.setBorder(BorderFactory.createTitledBorder("Matrix Type"));
        this.matrixTypeButtonGroup.add(this.tfidfRadioButton);
        this.tfidfRadioButton.setSelected(true);
        this.tfidfRadioButton.setText("TF-IDF");
        this.tfidfRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfidfRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.matrixTypePanel.add((Component)this.tfidfRadioButton, gridBagConstraints);
        this.matrixTypeButtonGroup.add(this.tfRadioButton);
        this.tfRadioButton.setText("TF");
        this.tfRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.matrixTypePanel.add((Component)this.tfRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.preProcessingPanel.add((Component)this.matrixTypePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.adjustsPanel.add((Component)this.preProcessingPanel, gridBagConstraints);
        this.lspPanel.setLayout(new GridBagLayout());
        this.lspPanel.setBorder(BorderFactory.createTitledBorder("LSP parameters"));
        this.nIterationsLabel.setText("Number of iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.deltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.deltaLabel, gridBagConstraints);
        this.deltaTextField.setColumns(5);
        this.deltaTextField.setText("8.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.deltaTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        this.nIterationsTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        this.nConnectionsLabel.setText("Number Connections");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.nConnectionsLabel, gridBagConstraints);
        this.nConnectionsTextField.setColumns(5);
        this.nConnectionsTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.nConnectionsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.adjustsPanel.add((Component)this.lspPanel, gridBagConstraints);
        this.generalParametersPanel.setBorder(BorderFactory.createTitledBorder("General Parameters"));
        this.nNeighborsLabel.setText("Number Neighbors");
        this.generalParametersPanel.add(this.nNeighborsLabel);
        this.nNeighborsTextField.setColumns(5);
        this.nNeighborsTextField.setText("2");
        this.generalParametersPanel.add(this.nNeighborsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.adjustsPanel.add((Component)this.generalParametersPanel, gridBagConstraints);
        this.dimenReductionPanel.setLayout(new GridBagLayout());
        this.dimenReductionPanel.setBorder(BorderFactory.createTitledBorder("Dimensionality Reduction"));
        this.dimensReductionCheckBox.setText("reduce to");
        this.dimensReductionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dimensReductionCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.dimensReductionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.dimensReductionCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.dimensReductionCheckBox, gridBagConstraints);
        this.dimenReductionTextField.setColumns(3);
        this.dimenReductionTextField.setText("20");
        this.dimenReductionTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.dimenReductionTextField, gridBagConstraints);
        this.dimenReductionLabel.setText("dimensions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimenReductionPanel.add((Component)this.dimenReductionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.adjustsPanel.add((Component)this.dimenReductionPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Corpus"));
        this.exportCorpusButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Export16.gif")));
        this.exportCorpusButton.setText("Export Corpus");
        this.exportCorpusButton.setToolTipText("Export as PEx Corpus");
        this.exportCorpusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.exportCorpusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.exportCorpusButton, gridBagConstraints);
        this.importCorpusButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Import16.gif")));
        this.importCorpusButton.setText("ImportCorpus");
        this.importCorpusButton.setToolTipText("Import Corpus");
        this.importCorpusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.importCorpusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.importCorpusButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.adjustsPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Projection"));
        this.joinButton.setText("Join Projections");
        this.joinButton.setToolTipText("Join diferrent projections");
        this.joinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.joinButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.joinButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.adjustsPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.adjustsPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolConfiguration.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void joinButtonActionPerformed(ActionEvent evt) {
        this.graph = null;
        this.setVisible(false);
        Vector<String> names = new Vector<String>();
        Vector<GraphPanel> projections = this.parent.getProjections();
        for (int i = 0; i < projections.size(); ++i) {
            names.add(projections.get(i).getTitle());
        }
        if (names.size() > 0) {
            SelectProjectionsJoin join = new SelectProjectionsJoin(this.parent);
            Vector<String> graphPanelNames = join.show(names);
            Vector<GraphPanel> selGraphPanels = new Vector<GraphPanel>();
            for (int i = 0; i < projections.size(); ++i) {
                if (!graphPanelNames.contains(projections.get(i).getTitle())) continue;
                selGraphPanels.add(projections.get(i));
            }
            Vector<WebElement> webElements = new Vector<WebElement>();
            for (GraphPanel gp : selGraphPanels) {
                for (int j = 0; j < gp.getGraph().getVertex().size(); ++j) {
                    WebElement we = gp.getGraph().getVertex().get(j).getWebElement();
                    if (webElements.contains(we)) continue;
                    webElements.add(we);
                }
            }
            if (webElements.size() > 0) {
                HashMap<String, Vertex> vertex_map = new HashMap<String, Vertex>();
                Vector<Vertex> vertex = new Vector<Vertex>();
                for (int i = 0; i < webElements.size(); ++i) {
                    Vertex v = new Vertex((WebElement)webElements.get(i), i);
                    vertex.add(v);
                    vertex_map.put(v.getWebElement().getUrl(), v);
                }
                Graph graph = new Graph();
                graph.setVertex(vertex);
                StopwordListManager stpListManager = null;
                if (this.parent.getGraphPanel() != null) {
                    stpListManager = this.parent.getGraphPanel().getStopwordsManager().getStopwordListManager();
                } else {
                    stpListManager = new StopwordListManager();
                    stpListManager.changeStopwordList("English");
                }
                GraphBuilderDialog md = new GraphBuilderDialog(this);
                int result = md.show(graph, stpListManager);
                if (result == 0) {
                    int i;
                    int nrScalars = graph.getScalarNames().size();
                    for (i = 0; i < nrScalars; ++i) {
                        int index = graph.removeScalarName(graph.getScalarNames().firstElement());
                        for (Vertex v : graph.getVertex()) {
                            v.removeScalar(index);
                        }
                    }
                    for (i = 0; i < selGraphPanels.size(); ++i) {
                        Graph origGraph = ((GraphPanel)selGraphPanels.get(i)).getGraph();
                        for (String name : origGraph.getScalarNames()) {
                            int origIndex = origGraph.getScalarIndex(name);
                            int index = graph.addScalarName(name);
                            for (Vertex v : origGraph.getVertex()) {
                                float scalar = v.getScalar(origIndex);
                                Vertex newVertex = (Vertex)vertex_map.get(v.getWebElement().getUrl());
                                newVertex.setScalar(index, scalar);
                                if (name.equals("...")) {
                                    newVertex.setScalar(index, scalar);
                                    continue;
                                }
                                newVertex.setScalar(index, scalar + 0.5f);
                            }
                            for (Vertex v : graph.getVertex()) {
                                if (name.equals("...")) {
                                    v.setScalar(index, v.getScalar(index));
                                    continue;
                                }
                                v.setScalar(index, v.getScalar(index) + 1.5f * (float)i);
                            }
                        }
                    }
                    graph.normalizeScalars(0.0f, 1.0f);
                    String title = "Join ";
                    for (GraphPanel gp : selGraphPanels) {
                        title = title + "[" + gp.getId() + "]";
                    }
                    this.parent.addProjection(graph, title, stpListManager);
                }
            }
        }
    }

    private void importCorpusButtonActionPerformed(ActionEvent evt) {
        this.file.resetChoosableFileFilters();
        this.file.setAcceptAllFileFilterUsed(false);
        this.file.setFileFilter(new ZIPFilter());
        this.file.setMultiSelectionEnabled(false);
        int result = this.file.showOpenDialog(this.parent);
        if (result == 0) {
            String filename = this.file.getSelectedFile().getAbsolutePath();
            try {
                CreateVertexFromCorpus cvc = new CreateVertexFromCorpus();
                Vector<Vertex> vertex = cvc.create(filename);
                this.graph = null;
                this.setVisible(false);
                Graph graph = new Graph();
                graph.setVertex(vertex);
                StopwordListManager stpManager = new StopwordListManager();
                stpManager.changeStopwordList("English");
                GraphBuilderDialog md = new GraphBuilderDialog(this);
                result = md.show(graph, stpManager);
                if (result == 0) {
                    this.parent.addProjection(graph, this.file.getSelectedFile().getName(), stpManager);
                    this.parent.refreshPointsList();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCorpusButtonActionPerformed(ActionEvent evt) {
        if (this.parent.getGraphPanel() != null) {
            this.file.resetChoosableFileFilters();
            this.file.setAcceptAllFileFilterUsed(false);
            this.file.setFileFilter(new ZIPFilter());
            this.file.setMultiSelectionEnabled(false);
            int result = this.file.showSaveDialog(this.parent);
            if (result == 0) {
                String corpus = this.file.getSelectedFile().getAbsolutePath();
                if (!this.file.getSelectedFile().getName().toLowerCase().endsWith(".zip")) {
                    corpus = corpus.concat(".zip");
                }
                DeflaterOutputStream zout = null;
                try {
                    FileOutputStream dest = new FileOutputStream(corpus);
                    zout = new ZipOutputStream(new BufferedOutputStream(dest));
                    ((ZipOutputStream)zout).setMethod(8);
                    Vector<Integer> group = new Vector<Integer>();
                    int nrVertex = this.parent.getGraphPanel().getGraph().getVertex().size();
                    for (Vertex v : this.parent.getGraphPanel().getGraph().getVertex()) {
                        if (!group.contains((int)v.getWebElement().getScalar())) {
                            group.add((int)v.getWebElement().getScalar());
                        }
                        int groupId = group.indexOf((int)v.getWebElement().getScalar());
                        String filename = Integer.toString(groupId) + "_" + Integer.toString((int)v.getWebElement().getScalar()) + "_" + v.getId() + ".txt";
                        ZipEntry entry = new ZipEntry(filename);
                        ((ZipOutputStream)zout).putNextEntry(entry);
                        String filecontent = GraphWriter.unConvert(v.getWebElement().getTitle()) + "\n" + GraphWriter.unConvert(v.getWebElement().getSnippet());
                        ((ZipOutputStream)zout).write(filecontent.getBytes(), 0, filecontent.length());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (zout != null) {
                        try {
                            zout.flush();
                            ((ZipOutputStream)zout).finish();
                            ((ZipOutputStream)zout).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private void dimensReductionCheckBoxActionPerformed(ActionEvent evt) {
        this.dimenReductionTextField.setEnabled(this.dimensReductionCheckBox.isSelected());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.graph = null;
        this.setVisible(false);
    }

    private void showVertexLabelActionPerformed(ActionEvent evt) {
        if (this.parent.getGraphPanel() != null) {
            this.parent.getGraphPanel().setIsVertexLabelVisible(this.showVertexLabel.isSelected());
        }
    }

    private void showEdgesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.graph != null && this.parent.getGraphPanel() != null) {
            this.graph.setEdgeVisible(this.showEdgesCheckBox.isSelected());
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
    }

    private void showVertexIdCheckBoxActionPerformed(ActionEvent evt) {
        Vertex.setIsIdVisible(this.showVertexIdCheckBox.isSelected());
        if (this.parent.getGraphPanel() != null) {
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
            this.parent.validate();
            this.parent.repaint();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.graph = null;
        this.setVisible(false);
    }

    private void backGroundButtonActionPerformed(ActionEvent evt) {
        JColorChooser colorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Choose the Backgroud Color", Color.BLACK);
        if (this.parent.getGraphPanel() != null) {
            this.parent.getGraphPanel().getViewPanel().setBackground(color);
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
    }

    private void vertexRaySliderStateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        Vertex.setRayBase(slider.getValue());
        if (this.parent.getGraphPanel() != null) {
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
    }

    public static ToolConfiguration getInstance(JFrame parent) {
        if (instance == null) {
            instance = new ToolConfiguration(parent);
        }
        return instance;
    }

    public void show(ProjectionExplorerWeb parent, Graph graph) {
        if (parent != null) {
            this.graph = graph;
            this.parent = parent;
            this.setLocationRelativeTo(this.parent);
            this.showVertexIdCheckBox.setSelected(Vertex.isIsIdVisible());
            if (this.graph != null) {
                this.showEdgesCheckBox.setSelected(this.graph.isEdgeVisible());
            }
            if (this.graph != null) {
                this.showVertexLabel.setSelected(this.parent.getGraphPanel().isIsVertexLabelVisible());
            }
            this.vertexRaySlider.setValue(Vertex.getRayBase());
            this.setVisible(true);
        }
    }

    public float getMin() {
        return Float.parseFloat(this.minFrequencyTextField.getText());
    }

    public void setMin(float min) {
        this.minFrequencyTextField.setText(Float.toString(min));
    }

    public float getMax() {
        return Float.parseFloat(this.maxFrequencyTextField.getText());
    }

    public void setMax(float max) {
        this.maxFrequencyTextField.setText(Float.toString(max));
    }

    public int getNrGrams() {
        return this.gramsComboBox.getSelectedIndex() + 1;
    }

    public void setNrGrams(int nrgrams) {
        this.gramsComboBox.setSelectedIndex(nrgrams - 1);
    }

    public int getMatrixType() {
        if (this.tfRadioButton.isSelected()) {
            return 1;
        }
        return 0;
    }

    public void setMatrixType(int type) {
        if (type == 1) {
            this.tfRadioButton.setSelected(true);
            this.tfidfRadioButton.setSelected(false);
        } else {
            this.tfRadioButton.setSelected(false);
            this.tfidfRadioButton.setSelected(true);
        }
    }

    public boolean isStemming() {
        return this.stemmingCheckBox.isSelected();
    }

    public void setStemming(boolean stemming) {
        this.stemmingCheckBox.setSelected(stemming);
    }

    public float getFracDelta() {
        return Float.parseFloat(this.deltaTextField.getText());
    }

    public void setFracDelta(float fracdelta) {
        this.deltaTextField.setText(Float.toString(fracdelta));
    }

    public int getNrIterations() {
        return Integer.parseInt(this.nIterationsTextField.getText());
    }

    public void setNrIterations(int nriterations) {
        this.nIterationsTextField.setText(Integer.toString(nriterations));
    }

    public int getNrConnections() {
        return Integer.parseInt(this.nConnectionsTextField.getText());
    }

    public void setNrConnections(int nrconnections) {
        this.nConnectionsTextField.setText(Integer.toString(nrconnections));
    }

    public boolean isReducing() {
        return this.dimensReductionCheckBox.isSelected();
    }

    public void setReducing(boolean reducing) {
        this.dimensReductionCheckBox.setSelected(reducing);
        this.dimenReductionTextField.setEnabled(this.dimensReductionCheckBox.isSelected());
    }

    public int getDimensions() {
        return Integer.parseInt(this.dimenReductionTextField.getText());
    }

    public void setDimensions(int dimensions) {
        this.dimenReductionTextField.setText(Integer.toString(dimensions));
    }

    public int getNrNeighbors() {
        return Integer.parseInt(this.nNeighborsTextField.getText());
    }

    public void setNrNeighbors(int nrneighbors) {
        this.nNeighborsTextField.setText(Integer.toString(nrneighbors));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ToolConfiguration(null).setVisible(true);
            }
        });
    }
}

