/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.label;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.view.label.StringBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Label {
    protected Vector<StringBox> boxes = new Vector();
    protected Rectangle rectangle;
    private static boolean showLabel = true;

    public Label(Vector<Vertex> vertex) {
        this.calculateRectangle(vertex);
    }

    public void drawLabel(Graphics g, Font font, boolean selected) {
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        g.setColor(Color.DARK_GRAY);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.drawRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
        if (selected || showLabel) {
            if (selected) {
                if (selected) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    g2.setPaint(Color.BLUE);
                } else {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    g2.setPaint(Color.YELLOW);
                }
                g.fillRect(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            }
            if (this.boxes.size() > 0) {
                Point position = new Point();
                position.x = this.rectangle.x + this.rectangle.width / 2;
                position.y = this.rectangle.y;
                Rectangle rect = this.boxes.firstElement().draw(g, position, font, selected);
                for (int i = 1; i < this.boxes.size(); ++i) {
                    position = new Point();
                    position.x = this.rectangle.x + this.rectangle.width / 2;
                    position.y = rect.y + rect.height + 6;
                    rect = this.boxes.get(i).draw(g, position, font, selected);
                }
            }
        }
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public float weightDistance(Point point) {
        if (this.isInside(point)) {
            int cx = this.rectangle.x + this.rectangle.width / 2;
            int cy = this.rectangle.y + this.rectangle.height / 2;
            return (float)(Math.sqrt((cx - point.x) * (cx - point.x) + (cy - point.y) * (cy - point.y)) * (double)this.rectangle.width);
        }
        return -1.0f;
    }

    public boolean isInside(Point point) {
        return point.x > this.rectangle.x && point.x < this.rectangle.x + this.rectangle.width && point.y > this.rectangle.y && point.y < this.rectangle.y + this.rectangle.height;
    }

    public static boolean isShowLabel() {
        return showLabel;
    }

    public static void setShowLabel(boolean aShowLabel) {
        showLabel = aShowLabel;
    }

    protected void calculateRectangle(Vector<Vertex> vertex) {
        this.rectangle = new Rectangle();
        if (vertex.size() > 0) {
            int maxX = (int)vertex.get(0).getX();
            int minX = (int)vertex.get(0).getX();
            int maxY = (int)vertex.get(0).getY();
            int minY = (int)vertex.get(0).getY();
            for (int v = 1; v < vertex.size(); ++v) {
                int x = (int)vertex.get(v).getX();
                int y = (int)vertex.get(v).getY();
                if (x > maxX) {
                    maxX = x;
                } else if (x < minX) {
                    minX = x;
                }
                if (y > maxY) {
                    maxY = y;
                    continue;
                }
                if (y >= minY) continue;
                minY = y;
            }
            this.rectangle.x = minX - Vertex.getRayBase() - 2;
            this.rectangle.y = minY - Vertex.getRayBase() - 2;
            this.rectangle.width = maxX - minX + Vertex.getRayBase() * 2 + 4;
            this.rectangle.height = maxY - minY + Vertex.getRayBase() * 2 + 4;
        }
    }

    protected abstract void createLabel(Vector<Vertex> var1, StopwordsList var2);
}

