/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.websearch;

import com.yahoo.search.WebSearchResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import visualizer.web.WebElement;

public class WebResultElement
extends WebElement {
    private String content = "";

    public WebResultElement(WebSearchResult element, float scalar) {
        this.title = element.getTitle();
        this.url = element.getUrl();
        this.snippet = element.getSummary();
        this.scalar = scalar;
        long timestamp = Long.parseLong(element.getModificationDate()) * 1000L;
        Date d = new Date(timestamp);
        this.date = d.toString();
    }

    public String getContent() {
        String content = this.title + " " + this.snippet + " " + this.url + " " + this.content;
        return content.replaceAll("<.*?>", " ");
    }

    private String getContent(String page) {
        StringBuffer sb = new StringBuffer();
        try {
            URL url = new URL(page);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String inputLine = null;
            boolean startAppend = false;
            while ((inputLine = in.readLine()) != null) {
                if ((inputLine = inputLine.toLowerCase()).indexOf("<head>") == -1) continue;
                startAppend = true;
                break;
            }
            if (startAppend) {
                while ((inputLine = in.readLine()) != null && (inputLine = inputLine.toLowerCase()).indexOf("</html>") == -1) {
                    if (inputLine.length() <= 0) continue;
                    sb.append(inputLine + " ");
                }
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("Web services request failed");
        }
        return sb.toString().replaceAll("\\<.*?\\>", "").trim();
    }

    public String getScalarName() {
        return "rank";
    }
}

