/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.StreamTokenizer;

public class ExprFactory {
    static BooleanExpr createExpr(XPath xPath, StreamTokenizer streamTokenizer) throws XPathException, IOException {
        switch (streamTokenizer.ttype) {
            default: {
                throw new XPathException(xPath, "at beginning of expression", streamTokenizer, "@, number, or text()");
            }
            case -2: {
                int n = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                return new PositionEqualsExpr(n);
            }
            case 64: {
                if (streamTokenizer.nextToken() != -3) {
                    throw new XPathException(xPath, "after @", streamTokenizer, "name");
                }
                String string = streamTokenizer.sval;
                switch (streamTokenizer.nextToken()) {
                    case 61: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 34 && streamTokenizer.ttype != 39) {
                            throw new XPathException(xPath, "right hand side of equals", streamTokenizer, "quoted string");
                        }
                        String string2 = streamTokenizer.sval;
                        streamTokenizer.nextToken();
                        return new AttrEqualsExpr(string, string2);
                    }
                    case 60: {
                        double d;
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39) {
                            d = Double.parseDouble(streamTokenizer.sval);
                        } else if (streamTokenizer.ttype == -2) {
                            d = streamTokenizer.nval;
                        } else {
                            throw new XPathException(xPath, "right hand side of less-than", streamTokenizer, "quoted string or number");
                        }
                        streamTokenizer.nextToken();
                        return new AttrLessExpr(string, d);
                    }
                    case 62: {
                        double d;
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 34 || streamTokenizer.ttype == 39) {
                            d = Double.parseDouble(streamTokenizer.sval);
                        } else if (streamTokenizer.ttype == -2) {
                            d = streamTokenizer.nval;
                        } else {
                            throw new XPathException(xPath, "right hand side of greater-than", streamTokenizer, "quoted string or number");
                        }
                        streamTokenizer.nextToken();
                        return new AttrGreaterExpr(string, d);
                    }
                    case 33: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 61) {
                            throw new XPathException(xPath, "after !", streamTokenizer, "=");
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 34 && streamTokenizer.ttype != 39) {
                            throw new XPathException(xPath, "right hand side of !=", streamTokenizer, "quoted string");
                        }
                        String string3 = streamTokenizer.sval;
                        streamTokenizer.nextToken();
                        return new AttrNotEqualsExpr(string, string3);
                    }
                }
                return new AttrExistsExpr(string);
            }
            case -3: 
        }
        if (!streamTokenizer.sval.equals("text")) {
            throw new XPathException(xPath, "at beginning of expression", streamTokenizer, "text()");
        }
        if (streamTokenizer.nextToken() != 40) {
            throw new XPathException(xPath, "after text", streamTokenizer, "(");
        }
        if (streamTokenizer.nextToken() != 41) {
            throw new XPathException(xPath, "after text(", streamTokenizer, ")");
        }
        switch (streamTokenizer.nextToken()) {
            case 61: {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 34 && streamTokenizer.ttype != 39) {
                    throw new XPathException(xPath, "right hand side of equals", streamTokenizer, "quoted string");
                }
                String string = streamTokenizer.sval;
                streamTokenizer.nextToken();
                return new TextEqualsExpr(string);
            }
            case 33: {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 61) {
                    throw new XPathException(xPath, "after !", streamTokenizer, "=");
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 34 && streamTokenizer.ttype != 39) {
                    throw new XPathException(xPath, "right hand side of !=", streamTokenizer, "quoted string");
                }
                String string = streamTokenizer.sval;
                streamTokenizer.nextToken();
                return new TextNotEqualsExpr(string);
            }
        }
        return TextExistsExpr.INSTANCE;
    }
}

