/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.XPath;
import java.io.IOException;
import java.io.StreamTokenizer;

public class XPathException
extends Exception {
    private Throwable cause_ = null;

    public XPathException(XPath xPath, String string) {
        super(xPath + " " + string);
    }

    XPathException(XPath xPath, String string, StreamTokenizer streamTokenizer, String string2) {
        this(xPath, string + " got \"" + XPathException.toString(streamTokenizer) + "\" instead of expected " + string2);
    }

    XPathException(XPath xPath, Exception exception) {
        super(xPath + " " + exception);
        this.cause_ = exception;
    }

    public Throwable getCause() {
        return this.cause_;
    }

    private static String toString(StreamTokenizer streamTokenizer) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(XPathException.tokenToString(streamTokenizer));
            if (streamTokenizer.ttype != -1) {
                streamTokenizer.nextToken();
                stringBuffer.append(XPathException.tokenToString(streamTokenizer));
                streamTokenizer.pushBack();
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return "(cannot get  info: " + iOException + ")";
        }
    }

    private static String tokenToString(StreamTokenizer streamTokenizer) {
        switch (streamTokenizer.ttype) {
            case -1: {
                return "<end of expression>";
            }
            case 10: {
                throw new Error("Assertion failure, linebreaks cannot be special");
            }
            case -2: {
                return streamTokenizer.nval + "";
            }
            case -3: {
                return streamTokenizer.sval;
            }
        }
        return (char)streamTokenizer.ttype + "";
    }
}

