/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.rest;

import com.yahoo.rest.RestException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class RestClient {
    private static final int MAX_URI_LENGTH_FOR_GET = 255;
    private static final int ERROR_READ_BUFFER_SIZE = 1024;
    private static final String USER_AGENT_STRING;
    private static final String DEFAULT_USER_AGENT = "Yahoo-Java-SDK/unknown-version";

    private RestClient() {
    }

    public static InputStream call(String string, Map map) throws IOException, RestException {
        HttpURLConnection httpURLConnection;
        URL uRL;
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = RestClient.buildQueryString(map);
        if (stringBuffer.length() + string2.length() + 1 > 255) {
            uRL = new URL(stringBuffer.toString());
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", USER_AGENT_STRING);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.getOutputStream().write(string2.getBytes());
        } else {
            if (string2.length() > 0) {
                stringBuffer.append("?").append(string2);
            }
            uRL = new URL(stringBuffer.toString());
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", USER_AGENT_STRING);
            httpURLConnection.setRequestMethod("GET");
        }
        int n = httpURLConnection.getResponseCode();
        if (200 != n) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            InputStream inputStream = httpURLConnection.getErrorStream();
            while (-1 != (n2 = inputStream.read(byArray))) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            throw new RestException("Request failed, HTTP " + n + ": " + httpURLConnection.getResponseMessage(), byteArrayOutputStream.toByteArray());
        }
        return httpURLConnection.getInputStream();
    }

    private static String buildQueryString(Map map) {
        Set set = map.keySet();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof String) {
                stringBuffer.append(URLEncoder.encode(string));
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode((String)map.get(string)));
            } else if (v instanceof List) {
                Iterator iterator2 = ((List)v).iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    stringBuffer.append(URLEncoder.encode(string));
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(string2));
                    if (!iterator2.hasNext()) continue;
                    stringBuffer.append('&');
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append('&');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = DEFAULT_USER_AGENT;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.yahoo.rest.RestClient");
            if (resourceBundle != null) {
                string = resourceBundle.getString("useragent");
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        finally {
            USER_AGENT_STRING = string;
        }
    }
}

