/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.xmlparser;

import com.yahoo.search.CacheInfo;
import com.yahoo.search.WebSearchResult;
import com.yahoo.search.WebSearchResults;
import com.yahoo.search.xmlparser.XmlParserCacheInfo;
import com.yahoo.xml.XmlParser;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class XmlParserWebSearchResults
implements WebSearchResults {
    private Map root;
    private WebSearchResult[] results;

    public XmlParserWebSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/ResultSet/Result");
        if (list != null) {
            this.results = new WebSearchResult[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserWebSearchResult(map2);
            }
        } else {
            this.results = new WebSearchResult[0];
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public WebSearchResult[] listResults() {
        return this.results;
    }

    private class XmlParserWebSearchResult
    implements WebSearchResult {
        private Map result;
        private CacheInfo cache;

        public XmlParserWebSearchResult(Map map) {
            this.result = map;
            Map map2 = (Map)map.get("Cache");
            if (map2 != null) {
                this.cache = new XmlParserCacheInfo(map2);
            }
        }

        public String getTitle() {
            return XmlParser.getString(this.result, "/Title/value");
        }

        public String getSummary() {
            return XmlParser.getString(this.result, "/Summary/value");
        }

        public String getUrl() {
            return XmlParser.getString(this.result, "/Url/value");
        }

        public String getClickUrl() {
            return XmlParser.getString(this.result, "/ClickUrl/value");
        }

        public String getMimeType() {
            return XmlParser.getString(this.result, "/MimeType/value");
        }

        public String getModificationDate() {
            return XmlParser.getString(this.result, "/ModificationDate/value");
        }

        public CacheInfo getCache() {
            return this.cache;
        }
    }
}

