/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.shopping;

import com.yahoo.java.ExtendedError;
import com.yahoo.rest.RestClient;
import com.yahoo.rest.RestException;
import com.yahoo.shopping.CatalogListingRequest;
import com.yahoo.shopping.CatalogListingResults;
import com.yahoo.shopping.MerchantSearchRequest;
import com.yahoo.shopping.MerchantSearchResults;
import com.yahoo.shopping.ProductSearchRequest;
import com.yahoo.shopping.ProductSearchResults;
import com.yahoo.shopping.ShoppingException;
import com.yahoo.shopping.xmlparser.XmlParserCatalogListingResults;
import com.yahoo.shopping.xmlparser.XmlParserMerchantSearchResults;
import com.yahoo.shopping.xmlparser.XmlParserProductSearchResults;
import com.yahoo.xml.XmlParser;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ShoppingClient {
    private static final String APPID_KEY = "appid";
    private String appId;

    public ShoppingClient(String string) {
        this.appId = string;
    }

    public ProductSearchResults productSearch(ProductSearchRequest productSearchRequest) throws IOException, ShoppingException {
        productSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(productSearchRequest.getRequestUrl(), productSearchRequest.getParameters());
        return new XmlParserProductSearchResults(map);
    }

    public CatalogListingResults catalogListing(CatalogListingRequest catalogListingRequest) throws IOException, ShoppingException {
        catalogListingRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(catalogListingRequest.getRequestUrl(), catalogListingRequest.getParameters());
        return new XmlParserCatalogListingResults(map);
    }

    public MerchantSearchResults merchantSearch(MerchantSearchRequest merchantSearchRequest) throws IOException, ShoppingException {
        merchantSearchRequest.getParameters().put(APPID_KEY, this.appId);
        Map map = this.executeAndParse(merchantSearchRequest.getRequestUrl(), merchantSearchRequest.getParameters());
        return new XmlParserMerchantSearchResults(map);
    }

    private Map executeAndParse(String string, Map map) throws IOException, ShoppingException {
        XmlParser xmlParser = null;
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            xmlParser = new XmlParser();
            sAXParser.parse(RestClient.call(string, map), (DefaultHandler)xmlParser);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExtendedError("XML parser not properly configured", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ShoppingException("Error parsing XML response", sAXException);
        }
        catch (RestException restException) {
            throw new ShoppingException("Error calling service\n" + new String(restException.getErrorMessage(), "UTF-8"), restException);
        }
        return xmlParser.getRoot();
    }
}

