/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.IOException;
import visualizer.graph.Graph;
import visualizer.graph.XMLGraphSaxDoc;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.view.ToolConfiguration;

public class XMLGraphSaxReader {
    protected static final String DESCRIPTION = "description";
    protected static final String VERTEX = "vertex";
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected static final String X_COORDINATE = "x-coordinate";
    protected static final String Y_COORDINATE = "y-coordinate";
    protected static final String URL = "url";
    protected static final String TITLE = "title";
    protected static final String SNIPPET = "snippet";
    protected static final String CLASS = "scalar-class";
    protected static final String DATE = "date";
    protected static final String VALUE = "value";
    protected static final String SCALARS = "scalars";
    protected static final String SCALAR = "scalar";
    protected static final String EDGES = "edges";
    protected static final String EDGE = "edge";
    protected static final String SOURCE = "source";
    protected static final String TARGET = "target";
    protected static final String NUMBER_ITERATIONS = "number-iterations";
    protected static final String FRACTION_DELTA = "fraction-delta";
    protected static final String PROJECTION_TYPE = "projection-type";
    protected static final String MAX_CUT = "max-cut";
    protected static final String MIN_CUT = "min-cut";
    protected static final String NUMBER_GRAMS = "number-grams";
    protected static final String NUMBER_CONN = "number-connections";
    protected static final String NUMBER_NEIGH = "number-neighbors";
    protected static final String REDUCING = "reducing";
    protected static final String DIMENSIONS = "dimensions";
    protected static final String STP_LIST = "stp-list";
    private StopwordListManager stpManager = new StopwordListManager();
    private String description = "";

    public Graph readGraphFromFile(String filename) throws IOException {
        String stplist;
        String dimensions;
        String reducing;
        String numb_neigh;
        String numb_conn;
        String numb_grams;
        String max_cut;
        String min_cut;
        String frac_delta;
        Graph graph = new Graph();
        XMLGraphSaxDoc doc = new XMLGraphSaxDoc();
        doc.run(filename, graph);
        String description = doc.getAttribute(DESCRIPTION);
        if (description != null && description.trim().length() > 0) {
            this.description = description;
        }
        ToolConfiguration tool = ToolConfiguration.getInstance(null);
        String numb_it = doc.getAttribute(NUMBER_ITERATIONS);
        if (numb_it != null) {
            tool.setNrIterations(Integer.parseInt(numb_it));
        }
        if ((frac_delta = doc.getAttribute(FRACTION_DELTA)) != null) {
            tool.setFracDelta(Float.parseFloat(frac_delta));
        }
        if ((min_cut = doc.getAttribute(MIN_CUT)) != null) {
            tool.setMin(Float.parseFloat(min_cut));
        }
        if ((max_cut = doc.getAttribute(MAX_CUT)) != null) {
            tool.setMax(Float.parseFloat(max_cut));
        }
        if ((numb_grams = doc.getAttribute(NUMBER_GRAMS)) != null) {
            tool.setNrGrams(Integer.parseInt(numb_grams));
        }
        if ((numb_conn = doc.getAttribute(NUMBER_CONN)) != null) {
            tool.setNrConnections(Integer.parseInt(numb_conn));
        }
        if ((numb_neigh = doc.getAttribute(NUMBER_NEIGH)) != null) {
            tool.setNrNeighbors(Integer.parseInt(numb_neigh));
        }
        if ((reducing = doc.getAttribute(REDUCING)) != null) {
            tool.setReducing(Boolean.parseBoolean(reducing));
        }
        if ((dimensions = doc.getAttribute(DIMENSIONS)) != null) {
            tool.setDimensions(Integer.parseInt(dimensions));
        }
        if ((stplist = doc.getAttribute(STP_LIST)) != null) {
            this.stpManager.changeStopwordList(stplist);
        } else {
            this.stpManager.changeStopwordList("English");
        }
        graph.setVertex(doc.getVertex());
        graph.normalizeScalars(0.0f, 1.0f);
        return graph;
    }

    public String getDescription() {
        return this.description;
    }

    public StopwordListManager getStopwordListManager() {
        return this.stpManager;
    }
}

