/*
 * Decompiled with CFR 0.152.
 */
package visualizer.preprocessing.stopwords;

import java.util.List;
import java.util.Vector;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.preprocessing.stopwords.StopwordsListEnglish;
import visualizer.preprocessing.stopwords.StopwordsListNews;
import visualizer.preprocessing.stopwords.StopwordsListPortuguese;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopwordListManager {
    public static final String STP_ENGLISH = "English";
    public static final String STP_RSS_ENGLISH = "English RSS-News";
    public static final String STP_PORTUGUESE = "Portuguese";
    private static StopwordListManager instance;
    private StopwordsList used;
    private Vector<StopwordsList> stopwordsLists;

    public StopwordListManager() {
        this.reset();
    }

    public void reset() {
        this.stopwordsLists = new Vector();
        this.used = new StopwordsListEnglish(STP_ENGLISH);
        this.stopwordsLists.add(this.used);
        this.stopwordsLists.add(new StopwordsListNews(STP_RSS_ENGLISH));
        this.stopwordsLists.add(new StopwordsListPortuguese(STP_PORTUGUESE));
    }

    public void changeStopwordList(StopwordsList used) {
        if (used != null) {
            this.used = used;
        }
    }

    public void changeStopwordList(String used) {
        for (int i = 0; i < this.stopwordsLists.size(); ++i) {
            if (!this.stopwordsLists.get(i).getStopwordListName().equals(used)) continue;
            this.used = this.stopwordsLists.get(i);
        }
    }

    public List<StopwordsList> getStopwordsLists() {
        return this.stopwordsLists;
    }

    public StopwordsList getStopwordListUsed() {
        return this.used;
    }

    public void addStopwordList(StopwordsList stplist) {
        this.stopwordsLists.add(stplist);
    }
}

