/*
 * Decompiled with CFR 0.152.
 */
package visualizer.preprocessing.stopwords;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import visualizer.preprocessing.stopwords.StopwordsList;

public class StopwordsListFile
extends StopwordsList {
    private String filename;

    public StopwordsListFile(String stopwordListname, String filename) {
        this.filename = filename;
        this.stopwordListname = stopwordListname;
        this.stopwords = new ArrayList();
        this.fillList();
        ArrayList<String> stopwords_aux = new ArrayList<String>();
        for (String stp : this.stopwords) {
            if (stopwords_aux.contains(stp.toLowerCase())) continue;
            stopwords_aux.add(stp.toLowerCase());
        }
        Collections.sort(stopwords_aux);
        this.stopwords = stopwords_aux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillList() {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                this.stopwords.add(line.toLowerCase());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

