/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.preprocessing.Preprocessor;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.projection.FastmapProjection;
import visualizer.projection.ForceScheme;
import visualizer.projection.GraphBuilderListener;
import visualizer.projection.LSPProjection;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.Euclidean;
import visualizer.projection.distance.FastmapSimilarity;
import visualizer.triangulation.Delaunay;
import visualizer.triangulation.Neighborhood;
import visualizer.triangulation.Triangulation;
import visualizer.util.ApproxKNN;
import visualizer.util.PCA;

public class GraphBuilder {
    private Thread t;
    private Graph graph;
    private StopwordListManager stpListManager;
    private float min = 0.01f;
    private float max = 0.75f;
    private int numberGrams = 1;
    private int matrixType = 0;
    private boolean stemming = true;
    private float fractionDelta = 8.0f;
    private int nrIterations = 100;
    private int nrConnections = 10;
    private int nrControlPoints = 10;
    private boolean reducting = false;
    private int targetReduction = 20;
    private int nrNeighbors = 2;

    public GraphBuilder(Graph graph, StopwordListManager stpListManager) {
        this.graph = graph;
        this.stpListManager = stpListManager;
    }

    public void start(final GraphBuilderListener listener) {
        this.t = new Thread(){

            public void run() {
                GraphBuilder.this.execute(listener);
                listener.projectionFinished(GraphBuilder.this.graph, GraphBuilder.this.stpListManager);
            }
        };
        this.t.start();
    }

    private void execute(GraphBuilderListener listener) {
        try {
            int i;
            if (listener != null) {
                listener.setProjectionStatus("Preprocessing...", 5);
            }
            Preprocessor prepoc = new Preprocessor();
            StopwordsList stp = this.stpListManager.getStopwordListUsed();
            float[][] points = prepoc.getMatrix(this.max, this.min, this.numberGrams, this.matrixType, this.stemming, this.graph.getVertex(), stp);
            points = this.perturbNullVectors(points);
            System.out.println("number documents: " + points.length);
            System.out.println("final dimensionality: " + points[0].length);
            if (this.reducting && points[0].length > this.targetReduction) {
                if (listener != null) {
                    listener.setProjectionStatus("Reducing the dimensions to " + this.targetReduction + "...", 10);
                }
                PCA pca = new PCA(this.targetReduction);
                points = pca.project(points, listener);
            }
            FastmapSimilarity.normalize(points);
            this.nrControlPoints = points.length / 10 < 5 ? 5 : points.length / 10;
            Object projection = null;
            boolean nan = true;
            block2: for (int k = 0; k < 10 && nan; ++k) {
                if (points.length < 5) {
                    FastmapProjection fastmap;
                    DistanceMatrix dmat = DistanceMatrixFactory.getInstance(points, FastmapSimilarity.class);
                    if (listener != null) {
                        listener.setProjectionStatus("Projecting...", 40);
                    }
                    if ((projection = (fastmap = new FastmapProjection()).project(dmat)) != null) {
                        ForceScheme force = new ForceScheme(this.fractionDelta, ((float[][])projection).length);
                        for (int i2 = 0; i2 < this.nrIterations; ++i2) {
                            if (listener != null) {
                                listener.setProjectionStatus("Improving the projection...", (int)(45.0f + (float)i2 * 50.0f / (float)this.nrIterations));
                            }
                            force.iteration(dmat, (float[][])projection);
                        }
                    }
                } else {
                    LSPProjection lsp = new LSPProjection(listener);
                    lsp.setFracDelta(this.fractionDelta);
                    lsp.setNrIterations(this.nrIterations);
                    lsp.setNrConnections(this.nrConnections);
                    lsp.setNrControlPoints(this.nrControlPoints);
                    projection = lsp.project(points);
                }
                nan = false;
                for (int i3 = 0; i3 < ((float[][])projection).length; ++i3) {
                    if (!Float.isNaN(projection[i3][0]) && !Float.isNaN(projection[i3][1])) continue;
                    nan = true;
                    continue block2;
                }
            }
            int dotIndex = this.graph.addScalarName("...");
            int scalarIndex = this.graph.addScalarName(this.graph.getVertex().firstElement().getWebElement().getScalarName());
            ArrayList<Integer> group = new ArrayList<Integer>();
            for (i = 0; i < this.graph.getVertex().size(); ++i) {
                Vertex v = this.graph.getVertex().get(i);
                v.setX(projection[i][0]);
                v.setY(projection[i][1]);
                v.setScalar(dotIndex, 0.0f);
                if (group.contains((int)v.getWebElement().getScalar())) continue;
                group.add((int)v.getWebElement().getScalar());
            }
            Collections.sort(group);
            for (i = 0; i < this.graph.getVertex().size(); ++i) {
                Vertex v = this.graph.getVertex().get(i);
                float groupId = group.size() - (group.indexOf((int)v.getWebElement().getScalar()) + 1);
                v.setScalar(scalarIndex, groupId);
            }
            this.graph.normalizeScalars(0.0f, 1.0f);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension d = tk.getScreenSize();
            float size = Math.min(d.height, d.width);
            this.graph.normalizeVertex(Vertex.getRayBase() * 5 + 10, (float)d.getHeight() / 1.45f);
            this.graph.perturb();
            projection = new float[this.graph.getVertex().size()][];
            for (int i4 = 0; i4 < ((float[][])projection).length; ++i4) {
                projection[i4] = new float[2];
                projection[i4][0] = this.graph.getVertex().get(i4).getX();
                projection[i4][1] = this.graph.getVertex().get(i4).getY();
            }
            if (listener != null) {
                listener.setProjectionStatus("Creating the KNN-R2 triangulation...", 90);
            }
            String triangname = "KNN-R2-" + this.nrNeighbors;
            Triangulation knnr2Triang = new Triangulation(triangname);
            ApproxKNN appknn = new ApproxKNN(this.nrNeighbors, 10);
            Vector<Neighborhood> neighborhood = appknn.execute((float[][])projection, new Euclidean());
            knnr2Triang.createTriangulation(this.graph.getVertex(), neighborhood);
            this.graph.addTriangulation(knnr2Triang);
            if (listener != null) {
                listener.setProjectionStatus("Creating the KNN-RN triangulation...", 92);
            }
            triangname = "KNN-RN-" + this.nrNeighbors;
            Triangulation knnrnTriang = new Triangulation(triangname);
            appknn = new ApproxKNN(this.nrNeighbors, 10);
            neighborhood = appknn.execute(points, new FastmapSimilarity());
            knnrnTriang.createTriangulation(this.graph.getVertex(), neighborhood);
            this.graph.addTriangulation(knnrnTriang);
            if (listener != null) {
                listener.setProjectionStatus("Creating the Delaunay triangulation...", 95);
            }
            Triangulation delauTriang = new Triangulation("Delaunay");
            Delaunay delaunay = new Delaunay();
            neighborhood = delaunay.execute((float[][])projection);
            delauTriang.createTriangulation(this.graph.getVertex(), neighborhood);
            this.graph.addTriangulation(delauTriang);
            if (listener != null) {
                listener.setProjectionStatus("Done!", 100);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Runtime.getRuntime().gc();
    }

    public void stop() {
        if (this.t.isAlive()) {
            this.t.interrupt();
            System.gc();
        }
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void setNumberGrams(int numberGrams) {
        this.numberGrams = numberGrams;
    }

    public void setMatrixType(int matrixType) {
        this.matrixType = matrixType;
    }

    public void setStemming(boolean stemming) {
        this.stemming = stemming;
    }

    public void setFractionDelta(float fractionDelta) {
        this.fractionDelta = fractionDelta;
    }

    public void setNrIterations(int nrIterations) {
        this.nrIterations = nrIterations;
    }

    public void setNrConnections(int nrConnections) {
        this.nrConnections = nrConnections;
    }

    public void setNrControlPoints(int nrControlPoints) {
        this.nrControlPoints = nrControlPoints;
    }

    public void setNrNeighbors(int nrNeighbors) {
        this.nrNeighbors = nrNeighbors;
    }

    public void setReducting(boolean reducting) {
        this.reducting = reducting;
    }

    public void setTargetReduction(int targetReduction) {
        this.targetReduction = targetReduction;
    }

    private float[][] perturbNullVectors(float[][] points) {
        boolean existNullVectors = false;
        for (int i = 0; i < points.length; ++i) {
            boolean nullVector = true;
            for (int j = 0; j < points[i].length; ++j) {
                if ((double)points[i][j] == 0.0) continue;
                nullVector = false;
                break;
            }
            if (!nullVector) continue;
            existNullVectors = true;
            break;
        }
        if (existNullVectors) {
            int oldDimen = points[0].length;
            for (int i = 0; i < points.length; ++i) {
                int j;
                boolean nullVector = true;
                float[] oldPoint = points[i];
                for (j = 0; j < oldPoint.length; ++j) {
                    if ((double)oldPoint[j] == 0.0) continue;
                    nullVector = false;
                    break;
                }
                points[i] = new float[oldDimen + 1];
                points[i][0] = nullVector ? 1.0f : 0.0f;
                for (j = 0; j < oldPoint.length; ++j) {
                    points[i][j + 1] = oldPoint[j];
                }
            }
        }
        return points;
    }
}

