/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public abstract class DistanceMatrix
implements Cloneable {
    private float[][] matrix;
    private int numberPoints;
    float maxDistance;
    float minDistance;

    public DistanceMatrix(int numberPoints) {
        this.maxDistance = Float.MIN_VALUE;
        this.minDistance = Float.MAX_VALUE;
        this.numberPoints = numberPoints;
        this.matrix = new float[numberPoints - 1][];
        int numberTerms = numberPoints - 1;
        for (int ins1 = 0; ins1 < numberPoints - 1; ++ins1) {
            this.matrix[ins1] = new float[numberTerms--];
        }
    }

    public DistanceMatrix(float[][] points) throws IOException {
        this.numberPoints = points.length;
        this.maxDistance = Float.MIN_VALUE;
        this.minDistance = Float.MAX_VALUE;
        float distance = 0.0f;
        this.matrix = new float[points.length - 1][];
        int numberTerms = this.numberPoints - 1;
        for (int ins1 = 0; ins1 < this.numberPoints - 1; ++ins1) {
            this.matrix[ins1] = new float[numberTerms--];
            for (int ins2 = ins1 + 1; ins2 < this.numberPoints; ++ins2) {
                distance = this.calculateDistance(points[ins1], points[ins2]);
                if (distance > this.maxDistance) {
                    this.maxDistance = distance;
                } else if (distance < this.minDistance) {
                    this.minDistance = distance;
                }
                this.matrix[ins1][Math.abs((int)(ins2 - (this.numberPoints - 1)))] = distance;
            }
        }
    }

    public abstract float calculateDistance(float[] var1, float[] var2) throws IOException;

    public void setDistance(int pointA, int pointB, float value) {
        if (pointA != pointB) {
            if (pointA < pointB) {
                this.matrix[pointA][Math.abs((int)(pointB - (this.numberPoints - 1)))] = value;
            } else {
                this.matrix[pointB][Math.abs((int)(pointA - (this.numberPoints - 1)))] = value;
            }
            if (this.minDistance > value) {
                this.minDistance = value;
            } else if (this.maxDistance < value) {
                this.maxDistance = value;
            }
        }
    }

    public float getDistance(int pointA, int pointB) {
        if (pointA == pointB) {
            return 0.0f;
        }
        return pointA < pointB ? this.matrix[pointA][Math.abs(pointB - (this.numberPoints - 1))] : this.matrix[pointB][Math.abs(pointA - (this.numberPoints - 1))];
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public int getNumberPoints() {
        return this.numberPoints;
    }

    public Object clone() throws CloneNotSupportedException {
        DistanceMatrix dmat = new DistanceMatrix(this.numberPoints){

            public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
                return 0.0f;
            }
        };
        dmat.maxDistance = this.maxDistance;
        dmat.minDistance = this.minDistance;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[i].length; ++j) {
                dmat.matrix[i][j] = this.matrix[i][j];
            }
        }
        return dmat;
    }

    public void saveToFile(float[] cdata, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (int i = 0; i < this.numberPoints; ++i) {
                if (cdata != null) {
                    out.write(Float.toString(cdata[i]));
                    out.write(" ");
                    continue;
                }
                out.write("1 ");
            }
            out.write("\n");
            float[][] arr$ = this.matrix;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float[] lin;
                for (float col : lin = arr$[i$]) {
                    out.write(Float.toString(col));
                    out.write(" ");
                }
                out.write("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void print() {
        float[][] arr$ = this.matrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float[] lin;
            for (float col : lin = arr$[i$]) {
                System.out.print(col + " ");
            }
            System.out.println();
        }
    }
}

