/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.projection.distance.FastmapSimilarity;
import visualizer.triangulation.Neighborhood;
import visualizer.util.BKmeans;
import visualizer.util.KNN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproxKNN {
    private int nrNeighbors = 5;
    private int nrNeighborsCentroides = 10;

    public ApproxKNN(int nrNeighbors, int nrNeighborsCentroides) {
        this.nrNeighbors = nrNeighbors;
        this.nrNeighborsCentroides = nrNeighborsCentroides;
    }

    public Vector<Neighborhood> execute(float[][] points, DistanceMeasure metric) throws IOException {
        BKmeans bkmeans = new BKmeans((int)Math.pow(points.length, 0.5));
        Vector<Vector<Integer>> clusters = bkmeans.execute(metric, points);
        return this.execute(points, metric, clusters);
    }

    public Vector<Neighborhood> execute(float[][] points, DistanceMeasure metric, Vector<Vector<Integer>> clusters) throws IOException {
        int j;
        float[][] centroides = this.calculateCentroids(points, clusters);
        if (metric instanceof FastmapSimilarity) {
            FastmapSimilarity.normalize(centroides);
        }
        DistanceMatrix dmat_centroids = DistanceMatrixFactory.getInstance(centroides, metric.getClass());
        KNN centroidsKnn = new KNN(this.nrNeighborsCentroides);
        Vector<Neighborhood> knn_centroids = centroidsKnn.execute(dmat_centroids);
        Vector idsList = new Vector();
        Vector distanceList = new Vector();
        for (int i = 0; i < points.length; ++i) {
            Vector<Integer> ids = new Vector<Integer>();
            Vector<Float> distances = new Vector<Float>();
            for (j = 0; j < this.nrNeighbors; ++j) {
                ids.add(0);
                distances.add(Float.valueOf(Float.MAX_VALUE));
            }
            idsList.add(ids);
            distanceList.add(distances);
        }
        for (int c = 0; c < clusters.size(); ++c) {
            for (int i = 0; i < clusters.get(c).size(); ++i) {
                int index1 = clusters.get(c).get(i);
                for (j = 0; j < clusters.get(c).size(); ++j) {
                    if (i == j) continue;
                    int index2 = clusters.get(c).get(j);
                    float distance = metric.calculateDistance(points[index1], points[index2]);
                    this.addDistance((Vector)distanceList.get(index1), (Vector)idsList.get(index1), index2, distance);
                }
            }
            for (int n = 0; n < knn_centroids.get(c).getNeighbors().size(); ++n) {
                int nc = (int)knn_centroids.get((int)c).getNeighbors().get((int)n).id;
                for (int i = 0; i < clusters.get(c).size(); ++i) {
                    int index1 = clusters.get(c).get(i);
                    for (int j2 = 0; j2 < clusters.get(nc).size(); ++j2) {
                        int index2 = clusters.get(nc).get(j2);
                        float distance = metric.calculateDistance(points[index1], points[index2]);
                        this.addDistance((Vector)distanceList.get(index1), (Vector)idsList.get(index1), index2, distance);
                    }
                }
            }
        }
        Vector<Neighborhood> neighborhood = new Vector<Neighborhood>();
        for (int i = 0; i < idsList.size(); ++i) {
            Neighborhood neigh = new Neighborhood(i);
            neighborhood.add(neigh);
            for (j = 0; j < ((Vector)idsList.get(i)).size(); ++j) {
                neigh.addNeighbor(new Neighborhood.Neighbor(((Integer)((Vector)idsList.get(i)).get(j)).intValue(), ((Float)((Vector)distanceList.get(i)).get(j)).floatValue()));
            }
        }
        return neighborhood;
    }

    private boolean addDistance(Vector<Float> distancesList, Vector<Integer> idsList, int id, float value) {
        if (distancesList.elementAt(0).floatValue() > value) {
            int i;
            for (i = 0; i < distancesList.size() && distancesList.elementAt(i).floatValue() > value; ++i) {
                if (i >= distancesList.size() - 1) continue;
                distancesList.setElementAt(distancesList.elementAt(i + 1), i);
                idsList.setElementAt(idsList.elementAt(i + 1), i);
            }
            distancesList.setElementAt(Float.valueOf(value), i - 1);
            idsList.setElementAt(id, i - 1);
            return true;
        }
        return false;
    }

    private float[][] calculateCentroids(float[][] points, Vector<Vector<Integer>> clusters) {
        float[][] centroids = new float[clusters.size()][];
        for (int i = 0; i < clusters.size(); ++i) {
            centroids[i] = new float[points[0].length];
            Arrays.fill(centroids[i], 0.0f);
            for (int j = 0; j < clusters.get(i).size(); ++j) {
                for (int k = 0; k < centroids[i].length; ++k) {
                    float[] fArray = centroids[i];
                    int n = k;
                    fArray[n] = fArray[n] + points[clusters.get(i).get(j)][k];
                }
            }
            int k = 0;
            while (k < centroids[i].length) {
                float[] fArray = centroids[i];
                int n = k++;
                fArray[n] = fArray[n] / (float)clusters.get(i).size();
            }
        }
        return centroids;
    }
}

