/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileReader {
    private float[][] points;
    private float[] cdata;

    public FileReader(String filename) throws IOException {
        Vector points = new Vector();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new java.io.FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                StringTokenizer t = new StringTokenizer(line, " \t");
                Vector<Float> point = new Vector<Float>();
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    point.add(Float.valueOf(Float.parseFloat(token)));
                }
                points.add(point);
            }
            this.points = new float[points.size()][];
            this.cdata = new float[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                this.points[i] = new float[((Vector)points.elementAt(i)).size() - 1];
                for (int j = 0; j < ((Vector)points.elementAt(i)).size() - 1; ++j) {
                    this.points[i][j] = ((Float)((Vector)points.elementAt(i)).elementAt(j)).floatValue();
                }
                this.cdata[i] = ((Float)((Vector)points.elementAt(i)).elementAt(((Vector)points.elementAt(i)).size() - 1)).floatValue();
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File " + filename + " does not exist!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file " + filename + " : " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public float[][] getPoints() {
        return this.points;
    }

    public float[] getCdata() {
        return this.cdata;
    }
}

