/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Kmeans {
    private int numberClusters;
    private Vector<Vector<Integer>> clusters;
    private float[][] centroids;

    public Kmeans(int numberClusters) {
        this.numberClusters = numberClusters;
        this.clusters = new Vector();
    }

    public Vector<Vector<Integer>> doClustering(float[][] points) throws IOException {
        int i;
        boolean isCentroidModified = true;
        int numberIterations = 0;
        this.centroids = new float[this.numberClusters][];
        for (i = 0; i < this.numberClusters; ++i) {
            this.centroids[i] = new float[points[i].length];
            for (int j = 0; j < points[i].length; ++j) {
                this.centroids[i][j] = points[i][j];
            }
        }
        while (isCentroidModified && numberIterations < 30) {
            this.clusters.clear();
            for (i = 0; i < this.numberClusters; ++i) {
                this.clusters.add(new Vector());
            }
            for (int point = 0; point < points.length; ++point) {
                int nearestCentroid = 0;
                float distance1 = this.calculateDistance(points[point], this.centroids[nearestCentroid]);
                for (int cluster = 1; cluster < this.numberClusters; ++cluster) {
                    float distance2 = this.calculateDistance(points[point], this.centroids[cluster]);
                    if (!(distance1 > distance2)) continue;
                    nearestCentroid = cluster;
                    distance1 = distance2;
                }
                this.clusters.elementAt(nearestCentroid).add(point);
            }
            float[][] oldCentroids = this.centroids;
            this.updateCentroids(points);
            isCentroidModified = this.isCentroidModified(oldCentroids);
            ++numberIterations;
        }
        this.eliminateEmptyClusters();
        return this.clusters;
    }

    public float[][] getCentroids() {
        return this.centroids;
    }

    public int[] getMedoids(float[][] points) throws IOException {
        int[] m = new int[this.centroids.length];
        for (int i = 0; i < this.centroids.length; ++i) {
            int point = -1;
            float distance = Float.MAX_VALUE;
            for (int j = 0; j < this.clusters.elementAt(i).size(); ++j) {
                float distance2 = this.calculateDistance(this.centroids[i], points[this.clusters.elementAt(i).elementAt(j)]);
                if (!(distance > distance2)) continue;
                point = this.clusters.elementAt(i).elementAt(j);
                distance = distance2;
            }
            m[i] = point;
        }
        return m;
    }

    public abstract float calculateDistance(float[] var1, float[] var2) throws IOException;

    private void eliminateEmptyClusters() {
        int i;
        Vector<Integer> emptyClusters = new Vector<Integer>();
        for (i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i).size() != 0) continue;
            emptyClusters.add(i);
        }
        if (emptyClusters.size() > 0) {
            for (i = emptyClusters.size() - 1; i >= 0; --i) {
                this.clusters.removeElementAt((Integer)emptyClusters.get(i));
            }
            float[][] centroids_aux = new float[this.clusters.size()][];
            int j = 0;
            for (int i2 = 0; i2 < this.centroids.length; ++i2) {
                if (emptyClusters.contains(i2)) continue;
                centroids_aux[j] = this.centroids[i2];
                ++j;
            }
            this.centroids = centroids_aux;
        }
    }

    private void updateCentroids(float[][] points) {
        this.centroids = new float[this.numberClusters][];
        for (int centroid = 0; centroid < this.numberClusters; ++centroid) {
            this.centroids[centroid] = new float[points[centroid].length];
            for (int coord = 0; coord < points[centroid].length; ++coord) {
                this.centroids[centroid][coord] = 0.0f;
            }
        }
        for (int cluster = 0; cluster < this.numberClusters; ++cluster) {
            float[] coords = new float[points[0].length];
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = 0.0f;
            }
            for (int point = 0; point < this.clusters.get(cluster).size(); ++point) {
                int coord;
                for (coord = 0; coord < points[this.clusters.get(cluster).get(point)].length; ++coord) {
                    int n = coord;
                    coords[n] = coords[n] + points[this.clusters.get(cluster).get(point)][coord];
                }
                for (coord = 0; coord < points[this.clusters.get(cluster).get(point)].length; ++coord) {
                    this.centroids[cluster][coord] = coords[coord] / (float)this.clusters.get(cluster).size();
                }
            }
        }
    }

    private boolean isCentroidModified(float[][] oldCentroids) {
        for (int centroid = 0; centroid < oldCentroids.length; ++centroid) {
            for (int coord = 0; coord < oldCentroids[centroid].length; ++coord) {
                if (oldCentroids[centroid][coord] == this.centroids[centroid][coord]) continue;
                return true;
            }
        }
        return false;
    }
}

