/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import visualizer.PExWebApplet;
import visualizer.graph.Graph;
import visualizer.graph.GraphWriter;
import visualizer.graph.Vertex;
import visualizer.graph.XMLFilter;
import visualizer.graph.XMLGraphSaxReader;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.util.Kmeans;
import visualizer.view.BrowserControl;
import visualizer.view.CloseableTabbedPane;
import visualizer.view.GraphPanel;
import visualizer.view.InitialPanel;
import visualizer.view.SearchPanel;
import visualizer.view.ToolConfiguration;
import visualizer.view.label.CovarianceLabel;
import visualizer.view.label.Label;
import visualizer.web.patents.PatentsGetterPanel;
import visualizer.web.rss.RssGetterPanel;
import visualizer.web.websearch.WebSearchPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionExplorerWeb
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<GraphPanel> projections = new Vector();
    private GraphPanel visibleGraphPanel;
    private DefaultListModel nearestNeighborListModel = new DefaultListModel();
    private DefaultListModel pointsListModel = new DefaultListModel();
    private JFileChooser file = new JFileChooser();
    private PExWebApplet appletParent;
    private JButton cleanButton;
    private JToolBar commandsToolBar;
    private JToggleButton coordinatedSelectToggleButton;
    private JToggleButton createLabelToggleButton;
    private JButton createLabelsButton;
    private JToggleButton cutToggleButton;
    private JPanel docsPanel;
    private JSplitPane docsSplitPane;
    private JToolBar graphToolBar;
    private ButtonGroup graphToolsButtonGroup;
    private JToggleButton highlightLabelToggleButton;
    private JPanel mapPanel;
    private JTabbedPane mapTabbedPane;
    private JScrollPane nearestNeighborScrollPanel;
    private JList nearestNeighborsList;
    private JButton newSearchButton;
    private JButton openButton;
    private JButton patentDownloadButton;
    private JList pointsList;
    private JPanel pointsPanel;
    private JSplitPane pointsSplitPane;
    private JButton preferencesButton;
    private JButton rssDownloadButton;
    private JButton saveButton;
    private JScrollPane scrollPanePoints;
    private JToggleButton selectToggleButton;
    private JLabel separatorLabel;
    private JLabel separatorLabel2;
    private JLabel separatorLabel3;
    private JLabel separatorLabel4;
    private JLabel separatorLabel5;
    private JLabel separatorLabel6;
    private JLabel separatorLabel7;
    private JToggleButton showAllLabelsToggleButton;
    private JEditorPane snippetEditorPane;
    private JScrollPane snippetScrollPane;
    private JSplitPane toolSplitPane;
    private JToggleButton viewContentToggleButton;
    private JButton zoomInButton2;
    private JButton zoomOutButton2;

    public ProjectionExplorerWeb(PExWebApplet appletParent) {
        this.appletParent = appletParent;
        this.initComponents();
        this.setExtendedState(6);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.pointsSplitPane.setDividerLocation(d.height / 2);
        this.toolSplitPane.setDividerLocation(d.width / 3);
        this.mapTabbedPane.addTab("Welcome", InitialPanel.getInstance());
    }

    public ProjectionExplorerWeb() {
        this((PExWebApplet)null);
    }

    private void initComponents() {
        this.graphToolsButtonGroup = new ButtonGroup();
        this.toolSplitPane = new JSplitPane();
        this.pointsPanel = new JPanel();
        this.pointsSplitPane = new JSplitPane();
        this.scrollPanePoints = new JScrollPane();
        this.pointsList = new JList(this.pointsListModel);
        this.docsPanel = new JPanel();
        this.docsSplitPane = new JSplitPane();
        this.snippetScrollPane = new JScrollPane();
        this.snippetEditorPane = new JEditorPane();
        this.nearestNeighborScrollPanel = new JScrollPane();
        this.nearestNeighborsList = new JList(this.nearestNeighborListModel);
        this.mapPanel = new JPanel();
        this.mapTabbedPane = new CloseableTabbedPane();
        this.graphToolBar = new JToolBar();
        this.createLabelToggleButton = new JToggleButton();
        this.cutToggleButton = new JToggleButton();
        this.selectToggleButton = new JToggleButton();
        this.viewContentToggleButton = new JToggleButton();
        this.coordinatedSelectToggleButton = new JToggleButton();
        this.separatorLabel = new JLabel();
        this.cleanButton = new JButton();
        this.separatorLabel4 = new JLabel();
        this.createLabelsButton = new JButton();
        this.showAllLabelsToggleButton = new JToggleButton();
        this.highlightLabelToggleButton = new JToggleButton();
        this.commandsToolBar = new JToolBar();
        this.openButton = new JButton();
        this.saveButton = new JButton();
        this.separatorLabel5 = new JLabel();
        this.zoomInButton2 = new JButton();
        this.zoomOutButton2 = new JButton();
        this.separatorLabel2 = new JLabel();
        this.preferencesButton = new JButton();
        this.separatorLabel7 = new JLabel();
        this.newSearchButton = new JButton();
        this.separatorLabel3 = new JLabel();
        this.rssDownloadButton = new JButton();
        this.separatorLabel6 = new JLabel();
        this.patentDownloadButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Projection Explorer Web (PEx-Web)");
        this.toolSplitPane.setDividerLocation(200);
        this.toolSplitPane.setOneTouchExpandable(true);
        this.toolSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ProjectionExplorerWeb.this.toolSplitPanePropertyChange(evt);
            }
        });
        this.pointsPanel.setLayout(new BorderLayout());
        this.pointsSplitPane.setOrientation(0);
        this.scrollPanePoints.setBorder(BorderFactory.createTitledBorder("Retrieved Documents"));
        this.pointsList.setFont(new Font("Verdana", 1, 12));
        this.pointsList.setForeground(Color.blue);
        this.pointsList.setSelectionMode(0);
        this.pointsList.setToolTipText("Show retrieved documents");
        this.pointsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ProjectionExplorerWeb.this.pointsListMouseClicked(evt);
            }
        });
        this.pointsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ProjectionExplorerWeb.this.pointsListValueChanged(evt);
            }
        });
        this.scrollPanePoints.setViewportView(this.pointsList);
        this.pointsSplitPane.setLeftComponent(this.scrollPanePoints);
        this.docsPanel.setLayout(new BorderLayout());
        this.docsSplitPane.setOrientation(0);
        this.snippetScrollPane.setBorder(BorderFactory.createTitledBorder("Document Snippet"));
        this.snippetEditorPane.setToolTipText("Show slected document's content");
        this.snippetScrollPane.setViewportView(this.snippetEditorPane);
        this.docsSplitPane.setRightComponent(this.snippetScrollPane);
        this.nearestNeighborScrollPanel.setBorder(BorderFactory.createTitledBorder("Nearest Neighbors"));
        this.nearestNeighborsList.setFont(new Font("Verdana", 1, 12));
        this.nearestNeighborsList.setForeground(Color.blue);
        this.nearestNeighborsList.setSelectionMode(0);
        this.nearestNeighborsList.setToolTipText("Show selected document's  nearest neighbors");
        this.nearestNeighborsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ProjectionExplorerWeb.this.nearestNeighborsListMouseClicked(evt);
            }
        });
        this.nearestNeighborScrollPanel.setViewportView(this.nearestNeighborsList);
        this.docsSplitPane.setLeftComponent(this.nearestNeighborScrollPanel);
        this.docsPanel.add((Component)this.docsSplitPane, "Center");
        this.pointsSplitPane.setRightComponent(this.docsPanel);
        this.pointsPanel.add((Component)this.pointsSplitPane, "Center");
        this.toolSplitPane.setLeftComponent(this.pointsPanel);
        this.mapPanel.setLayout(new BorderLayout());
        this.mapTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ProjectionExplorerWeb.this.mapTabbedPaneStateChanged(evt);
            }
        });
        this.mapTabbedPane.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent evt) {
                ProjectionExplorerWeb.this.mapTabbedPaneComponentAdded(evt);
            }

            public void componentRemoved(ContainerEvent evt) {
                ProjectionExplorerWeb.this.mapTabbedPaneComponentRemoved(evt);
            }
        });
        this.mapPanel.add((Component)this.mapTabbedPane, "Center");
        this.graphToolBar.setOrientation(1);
        this.graphToolsButtonGroup.add(this.createLabelToggleButton);
        this.createLabelToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Information16.gif")));
        this.createLabelToggleButton.setSelected(true);
        this.createLabelToggleButton.setToolTipText("Create Labels");
        this.createLabelToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.createLabelToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.createLabelToggleButton);
        this.graphToolsButtonGroup.add(this.cutToggleButton);
        this.cutToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif")));
        this.cutToggleButton.setToolTipText("Cut  Projection");
        this.cutToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.cutToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.cutToggleButton);
        this.graphToolsButtonGroup.add(this.selectToggleButton);
        this.selectToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignCenter16.gif")));
        this.selectToggleButton.setToolTipText("Select Projection");
        this.selectToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.selectToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.selectToggleButton);
        this.graphToolsButtonGroup.add(this.viewContentToggleButton);
        this.viewContentToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif")));
        this.viewContentToggleButton.setToolTipText("View Content");
        this.viewContentToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.viewContentToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.viewContentToggleButton);
        this.graphToolsButtonGroup.add(this.coordinatedSelectToggleButton);
        this.coordinatedSelectToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif")));
        this.coordinatedSelectToggleButton.setToolTipText("Coordinated Projections");
        this.coordinatedSelectToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.coordinatedSelectToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.coordinatedSelectToggleButton);
        this.separatorLabel.setText("    ");
        this.graphToolBar.add(this.separatorLabel);
        this.cleanButton.setText("CL");
        this.cleanButton.setToolTipText("Clear projection");
        this.cleanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.cleanButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.cleanButton);
        this.separatorLabel4.setText("    ");
        this.graphToolBar.add(this.separatorLabel4);
        this.createLabelsButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/About16.gif")));
        this.createLabelsButton.setToolTipText("Create Label Based on Kmeans");
        this.createLabelsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.createLabelsButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.createLabelsButton);
        this.showAllLabelsToggleButton.setSelected(true);
        this.showAllLabelsToggleButton.setText("SL");
        this.showAllLabelsToggleButton.setToolTipText("Show all labels");
        this.showAllLabelsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.showAllLabelsToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.showAllLabelsToggleButton);
        this.highlightLabelToggleButton.setText("HL");
        this.highlightLabelToggleButton.setToolTipText("Highlight Labels");
        this.highlightLabelToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.highlightLabelToggleButtonActionPerformed(evt);
            }
        });
        this.graphToolBar.add(this.highlightLabelToggleButton);
        this.mapPanel.add((Component)this.graphToolBar, "East");
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.openButton.setToolTipText("Open projection");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.openButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.openButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.saveButton.setToolTipText("Save projection");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.saveButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.saveButton);
        this.separatorLabel5.setText("     ");
        this.commandsToolBar.add(this.separatorLabel5);
        this.zoomInButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.zoomInButton2.setToolTipText("Zoom in");
        this.zoomInButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.zoomInButton2ActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.zoomInButton2);
        this.zoomOutButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.zoomOutButton2.setToolTipText("Zoom out");
        this.zoomOutButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.zoomOutButton2ActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.zoomOutButton2);
        this.separatorLabel2.setText("     ");
        this.commandsToolBar.add(this.separatorLabel2);
        this.preferencesButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.preferencesButton.setToolTipText("Tool Preferences");
        this.preferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.preferencesButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.preferencesButton);
        this.separatorLabel7.setText("     ");
        this.commandsToolBar.add(this.separatorLabel7);
        this.newSearchButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/development/WebComponentAdd16.gif")));
        this.newSearchButton.setText("Web Search");
        this.newSearchButton.setToolTipText("Create a projection from a Web search");
        this.newSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.newSearchButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.newSearchButton);
        this.separatorLabel3.setText("     ");
        this.commandsToolBar.add(this.separatorLabel3);
        this.rssDownloadButton.setFont(new Font("Tahoma", 1, 11));
        this.rssDownloadButton.setIcon(new ImageIcon(this.getClass().getResource("/images/feed.gif")));
        this.rssDownloadButton.setText("RSS Getter");
        this.rssDownloadButton.setToolTipText("Create a projection from RSS news feeds");
        this.rssDownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.rssDownloadButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.rssDownloadButton);
        this.separatorLabel6.setText("     ");
        this.commandsToolBar.add(this.separatorLabel6);
        this.patentDownloadButton.setText("Patent Getter");
        this.patentDownloadButton.setToolTipText("Create a projection from RSS patentes");
        this.patentDownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectionExplorerWeb.this.patentDownloadButtonActionPerformed(evt);
            }
        });
        this.commandsToolBar.add(this.patentDownloadButton);
        this.mapPanel.add((Component)this.commandsToolBar, "North");
        this.toolSplitPane.setRightComponent(this.mapPanel);
        this.getContentPane().add((Component)this.toolSplitPane, "Center");
        this.pack();
    }

    private void pointsListValueChanged(ListSelectionEvent evt) {
    }

    private void patentDownloadButtonActionPerformed(ActionEvent evt) {
        PatentsGetterPanel search = new PatentsGetterPanel(this);
        this.mapTabbedPane.addTab("Patent Download", search);
        this.mapTabbedPane.setSelectedComponent(search);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.file.resetChoosableFileFilters();
        this.file.setAcceptAllFileFilterUsed(false);
        this.file.setFileFilter(new XMLFilter());
        this.file.setMultiSelectionEnabled(false);
        int result = this.file.showOpenDialog(this);
        if (result == 0) {
            String filename = this.file.getSelectedFile().getAbsolutePath();
            try {
                XMLGraphSaxReader reader = new XMLGraphSaxReader();
                Graph graph = reader.readGraphFromFile(filename);
                String description = reader.getDescription();
                StopwordListManager stpManager = reader.getStopwordListManager();
                this.addProjection(graph, description, stpManager);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.file.resetChoosableFileFilters();
            this.file.setAcceptAllFileFilterUsed(false);
            this.file.setFileFilter(new XMLFilter());
            this.file.setMultiSelectionEnabled(false);
            int result = this.file.showSaveDialog(this);
            if (result == 0) {
                String filename = this.file.getSelectedFile().getAbsolutePath();
                try {
                    String description = this.visibleGraphPanel.getTitle();
                    if (!this.file.getSelectedFile().getName().toLowerCase().endsWith(".xml")) {
                        filename = filename.concat(".xml");
                    }
                    StopwordsList stp = this.visibleGraphPanel.getStopwordsManager().getStopwordListManager().getStopwordListUsed();
                    GraphWriter w = new GraphWriter();
                    GraphWriter.saveAsXMLFile(this.visibleGraphPanel.getGraph(), stp.getStopwordListName(), description, filename);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void rssDownloadButtonActionPerformed(ActionEvent evt) {
        RssGetterPanel search = new RssGetterPanel(this);
        this.mapTabbedPane.addTab("RSS Download", search);
        this.mapTabbedPane.setSelectedComponent(search);
    }

    private void mapTabbedPaneComponentRemoved(ContainerEvent evt) {
        Component c;
        if (this.mapTabbedPane.getComponentCount() == 0) {
            this.mapTabbedPane.addTab("Welcome", InitialPanel.getInstance());
        }
        if ((c = this.mapTabbedPane.getSelectedComponent()) instanceof GraphPanel) {
            this.visibleGraphPanel = (GraphPanel)c;
        }
        this.mapTabbedPaneComponentAdded(evt);
    }

    private void mapTabbedPaneComponentAdded(ContainerEvent evt) {
        Component[] components;
        this.projections = new Vector();
        for (Component c : components = this.mapTabbedPane.getComponents()) {
            if (!(c instanceof GraphPanel)) continue;
            this.projections.add((GraphPanel)c);
        }
    }

    private void mapTabbedPaneStateChanged(ChangeEvent evt) {
        this.refreshPointsList();
    }

    private void newSearchButtonActionPerformed(ActionEvent evt) {
        WebSearchPanel search = new WebSearchPanel(this);
        this.mapTabbedPane.addTab("New Search", search);
        this.mapTabbedPane.setSelectedComponent(search);
    }

    private void cleanButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.cleanMarkedPoints();
            this.visibleGraphPanel.cleanLabels();
            this.visibleGraphPanel.cleanImage();
            this.visibleGraphPanel.repaint();
        }
    }

    private void preferencesButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            ToolConfiguration.getInstance(this).show(this, this.visibleGraphPanel.getGraph());
        } else {
            ToolConfiguration.getInstance(this).show(this, null);
        }
    }

    private void highlightLabelToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setHighlightLabel(!this.visibleGraphPanel.isHighlightLabel());
        }
    }

    private void showAllLabelsToggleButtonActionPerformed(ActionEvent evt) {
        Label.setShowLabel(!Label.isShowLabel());
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.repaint();
        }
    }

    private void createLabelsButtonActionPerformed(ActionEvent evt) {
        String inputValue;
        Graph graph;
        if (this.visibleGraphPanel != null && (graph = this.visibleGraphPanel.getGraph()) != null && (inputValue = (String)JOptionPane.showInputDialog(this, "Chose the number of clusters:", "Defining the Number of Clusters", 3, null, null, Integer.toString((int)Math.sqrt(graph.getVertex().size())))) != null) {
            int nclusters = Integer.parseInt(inputValue);
            try {
                float[][] points = new float[graph.getVertex().size()][];
                for (int i = 0; i < points.length; ++i) {
                    points[i] = new float[2];
                    points[i][0] = graph.getVertex().get(i).getX();
                    points[i][1] = graph.getVertex().get(i).getY();
                }
                Kmeans km = new Kmeans(nclusters){

                    public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
                        float sum = 0.0f;
                        float sub = 0.0f;
                        for (int i = 0; i < pointA.length; ++i) {
                            sub = pointA[i] - pointB[i];
                            sum += sub * sub;
                        }
                        return (float)Math.sqrt(sum);
                    }
                };
                Vector<Vector<Integer>> clusters = km.doClustering(points);
                int index = graph.addScalarName("kmeans-" + clusters.size());
                for (int c = 0; c < clusters.size(); ++c) {
                    for (int v = 0; v < clusters.get(c).size(); ++v) {
                        graph.getVertex().get(clusters.get(c).get(v)).setScalar(index, c);
                    }
                }
                graph.normalizeScalars(0.0f, 1.0f);
                StopwordsList stp = this.visibleGraphPanel.getStopwordsManager().getStopwordListManager().getStopwordListUsed();
                for (int c = 0; c < clusters.size(); ++c) {
                    Vector<Vertex> vertex = new Vector<Vertex>();
                    for (int v = 0; v < clusters.get(c).size(); ++v) {
                        vertex.add(graph.getVertex().get(clusters.get(c).get(v)));
                    }
                    CovarianceLabel label = new CovarianceLabel(vertex, stp);
                    this.visibleGraphPanel.getLabels().add(label);
                }
                this.visibleGraphPanel.repaint();
                this.visibleGraphPanel.refreshScalars("kmeans-" + clusters.size());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void coordinatedSelectToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setType(GraphPanel.SelectionType.COORD_SELECT);
        }
    }

    private void viewContentToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setType(GraphPanel.SelectionType.VIEW_CONTENT);
        }
    }

    private void selectToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setType(GraphPanel.SelectionType.SELECT_GRAPH);
        }
    }

    private void cutToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setType(GraphPanel.SelectionType.CUT_GRAPH);
        }
    }

    private void createLabelToggleButtonActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.setType(GraphPanel.SelectionType.CREATE_LABEL);
        }
    }

    private void toolSplitPanePropertyChange(PropertyChangeEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.cleanImage();
            this.visibleGraphPanel.repaint();
        }
    }

    private void nearestNeighborsListMouseClicked(MouseEvent evt) {
        Graph graph;
        if (this.visibleGraphPanel != null && (graph = this.visibleGraphPanel.getGraph()) != null) {
            JList source = (JList)evt.getSource();
            Vertex vertex = (Vertex)source.getSelectedValue();
            this.setDocumentSnippet(vertex);
            if (evt.getClickCount() == 2) {
                BrowserControl.displayURL(vertex.getWebElement().getUrl());
            }
            this.setDocumentSnippet(vertex);
        }
    }

    private void zoomOutButton2ActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.zoom(0.9091f);
        }
    }

    private void zoomInButton2ActionPerformed(ActionEvent evt) {
        if (this.visibleGraphPanel != null) {
            this.visibleGraphPanel.zoom(1.1f);
        }
    }

    private void pointsListMouseClicked(MouseEvent evt) {
        Graph graph;
        if (this.visibleGraphPanel != null && (graph = this.visibleGraphPanel.getGraph()) != null) {
            JList source = (JList)evt.getSource();
            Vertex vertex = (Vertex)source.getSelectedValue();
            this.setDocumentSnippet(vertex);
            if (vertex != null) {
                if (evt.getClickCount() == 1) {
                    this.visibleGraphPanel.markNeighbors(vertex);
                } else if (evt.getClickCount() == 2) {
                    BrowserControl.displayURL(vertex.getWebElement().getUrl());
                    this.visibleGraphPanel.markNeighbors(vertex);
                }
            }
        }
    }

    public void refreshPointsList() {
        this.nearestNeighborListModel.clear();
        Component component = this.mapTabbedPane.getSelectedComponent();
        if (component instanceof GraphPanel) {
            this.visibleGraphPanel = (GraphPanel)component;
            this.pointsListModel.clear();
            for (Vertex v : this.visibleGraphPanel.getGraph().getVertex()) {
                this.pointsListModel.addElement(v);
            }
        } else {
            this.visibleGraphPanel = null;
        }
    }

    public GraphPanel getGraphPanel() {
        return this.visibleGraphPanel;
    }

    public void setNearestNeighborsPoints(Vertex vertex, Vector<Vertex> vertices) {
        this.pointsList.setSelectedValue(vertex, true);
        this.setDocumentSnippet(vertex);
        this.nearestNeighborListModel.clear();
        for (Vertex v : vertices) {
            this.nearestNeighborListModel.addElement(v);
        }
    }

    public JList getPointsList() {
        return this.pointsList;
    }

    public void addProjection(Graph graph, SearchPanel searchPanel, StopwordListManager stpListManager) {
        GraphPanel panel = new GraphPanel(this, stpListManager, searchPanel.getQuery());
        panel.setGraph(graph);
        this.mapTabbedPane.remove(searchPanel);
        this.mapTabbedPane.addTab("[" + panel.getId() + "]:" + panel.getTitle(), panel);
        this.mapTabbedPane.setSelectedComponent(panel);
        this.visibleGraphPanel = panel;
    }

    public void addProjection(Graph graph, String description, StopwordListManager stpListManager) {
        GraphPanel panel = new GraphPanel(this, stpListManager, description);
        panel.setGraph(graph);
        this.mapTabbedPane.addTab("[" + panel.getId() + "]:" + panel.getTitle(), panel);
        this.mapTabbedPane.setSelectedComponent(panel);
        this.visibleGraphPanel = panel;
    }

    public Vector<GraphPanel> getProjections() {
        return this.projections;
    }

    public PExWebApplet getAppletParent() {
        return this.appletParent;
    }

    public void setDocumentSnippet(Vertex v) {
        this.snippetEditorPane.setContentType("text/html");
        String msg = "<html><font color=blue><u><b>" + v.getWebElement().getTitle() + "</b></u></font>" + "<br><font color=gray>" + v.getWebElement().getDate() + "</font>" + "<br>" + v.getWebElement().getSnippet() + "<br>" + "<font color=green>" + v.getWebElement().getUrl() + "</font></html>";
        this.snippetEditorPane.setText(msg);
        this.snippetEditorPane.setCaretPosition(0);
    }
}

