/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import visualizer.graph.Vertex;

public class VertexCell
extends JPanel {
    private Vertex vertex;
    private JEditorPane contentViewEditorPane;
    private JPanel internalPanel;

    public VertexCell(Vertex vertex) {
        this.vertex = vertex;
        this.initComponents();
        this.contentViewEditorPane.setContentType("text/html");
        String msg = "<html><font color=blue><u><b>" + vertex.getWebElement().getTitle() + "</b></u></font><br>" + vertex.getWebElement().getSnippet() + "<br>" + "<font color=green>" + vertex.getWebElement().getUrl() + "</font></html>";
        this.contentViewEditorPane.setText(msg);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.setSize(d.width / 2, d.height / 6);
        this.setPreferredSize(new Dimension(d.width / 2, d.height / 6));
        this.setLayout(new GridBagLayout());
        this.internalPanel.setSize(d.width / 2 - 6, d.height / 6 - 6);
        this.internalPanel.setPreferredSize(new Dimension(d.width / 2 - 6, d.height / 6 - 6));
        this.internalPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 2, Color.BLACK));
    }

    private void initComponents() {
        this.internalPanel = new JPanel();
        this.contentViewEditorPane = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.internalPanel.setLayout(new BorderLayout());
        this.contentViewEditorPane.setEditable(false);
        this.contentViewEditorPane.setAutoscrolls(false);
        this.internalPanel.add((Component)this.contentViewEditorPane, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.internalPanel, gridBagConstraints);
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public JEditorPane getContentViewEditorPane() {
        return this.contentViewEditorPane;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            return this.vertex.equals(((VertexCell)obj).vertex);
        }
        return false;
    }
}

