/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.label;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import visualizer.graph.Vertex;
import visualizer.preprocessing.Ngram;
import visualizer.preprocessing.Preprocessor;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.view.label.Label;
import visualizer.view.label.StringBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovarianceLabel
extends Label {
    public CovarianceLabel(Vector<Vertex> vertex, StopwordsList stp) {
        super(vertex);
        this.createLabel(vertex, stp);
    }

    @Override
    protected void createLabel(Vector<Vertex> vertex, StopwordsList stp) {
        try {
            int lowercut = 2;
            int uppercut = -1;
            int ngrams = 1;
            int matrixtype = 1;
            if (vertex.size() > 50 && vertex.size() < 100) {
                lowercut = 10;
            } else if (vertex.size() > 100 && vertex.size() < 300) {
                lowercut = 15;
            } else if (vertex.size() > 300) {
                lowercut = 20;
            }
            Preprocessor pp = new Preprocessor();
            float[][] points = pp.getMatrix(lowercut, uppercut, ngrams, matrixtype, false, vertex, stp);
            ArrayList<Ngram> cpNgrams = pp.getNgrams();
            Vector<String> indexGrams = new Vector<String>();
            points = this.cutDimensions(points, cpNgrams, indexGrams);
            this.createLabel(points, indexGrams);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createLabel(float[][] points, Vector<String> attributes) {
        float[] mean = new float[points.length];
        Arrays.fill(mean, 0.0f);
        for (int i = 0; i < points.length; ++i) {
            int j;
            for (j = 0; j < points[i].length; ++j) {
                int n = i;
                mean[n] = mean[n] + points[i][j];
            }
            int n = i;
            mean[n] = mean[n] / (float)points[i].length;
            j = 0;
            while (j < points[i].length) {
                float[] fArray = points[i];
                int n2 = j++;
                fArray[n2] = fArray[n2] - mean[i];
            }
        }
        Vector<Integer> indexes = new Vector<Integer>();
        this.boxes.add(this.createStringBoxes(points, attributes, indexes));
    }

    private StringBox createStringBoxes(float[][] points, Vector<String> attributes, Vector<Integer> indexes) {
        float aux;
        float gcov1 = Float.MIN_VALUE;
        int icov = 0;
        int jcov = 0;
        for (int i = 0; i < points[0].length - 1; ++i) {
            for (int j = points[0].length - 1; j > i; --j) {
                if (indexes.contains(i) || indexes.contains(j) || !(gcov1 < (aux = this.covariance(points, i, j)))) continue;
                gcov1 = aux;
                icov = i;
                jcov = j;
            }
        }
        indexes.add(icov);
        indexes.add(jcov);
        String msg = "[" + attributes.get(icov).replaceAll("<>", "") + "," + attributes.get(jcov).replaceAll("<>", "") + ",";
        for (int i = 0; i < points[0].length - 1; ++i) {
            if (indexes.contains(i) || !((aux = (this.covariance(points, icov, i) + this.covariance(points, jcov, i)) / 2.0f) / gcov1 > 0.75f)) continue;
            msg = msg + attributes.get(i).replaceAll("<>", "") + ",";
        }
        msg = msg.substring(0, msg.length() - 1) + "]";
        return new StringBox(msg);
    }

    private float[][] cutDimensions(float[][] points, ArrayList<Ngram> cpNgrams, Vector<String> indexGrams) {
        int i;
        float[][] newpoints = new float[points.length][];
        for (i = 0; i < points.length; ++i) {
            newpoints[i] = new float[points[i].length < 200 ? points[i].length : 200];
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = points[i][j];
            }
        }
        indexGrams.clear();
        for (i = 0; i < newpoints[0].length; ++i) {
            indexGrams.add(cpNgrams.get((int)i).ngram);
        }
        return newpoints;
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)(points.length - 1);
    }
}

