/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.rss;

import java.util.Vector;
import org.horrabin.horrorss.RssItemBean;
import org.horrabin.horrorss.RssParser;
import visualizer.view.SearchPanel;
import visualizer.web.WebElement;
import visualizer.web.rss.RSSWebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssGetter {
    private Vector<String> links;

    public RssGetter(Vector<String> links) {
        this.links = links;
    }

    public void executeDownload(SearchPanel rssPanel) {
        this.run(rssPanel);
    }

    private void run(final SearchPanel rssPanel) {
        Thread t = new Thread(){
            private Vector<String> urlIndex = new Vector();

            public void run() {
                Vector<WebElement> webElements = new Vector<WebElement>();
                rssPanel.setQueryStatus("Retrieving rss documents...", 0);
                int count = 0;
                for (int i = 0; i < RssGetter.this.links.size(); ++i) {
                    RssParser rss = new RssParser(((String)RssGetter.this.links.get(i)).trim());
                    rss.parse();
                    Vector items = rss.getItems();
                    for (RssItemBean b : items) {
                        RSSWebElement we = new RSSWebElement(b, this.getUrlSource(b.getLink()));
                        if (webElements.contains(we)) continue;
                        webElements.add(we);
                    }
                    rssPanel.setQueryStatus("Retrieving rss documents...", ++count);
                }
                rssPanel.queryFinished(webElements);
            }

            private int getUrlSource(String url) {
                int begin = url.indexOf(".");
                int end = url.indexOf("/", begin + 1);
                if (end - begin > 0) {
                    String source = url.substring(begin + 1, end);
                    if (!this.urlIndex.contains(source)) {
                        this.urlIndex.add(source);
                    }
                    return this.urlIndex.indexOf(source);
                }
                return -1;
            }
        };
        t.start();
    }
}

