/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.rss;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.projection.GraphBuilder;
import visualizer.projection.GraphBuilderListener;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.SearchPanel;
import visualizer.view.ToolConfiguration;
import visualizer.web.WebElement;
import visualizer.web.rss.RssGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssGetterPanel
extends SearchPanel
implements GraphBuilderListener {
    private DefaultTableModel linksModel;
    private JButton addLinkButton;
    private JPanel buttonPanel;
    private JButton downloadButton;
    private JPanel linksPanel;
    private JScrollPane linksScrollPane;
    private JTable linksTable;
    private JButton removeLinkButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public RssGetterPanel(ProjectionExplorerWeb view) {
        super(view);
        this.initComponents();
        this.initModels();
        this.linksTable.setModel(this.linksModel);
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/sportonline_world_edition/front_page/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/business/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/uk_politics/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/health/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/health/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/education/rss.xml"});
        this.linksModel.addRow(new String[]{"http://newsrss.bbc.co.uk/rss/newsonline_uk_edition/sci/tech/rss.xml"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_topstories.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_world.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_allpolitics.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_law.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_tech.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_space.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_health.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_showbiz.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_travel.rss"});
        this.linksModel.addRow(new String[]{"http://rss.cnn.com/rss/cnn_education.rss"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/SPTBASEBALL-rss_2.0.xml?SITE=NCMOR&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/TOPHEADS-rss_2.0.xml?SITE=NDBIS&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/USHEADS-rss_2.0.xml?SITE=AZMES&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/WORLDHEADS-rss_2.0.xml?SITE=ININS&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/POLITICSHEADS-rss_2.0.xml?SITE=NCMOR&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/BUSINESSHEADS-rss_2.0.xml?SITE=NCWIN&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/TECHHEADS-rss_2.0.xml?SITE=MAHYC&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/SPORTSHEADS-rss_2.0.xml?SITE=NYWHI&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/ENTERTAINMENT-rss_2.0.xml?SITE=PAYOK&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/HEALTHHEADS-rss_2.0.xml?SITE=NCCON&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://hosted.ap.org/lineups/SCIENCEHEADS-rss_2.0.xml?SITE=NJHAC&SECTION=HOME"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/globalCoverage2/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/topNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/domesticNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/smallBusinessNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/worldNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/politicsNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/entertainment/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/technologyNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/scienceNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/internetNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/sportsNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/healthNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/oddlyEnoughNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/inDepthNews/"});
        this.linksModel.addRow(new String[]{"http://feeds.reuters.com/reuters/environment/"});
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusProgressBar = new JProgressBar();
        this.linksPanel = new JPanel();
        this.linksScrollPane = new JScrollPane();
        this.linksTable = new JTable();
        this.buttonPanel = new JPanel();
        this.addLinkButton = new JButton();
        this.removeLinkButton = new JButton();
        this.downloadButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusLabel.setText("status");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.statusProgressBar, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.statusPanel, gridBagConstraints);
        this.linksPanel.setLayout(new BorderLayout());
        this.linksPanel.setBorder(BorderFactory.createTitledBorder("Links of RSS Sources"));
        this.linksScrollPane.setPreferredSize(new Dimension(400, 300));
        this.linksTable.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                RssGetterPanel.this.linksTableFocusLost(evt);
            }
        });
        this.linksScrollPane.setViewportView(this.linksTable);
        this.linksPanel.add((Component)this.linksScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.linksPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new BorderLayout());
        this.addLinkButton.setText("Remove Link");
        this.addLinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RssGetterPanel.this.addLinkButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.addLinkButton, "Center");
        this.removeLinkButton.setText("Add Link");
        this.removeLinkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RssGetterPanel.this.removeLinkButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.removeLinkButton, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.downloadButton.setText("Execute");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RssGetterPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.downloadButton, gridBagConstraints);
    }

    private void linksTableFocusLost(FocusEvent evt) {
        this.linksTable.editCellAt(0, 0);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        if (this.linksModel.getRowCount() > 0) {
            Vector<String> links = new Vector<String>();
            for (int i = 0; i < this.linksModel.getRowCount(); ++i) {
                String link = (String)this.linksModel.getValueAt(i, 0);
                if (link.trim().length() <= 0) continue;
                links.add(link);
            }
            this.statusProgressBar.setValue(0);
            this.statusProgressBar.setMaximum(links.size());
            this.downloadButton.setEnabled(false);
            RssGetter getter = new RssGetter(links);
            getter.executeDownload(this);
        } else {
            JOptionPane.showMessageDialog(this, "A link for a RSS source must be provided!", "Error", 0);
        }
    }

    private void addLinkButtonActionPerformed(ActionEvent evt) {
        int index = this.linksTable.getSelectedRow();
        if (index != -1) {
            this.linksModel.removeRow(index);
        }
    }

    private void removeLinkButtonActionPerformed(ActionEvent evt) {
        this.linksModel.addRow(new String[]{""});
        this.linksTable.editCellAt(this.linksModel.getRowCount() - 1, 0);
        this.linksTable.requestFocusInWindow();
    }

    @Override
    public void queryFinished(Vector<WebElement> pages) {
        if (pages.size() > 0) {
            Vector<Vertex> vertex = new Vector<Vertex>();
            for (int i = 0; i < pages.size(); ++i) {
                Vertex v = new Vertex(pages.get(i), i);
                vertex.add(v);
            }
            Graph graph = new Graph();
            graph.setVertex(vertex);
            StopwordListManager stpManager = new StopwordListManager();
            stpManager.changeStopwordList("English RSS-News");
            GraphBuilder builder = new GraphBuilder(graph, stpManager);
            ToolConfiguration tool = ToolConfiguration.getInstance(this.view);
            builder.setFractionDelta(tool.getFracDelta());
            builder.setMatrixType(tool.getMatrixType());
            builder.setMax(tool.getMax());
            builder.setMin(tool.getMin());
            builder.setNrConnections(tool.getNrConnections());
            builder.setNrIterations(tool.getNrIterations());
            builder.setNrNeighbors(tool.getNrNeighbors());
            builder.setNumberGrams(tool.getNrGrams());
            builder.setStemming(tool.isStemming());
            builder.setReducting(tool.isReducing());
            builder.setTargetReduction(tool.getDimensions());
            builder.start(this);
        } else {
            this.statusProgressBar.setValue(0);
            this.downloadButton.setEnabled(true);
            JOptionPane.showMessageDialog(this, "None documents were retrieved.\nPlease add more RSS links.", "Error", 0);
        }
    }

    @Override
    public void projectionFinished(Graph graph, StopwordListManager stpListManager) {
        this.view.addProjection(graph, this, stpListManager);
    }

    @Override
    public void setProjectionStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void setQueryStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public String getQuery() {
        return new String("RSS source");
    }

    private void initModels() {
        Object[] titulos = new String[]{"RSS Links"};
        this.linksModel = new DefaultTableModel((Object[][])null, titulos);
    }
}

