/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.websearch;

import com.yahoo.search.SearchClient;
import com.yahoo.search.SearchException;
import com.yahoo.search.WebSearchRequest;
import com.yahoo.search.WebSearchResult;
import com.yahoo.search.WebSearchResults;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import visualizer.view.SearchPanel;
import visualizer.web.WebElement;
import visualizer.web.websearch.WebResultElement;

public class WebGetter {
    private String query;
    private int numberDocuments;

    public WebGetter(String query, int numberDocuments) {
        this.query = query;
        this.numberDocuments = numberDocuments;
    }

    public void executeQuery(SearchPanel searchPanel) {
        this.run(searchPanel);
    }

    private void run(final SearchPanel searchPanel) {
        Thread t = new Thread(){

            public void run() {
                Vector<WebElement> pages = new Vector<WebElement>();
                SearchClient client = new SearchClient("javasdktest");
                WebSearchRequest request = new WebSearchRequest(WebGetter.this.query);
                request.setResults(50);
                searchPanel.setQueryStatus("Retrieving documents...", 0);
                int i = 0;
                int count = 0;
                int countAnt = -1;
                while (count < WebGetter.this.numberDocuments) {
                    request.setStart(BigInteger.valueOf(50 * i));
                    try {
                        WebSearchResults results = client.webSearch(request);
                        for (int j = 0; j < results.listResults().length; ++j) {
                            WebSearchResult elem = results.listResults()[j];
                            WebResultElement p = new WebResultElement(elem, count);
                            if (pages.contains(p)) continue;
                            pages.add(p);
                            searchPanel.setQueryStatus("Retrieving documents...", ++count);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (SearchException e) {
                        e.printStackTrace();
                    }
                    if (countAnt == count) break;
                    countAnt = count;
                    ++i;
                }
                searchPanel.queryFinished(pages);
            }
        };
        t.start();
    }
}

