/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.DocumentSource;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseHandler;
import com.hp.hpl.sparta.ParseLog;
import com.hp.hpl.sparta.ParseSource;
import com.hp.hpl.sparta.Text;

class BuildDocument
implements DocumentSource,
ParseHandler {
    private final ParseLog log_;
    private Element currentElement_ = null;
    private final Document doc_ = new Document();
    private ParseSource parseSource_ = null;

    public BuildDocument() {
        this(null);
    }

    public BuildDocument(ParseLog parseLog) {
        this.log_ = parseLog == null ? ParseSource.DEFAULT_LOG : parseLog;
    }

    public void setParseSource(ParseSource parseSource) {
        this.parseSource_ = parseSource;
        this.doc_.setSystemId(parseSource.toString());
    }

    public ParseSource getParseSource() {
        return this.parseSource_;
    }

    public String toString() {
        if (this.parseSource_ != null) {
            return "BuildDoc: " + this.parseSource_.toString();
        }
        return null;
    }

    public String getSystemId() {
        if (this.parseSource_ != null) {
            return this.parseSource_.getSystemId();
        }
        return null;
    }

    public int getLineNumber() {
        if (this.parseSource_ != null) {
            return this.parseSource_.getLineNumber();
        }
        return -1;
    }

    public Document getDocument() {
        return this.doc_;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(Element element) {
        if (this.currentElement_ == null) {
            this.doc_.setDocumentElement(element);
        } else {
            this.currentElement_.appendChild(element);
        }
        this.currentElement_ = element;
    }

    public void endElement(Element element) {
        this.currentElement_ = this.currentElement_.getParentNode();
    }

    public void characters(char[] cArray, int n, int n2) {
        Element element = this.currentElement_;
        if (element.getLastChild() instanceof Text) {
            Text text = (Text)element.getLastChild();
            text.appendData(cArray, n, n2);
        } else {
            Text text = new Text(new String(cArray, n, n2));
            element.appendChildNoChecking(text);
        }
    }

    private boolean isCENull() {
        if (this.currentElement_ == null) {
            this.log_.warning("currentElement is null", this.getSystemId(), this.getLineNumber());
            return true;
        }
        return false;
    }
}

