/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.DOMException;
import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.BooleanExprVisitor;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.NodeTest;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Node
implements Cloneable {
    private Document doc_ = null;
    private Element parentNode_ = null;
    private Node previousSibling_ = null;
    private Node nextSibling_ = null;
    private Object annotation_ = null;

    void notifyObservers() {
        if (this.doc_ != null) {
            this.doc_.notifyObservers();
        }
    }

    void setOwnerDocument(Document document) {
        this.doc_ = document;
    }

    public Document getOwnerDocument() {
        return this.doc_;
    }

    public Element getParentNode() {
        return this.parentNode_;
    }

    public Node getPreviousSibling() {
        return this.previousSibling_;
    }

    public Node getNextSibling() {
        return this.nextSibling_;
    }

    public Object getAnnotation() {
        return this.annotation_;
    }

    public void setAnnotation(Object object) {
        this.annotation_ = object;
    }

    void setParentNode(Element element) {
        this.parentNode_ = element;
    }

    void insertAtEndOfLinkedList(Node node) {
        this.previousSibling_ = node;
        if (node != null) {
            node.nextSibling_ = this;
        }
    }

    void removeFromLinkedList() {
        if (this.previousSibling_ != null) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
    }

    void replaceInLinkedList(Node node) {
        if (this.previousSibling_ != null) {
            this.previousSibling_.nextSibling_ = node;
        }
        if (this.nextSibling_ != null) {
            this.nextSibling_.previousSibling_ = node;
        }
        node.nextSibling_ = this.nextSibling_;
        node.previousSibling_ = this.previousSibling_;
        this.nextSibling_ = null;
        this.previousSibling_ = null;
    }

    public String toXml() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.toXml(stringWriter);
        return stringWriter.toString();
    }

    public void xpathSetStrings(String string, String string2) throws ParseException {
        try {
            int n = string.lastIndexOf("/");
            if (!string.substring(n + 1).equals("text()") && string.charAt(n + 1) != '@') {
                throw new ParseException("Last step of Xpath expression \"" + string + "\" is not \"text()\" and does not start with a '@'. It starts with a '" + string.charAt(n + 1) + "'");
            }
            String string3 = string.substring(0, n);
            if (string.charAt(n + 1) == '@') {
                String string4 = string.substring(n + 2);
                if (string4.length() == 0) {
                    throw new ParseException("Xpath expression \"" + string + "\" specifies zero-length attribute name\"");
                }
                Enumeration enumeration = this.xpathSelectElements(string3);
                while (enumeration.hasMoreElements()) {
                    Element element = (Element)enumeration.nextElement();
                    element.setAttribute(string4, string2);
                }
            } else {
                Enumeration enumeration = this.xpathSelectElements(string3);
                while (enumeration.hasMoreElements()) {
                    Text text;
                    Element element = (Element)enumeration.nextElement();
                    LinkedList<Text> linkedList = new LinkedList<Text>();
                    Node node = element.getFirstChild();
                    while (node != null) {
                        if (node instanceof Text) {
                            linkedList.add((Text)node);
                        }
                        node = node.getNextSibling();
                    }
                    if (linkedList.size() == 0) {
                        text = new Text(string2);
                        element.appendChild(text);
                        continue;
                    }
                    text = (Text)linkedList.remove(0);
                    text.setData(string2);
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        Text text2 = (Text)iterator.next();
                        element.removeChild(text2);
                    }
                }
            }
        }
        catch (DOMException dOMException) {
            throw new Error("Assertion failed " + dOMException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException("Xpath expression \"" + string + "\" is not in the form \"xpathExpression/@attributeName\"");
        }
    }

    Element makeMatching(final Element element, Step step, final String string) throws ParseException, XPathException {
        NodeTest nodeTest = step.getNodeTest();
        if (!(nodeTest instanceof ElementTest)) {
            throw new ParseException("\"" + nodeTest + "\" in \"" + string + "\" is not an element test");
        }
        ElementTest elementTest = (ElementTest)nodeTest;
        final String string2 = elementTest.getTagName();
        final Element element2 = new Element(string2);
        BooleanExpr booleanExpr = step.getPredicate();
        booleanExpr.accept(new BooleanExprVisitor(){

            public void visit(TrueExpr trueExpr) {
            }

            public void visit(AttrExistsExpr attrExistsExpr) throws XPathException {
                element2.setAttribute(attrExistsExpr.getAttrName(), "something");
            }

            public void visit(AttrEqualsExpr attrEqualsExpr) throws XPathException {
                element2.setAttribute(attrEqualsExpr.getAttrName(), attrEqualsExpr.getAttrValue());
            }

            public void visit(AttrNotEqualsExpr attrNotEqualsExpr) throws XPathException {
                element2.setAttribute(attrNotEqualsExpr.getAttrName(), "not " + attrNotEqualsExpr.getAttrValue());
            }

            public void visit(AttrLessExpr attrLessExpr) throws XPathException {
                element2.setAttribute(attrLessExpr.getAttrName(), Double.toString(Double.MIN_VALUE));
            }

            public void visit(AttrGreaterExpr attrGreaterExpr) throws XPathException {
                element2.setAttribute(attrGreaterExpr.getAttrName(), Double.toString(Double.MAX_VALUE));
            }

            public void visit(TextExistsExpr textExistsExpr) throws XPathException {
                element2.appendChild(new Text("something"));
            }

            public void visit(TextEqualsExpr textEqualsExpr) throws XPathException {
                element2.appendChild(new Text(textEqualsExpr.getValue()));
            }

            public void visit(TextNotEqualsExpr textNotEqualsExpr) throws XPathException {
                element2.appendChild(new Text("not " + textNotEqualsExpr.getValue()));
            }

            public void visit(PositionEqualsExpr positionEqualsExpr) throws XPathException {
                int n = positionEqualsExpr.getPosition();
                if (element == null && n != 1) {
                    throw new XPathException(XPath.get(string), "Position of root node must be 1");
                }
                int n2 = 1;
                while (n2 < n) {
                    element.appendChild(new Element(string2));
                    ++n2;
                }
            }
        });
        return element2;
    }

    public abstract Enumeration xpathSelectElements(String var1) throws ParseException;

    public abstract Enumeration xpathSelectStrings(String var1) throws ParseException;

    public abstract Element xpathSelectElement(String var1) throws ParseException;

    public abstract String xpathSelectString(String var1) throws ParseException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("assertion failed " + cloneNotSupportedException);
        }
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.toString(stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    abstract void toString(Writer var1) throws IOException;

    abstract void toXml(Writer var1) throws IOException;

    protected static void htmlEncode(Writer writer, String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string2;
            char c = string.charAt(n3);
            if (c >= '\u0080') {
                string2 = "&#" + c + ";";
            } else {
                switch (c) {
                    case '<': {
                        string2 = "&lt;";
                        break;
                    }
                    case '>': {
                        string2 = "&gt;";
                        break;
                    }
                    case '&': {
                        string2 = "&amp;";
                        break;
                    }
                    case '\"': {
                        string2 = "&quot;";
                        break;
                    }
                    default: {
                        string2 = null;
                    }
                }
            }
            if (string2 != null) {
                writer.write(string, n2, n3 - n2);
                writer.write(string2);
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (n2 < n) {
            writer.write(string, n2, n - n2);
        }
    }
}

